/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Session;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class BeanSession
extends Session {
    private final BeanContext ctx;
    private final Locale locale;
    private final TimeZone timeZone;
    private final MediaType mediaType;
    private final boolean debug;
    private final HttpPartSchema schema;
    private Stack<StringBuilder> sbStack = new Stack();

    protected BeanSession(BeanContext ctx, BeanSessionArgs args) {
        super(args);
        this.ctx = ctx;
        this.locale = ObjectUtils.firstNonNull(args.locale, ctx.getLocale(), Locale.getDefault());
        this.timeZone = ObjectUtils.firstNonNull(args.timeZone, ctx.getTimeZone());
        this.debug = ObjectUtils.firstNonNull(args.debug, ctx.isDebug(), false);
        this.schema = args.schema;
        this.mediaType = ObjectUtils.firstNonNull(args.mediaType, ctx.getMediaType());
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().appendAll(this.ctx.asMap()).append("BeanSession", new ObjectMap().append("debug", this.debug).append("locale", this.locale).append("schema", this.schema).append("mediaType", this.mediaType).append("timeZone", this.timeZone));
    }

    public final <T> T convertToType(Object value, Class<T> type) throws InvalidDataConversionException {
        if (value != null && value.getClass() == type) {
            return (T)value;
        }
        return this.convertToMemberType(null, value, this.getClassMeta(type));
    }

    public final <T> T convertToMemberType(Object outer, Object value, Class<T> type) throws InvalidDataConversionException {
        return this.convertToMemberType(outer, value, this.getClassMeta(type));
    }

    public final <T> T convertToType(Object value, ClassMeta<T> type) throws InvalidDataConversionException {
        return this.convertToMemberType(null, value, type);
    }

    public final <T> T convertToType(Object value, Type type, Type ... args) throws InvalidDataConversionException {
        return this.convertToMemberType(null, value, this.getClassMeta(type, args));
    }

    /*
     * Exception decompiling
     */
    protected final <T> T convertToMemberType(Object outer, Object value, ClassMeta<T> to) throws InvalidDataConversionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean hasTransform(ClassMeta<?> from, ClassMeta<?> to) {
        return to.hasTransformFrom(from) || from.hasTransformTo(to);
    }

    private static final boolean isNullOrEmpty(Object o) {
        return o == null || o.toString().equals("") || o.toString().equals("null");
    }

    private static int getMultiplier(String s) {
        if (s.endsWith("G")) {
            return 0x40000000;
        }
        if (s.endsWith("M")) {
            return 0x100000;
        }
        if (s.endsWith("K")) {
            return 1024;
        }
        return 1;
    }

    protected final Object toArray(ClassMeta<?> type, Collection<?> list) {
        if (list == null) {
            return null;
        }
        ClassMeta<Object> componentType = type.isArgs() ? this.object() : type.getElementType();
        Object array = Array.newInstance(componentType.getInnerClass(), list.size());
        int i = 0;
        for (Object o : list) {
            if (!type.getInnerClass().isInstance(o)) {
                o = componentType.isArray() && o instanceof Collection ? this.toArray(componentType, (Collection)o) : (o == null && componentType.isPrimitive() ? componentType.getPrimitiveDefault() : this.convertToType(o, componentType));
            }
            try {
                Array.set(array, i++, o);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return array;
    }

    public final <T> BeanMap<T> toBeanMap(T o) {
        return this.toBeanMap(o, o.getClass());
    }

    public final boolean isBean(Object o) {
        if (o == null) {
            return false;
        }
        return this.isBean(o.getClass());
    }

    public final boolean isBean(Class<?> c) {
        return this.getBeanMeta(c) != null;
    }

    public final <T> BeanMap<T> toBeanMap(T o, Class<? super T> c) throws BeanRuntimeException {
        ClassMeta<T> cm;
        BeanMeta<? super T> m;
        ThrowableUtils.assertFieldNotNull(o, "o");
        ThrowableUtils.assertFieldNotNull(c, "c");
        if (!c.isInstance(o)) {
            ThrowableUtils.illegalArg("The specified object is not an instance of the specified class.  class=''{0}'', objectClass=''{1}'', object=''{2}''", c.getName(), o.getClass().getName(), 0);
        }
        if ((m = (cm = this.getClassMeta(c)).getBeanMeta()) == null) {
            throw new BeanRuntimeException(c, "Class is not a bean.  Reason=''{0}''", cm.getNotABeanReason());
        }
        return new BeanMap<T>(this, o, m);
    }

    public final <T> BeanMap<T> newBeanMap(Class<T> c) {
        return this.newBeanMap(null, c);
    }

    public final <T> BeanMap<T> newBeanMap(Object outer, Class<T> c) {
        BeanMeta<T> m = this.getBeanMeta(c);
        if (m == null) {
            return null;
        }
        Object bean = null;
        if (m.constructorArgs.length == 0) {
            bean = this.newBean(outer, c);
        }
        return new BeanMap<Object>(this, bean, (BeanMeta<Object>)m);
    }

    public final <T> T newBean(Class<T> c) throws BeanRuntimeException {
        return this.newBean(null, c);
    }

    public final <T> T newBean(Object outer, Class<T> c) throws BeanRuntimeException {
        ClassMeta<T> cm = this.getClassMeta(c);
        BeanMeta<T> m = cm.getBeanMeta();
        if (m == null) {
            return null;
        }
        try {
            T o = m.newBean(outer);
            if (o == null) {
                throw new BeanRuntimeException(c, "Class does not have a no-arg constructor.", new Object[0]);
            }
            return o;
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
    }

    public final <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        if (c == null) {
            return null;
        }
        return this.getClassMeta(c).getBeanMeta();
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> c) {
        return this.ctx.getClassMeta(c);
    }

    public final <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.ctx.getClassMeta(type, args);
    }

    protected final ClassMeta<Object[]> getArgsClassMeta(Type[] classes) {
        ThrowableUtils.assertFieldNotNull(classes, "classes");
        ClassMeta[] cm = new ClassMeta[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            cm[i] = this.getClassMeta(classes[i], new Type[0]);
        }
        return new ClassMeta<Object[]>(cm);
    }

    public final <T> ClassMeta<T> getClassMetaForObject(T o) {
        if (o == null) {
            return null;
        }
        return this.getClassMeta(o.getClass());
    }

    public final String getBeanTypePropertyName(ClassMeta cm) {
        String s = cm == null ? null : cm.getBeanTypePropertyName();
        return s == null ? this.getBeanTypePropertyName() : s;
    }

    protected final BeanRegistry getBeanRegistry() {
        return this.ctx.getBeanRegistry();
    }

    public <T> T newInstance(Class<T> c, Object c2) {
        return this.ctx.newInstance(c, c2);
    }

    public <T> T newInstance(Class<T> c, Object c2, boolean fuzzyArgs, Object ... args) {
        return this.ctx.newInstance(c, c2, fuzzyArgs, args);
    }

    public <T> T newInstanceFromOuter(Object outer, Class<T> c, Object c2, boolean fuzzyArgs, Object ... args) {
        return this.ctx.newInstanceFromOuter(outer, c, c2, fuzzyArgs, args);
    }

    protected final StringBuilder getStringBuilder() {
        if (this.sbStack.isEmpty()) {
            return new StringBuilder();
        }
        return this.sbStack.pop();
    }

    protected final void returnStringBuilder(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        sb.setLength(0);
        this.sbStack.push(sb);
    }

    public final ClassMeta<Object> object() {
        return this.ctx.object();
    }

    public final ClassMeta<String> string() {
        return this.ctx.string();
    }

    public final ClassMeta<Class> _class() {
        return this.ctx._class();
    }

    protected final boolean isBeansRequireDefaultConstructor() {
        return this.ctx.isBeansRequireDefaultConstructor();
    }

    protected final boolean isBeansRequireSerializable() {
        return this.ctx.isBeansRequireSerializable();
    }

    protected final boolean isBeansRequireSettersForGetters() {
        return this.ctx.isBeansRequireSettersForGetters();
    }

    protected final boolean isBeansRequireSomeProperties() {
        return this.ctx.isBeansRequireSomeProperties();
    }

    protected final boolean isBeanMapPutReturnsOldValue() {
        return this.ctx.isBeanMapPutReturnsOldValue();
    }

    protected final boolean isUseInterfaceProxies() {
        return this.ctx.isUseInterfaceProxies();
    }

    protected final boolean isIgnoreUnknownBeanProperties() {
        return this.ctx.isIgnoreUnknownBeanProperties();
    }

    protected final boolean isIgnoreUnknownNullBeanProperties() {
        return this.ctx.isIgnoreUnknownNullBeanProperties();
    }

    protected final boolean isIgnorePropertiesWithoutSetters() {
        return this.ctx.isIgnorePropertiesWithoutSetters();
    }

    protected final boolean isIgnoreInvocationExceptionsOnGetters() {
        return this.ctx.isIgnoreInvocationExceptionsOnGetters();
    }

    protected final boolean isIgnoreInvocationExceptionsOnSetters() {
        return this.ctx.isIgnoreInvocationExceptionsOnSetters();
    }

    protected final boolean isUseJavaBeanIntrospector() {
        return this.ctx.isUseJavaBeanIntrospector();
    }

    protected final boolean isUseEnumNames() {
        return this.ctx.isUseEnumNames();
    }

    protected final boolean isSortProperties() {
        return this.ctx.isSortProperties();
    }

    protected final boolean isFluentSetters() {
        return this.ctx.isFluentSetters();
    }

    protected final Visibility getBeanConstructorVisibility() {
        return this.ctx.getBeanConstructorVisibility();
    }

    protected final Visibility getBeanClassVisibility() {
        return this.ctx.getBeanClassVisibility();
    }

    protected final Visibility getBeanMethodVisibility() {
        return this.ctx.getBeanMethodVisibility();
    }

    protected final Visibility getBeanFieldVisibility() {
        return this.ctx.getBeanFieldVisibility();
    }

    protected final List<Class<?>> getBeanDictionaryClasses() {
        return this.ctx.getBeanDictionaryClasses();
    }

    protected final PropertyNamer getPropertyNamer() {
        return this.ctx.getPropertyNamer();
    }

    protected final String getBeanTypePropertyName() {
        return this.ctx.getBeanTypePropertyName();
    }

    protected final boolean isDebug() {
        return this.debug;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public final MediaType getMediaType() {
        return this.mediaType;
    }

    public final HttpPartSchema getSchema() {
        return this.schema;
    }

    @Override
    public void checkForWarnings() {
        if (this.debug) {
            super.checkForWarnings();
        }
    }
}

