/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlSerializerBuilder;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xmlschema.XmlSchemaSerializer;

public class XmlSerializer
extends WriterSerializer {
    private static final String PREFIX = "XmlSerializer.";
    public static final String XML_addBeanTypes = "XmlSerializer.addBeanTypes.b";
    public static final String XML_addNamespaceUrisToRoot = "XmlSerializer.addNamespaceUrisToRoot.b";
    public static final String XML_autoDetectNamespaces = "XmlSerializer.autoDetectNamespaces.b";
    public static final String XML_defaultNamespace = "XmlSerializer.defaultNamespace.s";
    public static final String XML_enableNamespaces = "XmlSerializer.enableNamespaces.b";
    public static final String XML_namespaces = "XmlSerializer.namespaces.ls";
    public static final String XML_xsNamespace = "XmlSerializer.xsNamespace.s";
    public static final XmlSerializer DEFAULT = new XmlSerializer(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_SQ = new Sq(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_NS = new Ns(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_NS_SQ = new NsSq(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_NS_SQ_READABLE = new NsSqReadable(PropertyStore.DEFAULT);
    protected static final Namespace DEFAULT_JUNEAU_NAMESPACE = Namespace.create("juneau", "http://www.apache.org/2013/Juneau");
    protected static final Namespace DEFAULT_XS_NAMESPACE = Namespace.create("xs", "http://www.w3.org/2001/XMLSchema");
    private final boolean autoDetectNamespaces = this.getBooleanProperty("XmlSerializer.autoDetectNamespaces.b", true);
    private final boolean enableNamespaces = this.getBooleanProperty("XmlSerializer.enableNamespaces.b", false);
    private final boolean addNamespaceUrlsToRoot = this.getBooleanProperty("XmlSerializer.addNamespaceUrisToRoot.b", false);
    private final boolean addBeanTypes;
    private final Namespace defaultNamespace = this.getInstanceProperty("XmlSerializer.defaultNamespace.s", Namespace.class, DEFAULT_JUNEAU_NAMESPACE);
    private final Namespace xsNamespace;
    private final Namespace[] namespaces;
    private volatile XmlSchemaSerializer schemaSerializer;

    public XmlSerializer(PropertyStore ps) {
        this(ps, "text/xml", null);
    }

    public XmlSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.addBeanTypes = this.getBooleanProperty(XML_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
        this.xsNamespace = this.getInstanceProperty(XML_xsNamespace, Namespace.class, DEFAULT_XS_NAMESPACE);
        this.namespaces = this.getInstanceArrayProperty(XML_namespaces, Namespace.class, new Namespace[0]);
    }

    @Override
    public XmlSerializerBuilder builder() {
        return new XmlSerializerBuilder(this.getPropertyStore());
    }

    public static XmlSerializerBuilder create() {
        return new XmlSerializerBuilder();
    }

    public XmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(XmlSchemaSerializer.class);
        }
        return this.schemaSerializer;
    }

    @Override
    public WriterSerializerSession createSession(SerializerSessionArgs args) {
        return new XmlSerializerSession(this, args);
    }

    protected final boolean isAutoDetectNamespaces() {
        return this.autoDetectNamespaces;
    }

    protected final boolean isEnableNamespaces() {
        return this.enableNamespaces;
    }

    protected final boolean isAddNamespaceUrlsToRoot() {
        return this.addNamespaceUrlsToRoot;
    }

    @Override
    protected boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    protected final Namespace getXsNamespace() {
        return this.xsNamespace;
    }

    protected final Namespace[] getNamespaces() {
        return this.namespaces;
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("XmlSerializer", new ObjectMap().append("autoDetectNamespaces", this.autoDetectNamespaces).append("enableNamespaces", this.enableNamespaces).append("addNamespaceUrlsToRoot", this.addNamespaceUrlsToRoot).append("defaultNamespace", this.defaultNamespace).append("xsNamespace", this.xsNamespace).append("namespaces", this.namespaces).append("addBeanTypes", this.addBeanTypes));
    }

    public static class NsSqReadable
    extends XmlSerializer {
        public NsSqReadable(PropertyStore ps) {
            super(ps.builder().set(XmlSerializer.XML_enableNamespaces, true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("Serializer.useWhitespace.b", true).build());
        }
    }

    public static class NsSq
    extends XmlSerializer {
        public NsSq(PropertyStore ps) {
            super(ps.builder().set(XmlSerializer.XML_enableNamespaces, true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }

    public static class Ns
    extends XmlSerializer {
        public Ns(PropertyStore ps) {
            super(ps.builder().set(XmlSerializer.XML_enableNamespaces, true).build(), "text/xml", "text/xml+simple");
        }
    }

    public static class SqReadable
    extends XmlSerializer {
        public SqReadable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("Serializer.useWhitespace.b", true).build());
        }
    }

    public static class Sq
    extends XmlSerializer {
        public Sq(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }
}

