/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.uon.UonWriter;
import org.apache.juneau.urlencoding.UrlEncodingClassMeta;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public class UrlEncodingSerializerSession
extends UonSerializerSession {
    private final UrlEncodingSerializer ctx;

    protected UrlEncodingSerializerSession(UrlEncodingSerializer ctx, Boolean encode, SerializerSessionArgs args) {
        super(ctx, encode, args);
        this.ctx = ctx;
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("UrlEncodingSerializerSession", new ObjectMap());
    }

    private boolean shouldUseExpandedParams(BeanPropertyMeta pMeta) {
        ClassMeta<?> cm = pMeta.getClassMeta().getSerializedClassMeta(this);
        if (cm.isCollectionOrArray()) {
            if (this.isExpandedParams()) {
                return true;
            }
            if (pMeta.getBeanMeta().getClassMeta().getExtendedMeta(UrlEncodingClassMeta.class).isExpandedParams()) {
                return true;
            }
        }
        return false;
    }

    private boolean shouldUseExpandedParams(Object value) {
        if (value == null || !this.isExpandedParams()) {
            return false;
        }
        ClassMeta<?> cm = this.getClassMetaForObject(value).getSerializedClassMeta(this);
        return cm.isCollectionOrArray() && this.isExpandedParams();
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        this.serializeAnything(this.getUonWriter(out), o);
    }

    private SerializerWriter serializeAnything(UonWriter out, Object o) throws Exception {
        ClassMeta<?> eType = this.getExpectedRootType(o);
        ClassMeta<Object> aType = this.push("root", o, eType);
        --this.indent;
        if (aType == null) {
            aType = this.object();
        }
        ClassMeta<Object> sType = aType;
        String typeName = this.getBeanTypeName(eType, aType, null);
        PojoSwap<Object, ?> swap = aType.getPojoSwap(this);
        if (swap != null) {
            o = swap.swap(this, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, sType);
            }
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isCollection() || sType.isArray()) {
            Map<Integer, Object> m = sType.isCollection() ? UrlEncodingSerializerSession.getCollectionMap((Collection)o) : UrlEncodingSerializerSession.getCollectionMap(o);
            this.serializeCollectionMap(out, m, this.getClassMeta((Type)((Object)Map.class), new Type[]{Integer.class, Object.class}));
        } else if (sType.isReader() || sType.isInputStream()) {
            IOUtils.pipe(o, out);
        } else {
            out.append("_value=");
            super.serializeAnything(out, o, null, null, null);
        }
        this.pop();
        return out;
    }

    private static Map<Integer, Object> getCollectionMap(Collection<?> c) {
        TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
        int i = 0;
        for (Object o : c) {
            m.put(i++, o);
        }
        return m;
    }

    private static Map<Integer, Object> getCollectionMap(Object array) {
        TreeMap<Integer, Object> m = new TreeMap<Integer, Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            m.put(i, Array.get(array, i));
        }
        return m;
    }

    private SerializerWriter serializeMap(UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        m = this.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        boolean addAmp = false;
        for (Map.Entry e : m.entrySet()) {
            Object key = this.generalize(e.getKey(), keyType);
            Object value = e.getValue();
            if (this.shouldUseExpandedParams(value)) {
                Iterator<Object> i;
                Iterator<Object> iterator = i = value instanceof Collection ? ((Collection)value).iterator() : ArrayUtils.iterator(value);
                while (i.hasNext()) {
                    if (addAmp) {
                        out.cr(this.indent).append('&');
                    }
                    out.appendObject(key, true).append('=');
                    super.serializeAnything(out, i.next(), null, key == null ? null : key.toString(), null);
                    addAmp = true;
                }
                continue;
            }
            if (addAmp) {
                out.cr(this.indent).append('&');
            }
            out.appendObject(key, true).append('=');
            super.serializeAnything(out, value, valueType, key == null ? null : key.toString(), null);
            addAmp = true;
        }
        return out;
    }

    private SerializerWriter serializeCollectionMap(UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        ClassMeta<?> valueType = type.getValueType();
        boolean addAmp = false;
        for (Map.Entry e : m.entrySet()) {
            if (addAmp) {
                out.cr(this.indent).append('&');
            }
            out.append(e.getKey()).append('=');
            super.serializeAnything(out, e.getValue(), valueType, null, null);
            addAmp = true;
        }
        return out;
    }

    private SerializerWriter serializeBeanMap(UonWriter out, BeanMap<?> m, String typeName) throws Exception {
        boolean addAmp = false;
        for (BeanPropertyValue p : m.getValues(this.isTrimNullProperties(), typeName != null ? UrlEncodingSerializerSession.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            if (!pMeta.canRead()) continue;
            ClassMeta<?> cMeta = p.getClassMeta();
            ClassMeta<?> sMeta = cMeta.getSerializedClassMeta(this);
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(sMeta, key, value)) continue;
            if (value != null && this.shouldUseExpandedParams(pMeta)) {
                Iterator<Object> i;
                Iterator<Object> iterator = i = sMeta.isCollection() || value instanceof Collection ? ((Collection)value).iterator() : ArrayUtils.iterator(value);
                while (i.hasNext()) {
                    if (addAmp) {
                        out.cr(this.indent).append('&');
                    }
                    out.appendObject(key, true).append('=');
                    super.serializeAnything(out, i.next(), cMeta.getElementType(), key, pMeta);
                    addAmp = true;
                }
                continue;
            }
            if (addAmp) {
                out.cr(this.indent).append('&');
            }
            out.appendObject(key, true).append('=');
            super.serializeAnything(out, value, cMeta, key, pMeta);
            addAmp = true;
        }
        return out;
    }

    protected final boolean isExpandedParams() {
        return this.ctx.isExpandedParams();
    }
}

