/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.transform.StringSwap;
import org.apache.juneau.utils.CalendarUtils;

public class CalendarSwap
extends StringSwap<Calendar> {
    static final Calendar convert(Calendar in, ClassMeta<?> hint) throws ParseException {
        try {
            if (hint.isInstance(in) || !hint.canCreateNewInstance()) {
                return in;
            }
            Calendar c = (Calendar)hint.newInstance();
            c.setTime(in.getTime());
            c.setTimeZone(in.getTimeZone());
            return c;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    static final Calendar convert(Date in, ClassMeta<?> hint, BeanSession session) throws ParseException {
        try {
            if (hint == null || !hint.canCreateNewInstance()) {
                hint = session.getClassMeta(GregorianCalendar.class);
            }
            Calendar c = (Calendar)hint.newInstance();
            c.setTime(in);
            return c;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    public static class DateTimeShort
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.SHORT_DT, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.SHORT_DT, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateTimeMedium
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.MEDIUM_DT, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.MEDIUM_DT, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateTimeLong
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.LONG_DT, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.LONG_DT, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateTimeFull
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.FULL_DT, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.FULL_DT, session.getLocale(), session.getTimeZone());
        }
    }

    public static class TimeShort
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.SHORT_T, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.SHORT_T, session.getLocale(), session.getTimeZone());
        }
    }

    public static class TimeMedium
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.MEDIUM_T, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.MEDIUM_T, session.getLocale(), session.getTimeZone());
        }
    }

    public static class TimeLong
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.LONG_T, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.LONG_T, session.getLocale(), session.getTimeZone());
        }
    }

    public static class TimeFull
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.FULL_T, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.FULL_T, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateShort
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.SHORT_D, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.SHORT_D, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateMedium
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.MEDIUM_D, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.MEDIUM_D, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateLong
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.LONG_D, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.LONG_D, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateFull
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.FULL_D, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.FULL_D, session.getLocale(), session.getTimeZone());
        }
    }

    public static class TimeSimple
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.SIMPLE_T, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.SIMPLE_T, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateSimple
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.SIMPLE_D, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.SIMPLE_D, session.getLocale(), session.getTimeZone());
        }
    }

    public static class DateTimeSimple
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.SIMPLE_DT, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.SIMPLE_DT, session.getLocale(), session.getTimeZone());
        }
    }

    public static class RFC2822D
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.RFC2822_D, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.RFC2822_D, session.getLocale(), session.getTimeZone());
        }
    }

    public static class RFC2822DTZ
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.RFC2822_DTZ, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.RFC2822_DTZ, session.getLocale(), session.getTimeZone());
        }
    }

    public static class RFC2822DT
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.RFC2822_DT, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.RFC2822_DT, session.getLocale(), session.getTimeZone());
        }
    }

    public static class ISO8601D
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.ISO8601_D, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.ISO8601_D, session.getLocale(), session.getTimeZone());
        }
    }

    public static class ISO8601DTPZ
    extends ISO8601DTZ {
        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.ISO8601_DTPZ, session.getLocale(), session.getTimeZone());
        }
    }

    public static class ISO8601DTP
    extends ISO8601DT {
        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.ISO8601_DTP, session.getLocale(), session.getTimeZone());
        }
    }

    public static class ISO8601DTZ
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.ISO8601_DTZ, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.ISO8601_DTZ, session.getLocale(), session.getTimeZone());
        }
    }

    public static class ISO8601DTL
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return ISO8601DTL.convert(CalendarUtils.parseCalendar(o, CalendarUtils.Format.ISO8601_DTL, session.getLocale(), session.getTimeZone()), hint);
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.ISO8601_DTL, session.getLocale(), session.getTimeZone());
        }
    }

    public static class ISO8601DT
    extends CalendarSwap {
        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return CalendarUtils.parseCalendar(o, CalendarUtils.Format.ISO8601_DT, session.getLocale(), session.getTimeZone());
        }

        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.ISO8601_DT, session.getLocale(), session.getTimeZone());
        }
    }

    public static class ToString
    extends CalendarSwap {
        @Override
        public String swap(BeanSession session, Calendar o) throws Exception {
            return CalendarUtils.serialize(o, CalendarUtils.Format.TO_STRING, session.getLocale(), session.getTimeZone());
        }

        @Override
        public Calendar unswap(BeanSession session, String o, ClassMeta<?> hint) throws Exception {
            return ToString.convert(CalendarUtils.parseDate(o, CalendarUtils.Format.TO_STRING, session.getLocale(), session.getTimeZone()), hint, session);
        }
    }
}

