/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class SurrogateSwap<T, F>
extends PojoSwap<T, F> {
    private Constructor<F> constructor;
    private Method unswapMethod;

    protected SurrogateSwap(Class<T> forClass, Constructor<F> constructor, Method unswapMethod) {
        super(forClass, constructor.getDeclaringClass());
        this.constructor = constructor;
        this.unswapMethod = unswapMethod;
    }

    public static List<SurrogateSwap<?, ?>> findPojoSwaps(Class<?> c) {
        LinkedList l = new LinkedList();
        for (Constructor<?> cc : c.getConstructors()) {
            Class<?>[] pt = cc.getParameterTypes();
            if (cc.getAnnotation(BeanIgnore.class) != null || !ClassUtils.hasNumArgs(cc, 1) || !ClassUtils.isPublic(cc) || pt[0] == c.getDeclaringClass()) continue;
            Method unswapMethod = null;
            for (Method m : c.getMethods()) {
                if (!pt[0].equals(m.getReturnType()) || !ClassUtils.isPublic(m)) continue;
                unswapMethod = m;
            }
            l.add(new SurrogateSwap(pt[0], cc, unswapMethod));
        }
        return l;
    }

    @Override
    public F swap(BeanSession session, T o) throws SerializeException {
        try {
            return this.constructor.newInstance(o);
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    @Override
    public T unswap(BeanSession session, F f, ClassMeta<?> hint) throws ParseException {
        if (this.unswapMethod == null) {
            throw new ParseException("unswap() method not implement on surrogate class ''{1}''", f.getClass().getName(), this.getNormalClass().getName());
        }
        try {
            return (T)this.unswapMethod.invoke(f, new Object[0]);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

