/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.internal.ClassFlags;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.transform.Builder;

public class BuilderSwap<T, B> {
    private final Class<T> pojoClass;
    private final Class<B> builderClass;
    private final Constructor<T> pojoConstructor;
    private final Constructor<B> builderConstructor;
    private final Method createBuilderMethod;
    private final Method createPojoMethod;
    private ClassMeta<?> builderClassMeta;

    protected BuilderSwap(Class<T> pojoClass, Class<B> builderClass, Constructor<T> pojoConstructor, Constructor<B> builderConstructor, Method createBuilderMethod, Method createPojoMethod) {
        this.pojoClass = pojoClass;
        this.builderClass = builderClass;
        this.pojoConstructor = pojoConstructor;
        this.builderConstructor = builderConstructor;
        this.createBuilderMethod = createBuilderMethod;
        this.createPojoMethod = createPojoMethod;
    }

    public Class<T> getPojoClass() {
        return this.pojoClass;
    }

    public Class<B> getBuilderClass() {
        return this.builderClass;
    }

    public ClassMeta<?> getBuilderClassMeta(BeanSession session) {
        if (this.builderClassMeta == null) {
            this.builderClassMeta = session.getClassMeta(this.getBuilderClass());
        }
        return this.builderClassMeta;
    }

    public B create(BeanSession session, ClassMeta<?> hint) throws Exception {
        if (this.createBuilderMethod != null) {
            return (B)this.createBuilderMethod.invoke(null, new Object[0]);
        }
        return this.builderConstructor.newInstance(new Object[0]);
    }

    public T build(BeanSession session, B builder, ClassMeta<?> hint) throws Exception {
        if (this.createPojoMethod != null) {
            return (T)this.createPojoMethod.invoke(builder, new Object[0]);
        }
        return this.pojoConstructor.newInstance(builder);
    }

    public static BuilderSwap<?, ?> findSwapFromBuilderClass(Class<?> builderClass, Visibility cVis, Visibility mVis) {
        if (!ClassUtils.isPublic(builderClass)) {
            return null;
        }
        Class<?> pojoClass = ClassUtils.resolveParameterType(Builder.class, 0, builderClass);
        Method createPojoMethod = BuilderSwap.findCreatePojoMethod(builderClass);
        if (createPojoMethod != null) {
            pojoClass = createPojoMethod.getReturnType();
        }
        if (pojoClass == null) {
            return null;
        }
        Constructor<?> pojoConstructor = ClassUtils.findConstructor(pojoClass, cVis, false, builderClass);
        if (pojoConstructor == null) {
            return null;
        }
        Constructor<?> builderConstructor = ClassUtils.findNoArgConstructor(builderClass, cVis);
        Method createBuilderMethod = BuilderSwap.findBuilderCreateMethod(pojoClass);
        if (builderConstructor == null && createBuilderMethod == null) {
            return null;
        }
        return new BuilderSwap(pojoClass, builderClass, pojoConstructor, builderConstructor, createBuilderMethod, createPojoMethod);
    }

    public static BuilderSwap<?, ?> findSwapFromPojoClass(Class<?> pojoClass, Visibility cVis, Visibility mVis) {
        Class<?> builderClass = null;
        Constructor<?> pojoConstructor = null;
        org.apache.juneau.annotation.Builder b = pojoClass.getAnnotation(org.apache.juneau.annotation.Builder.class);
        if (b != null && b.value() != Null.class) {
            builderClass = b.value();
        }
        Method builderCreateMethod = BuilderSwap.findBuilderCreateMethod(pojoClass);
        if (builderClass == null && builderCreateMethod != null) {
            builderClass = builderCreateMethod.getReturnType();
        }
        if (builderClass == null) {
            for (Constructor<?> cc : pojoClass.getConstructors()) {
                Class<?>[] pt;
                if (!cVis.isVisible(cc) || !ClassUtils.hasNumArgs(cc, 1) || !ClassUtils.isParentClass(Builder.class, (pt = cc.getParameterTypes())[0])) continue;
                pojoConstructor = cc;
                builderClass = pt[0];
            }
        }
        if (builderClass == null) {
            return null;
        }
        Constructor<?> builderConstructor = ClassUtils.findNoArgConstructor(builderClass, cVis);
        if (builderConstructor == null && builderCreateMethod == null) {
            return null;
        }
        Method pojoCreateMethod = BuilderSwap.findCreatePojoMethod(builderClass);
        if (pojoConstructor == null) {
            pojoConstructor = ClassUtils.findConstructor(pojoClass, cVis, false, builderClass);
        }
        if (pojoConstructor == null && pojoCreateMethod == null) {
            return null;
        }
        return new BuilderSwap(pojoClass, builderClass, pojoConstructor, builderConstructor, builderCreateMethod, pojoCreateMethod);
    }

    private static Method findBuilderCreateMethod(Class<?> pojoClass) {
        for (Method m : pojoClass.getDeclaredMethods()) {
            if (!ClassUtils.isAll(m, ClassFlags.PUBLIC, ClassFlags.STATIC) || !ClassUtils.hasName(m, "create") || ClassUtils.hasReturnType(m, Void.class)) continue;
            return m;
        }
        return null;
    }

    private static Method findCreatePojoMethod(Class<?> builderClass) {
        for (Method m : builderClass.getDeclaredMethods()) {
            if (!ClassUtils.isAll(m, ClassFlags.NOT_STATIC) || !ClassUtils.hasName(m, "build") || ClassUtils.hasReturnType(m, Void.class)) continue;
            return m;
        }
        return null;
    }
}

