/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.remote;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.remote.RemoteInterface;
import org.apache.juneau.remote.RemoteInterfaceMethod;

public class RemoteInterfaceMeta {
    private final Map<Method, RemoteInterfaceMethod> methods;
    private final Map<String, RemoteInterfaceMethod> methodsByPath;
    private final String path;
    private final Class<?> c;

    public RemoteInterfaceMeta(Class<?> c, String uri) {
        this.c = c;
        String path = "";
        List<RemoteInterface> rr = ClassUtils.getAnnotationsParentFirst(RemoteInterface.class, c);
        for (RemoteInterface remoteInterface : rr) {
            if (remoteInterface.path().isEmpty()) continue;
            path = StringUtils.trimSlashes(remoteInterface.path());
        }
        LinkedHashMap<Method, RemoteInterfaceMethod> methods = new LinkedHashMap<Method, RemoteInterfaceMethod>();
        for (Method m : c.getMethods()) {
            if (!ClassUtils.isPublic(m)) continue;
            methods.put(m, new RemoteInterfaceMethod(uri, m));
        }
        LinkedHashMap<String, RemoteInterfaceMethod> linkedHashMap = new LinkedHashMap<String, RemoteInterfaceMethod>();
        for (RemoteInterfaceMethod rmm : methods.values()) {
            linkedHashMap.put(rmm.getPath(), rmm);
        }
        this.methods = CollectionUtils.unmodifiableMap(methods);
        this.methodsByPath = CollectionUtils.unmodifiableMap(linkedHashMap);
        this.path = path;
    }

    public Map<String, RemoteInterfaceMethod> getMethodsByPath() {
        return this.methodsByPath;
    }

    public RemoteInterfaceMethod getMethodMeta(Method m) {
        return this.methods.get(m);
    }

    public RemoteInterfaceMethod getMethodMetaByPath(String p) {
        return this.methodsByPath.get(p);
    }

    public Class<?> getJavaClass() {
        return this.c;
    }

    public String getPath() {
        return this.path;
    }
}

