/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.uon.UonSerializerSession;

public class OpenApiSerializerSession
extends UonSerializerSession {
    private static final BeanContext BC = BeanContext.DEFAULT;
    private static final ClassMeta<byte[]> CM_ByteArray = BC.getClassMeta(byte[].class);
    private static final ClassMeta<String[]> CM_StringArray = BC.getClassMeta(String[].class);
    private static final ClassMeta<Calendar> CM_Calendar = BC.getClassMeta(Calendar.class);
    private static final ClassMeta<Long> CM_Long = BC.getClassMeta(Long.class);
    private static final ClassMeta<Integer> CM_Integer = BC.getClassMeta(Integer.class);
    private static final ClassMeta<Double> CM_Double = BC.getClassMeta(Double.class);
    private static final ClassMeta<Float> CM_Float = BC.getClassMeta(Float.class);
    private static final ClassMeta<Boolean> CM_Boolean = BC.getClassMeta(Boolean.class);
    private static final HttpPartSchema DEFAULT_SCHEMA = HttpPartSchema.DEFAULT;
    private final OpenApiSerializer ctx;

    protected OpenApiSerializerSession(OpenApiSerializer ctx, SerializerSessionArgs args) {
        super(ctx, false, args);
        this.ctx = ctx;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        out.getWriter().write(this.serialize(HttpPartType.BODY, this.getSchema(), o));
    }

    @Override
    public String serialize(HttpPartSchema schema, Object value) throws SerializeException, SchemaValidationException {
        return this.serialize(null, schema, value);
    }

    @Override
    public String serialize(HttpPartType partType, HttpPartSchema schema, Object value) throws SerializeException, SchemaValidationException {
        schema = ObjectUtils.firstNonNull(schema, DEFAULT_SCHEMA);
        ClassMeta<Object> type = this.getClassMetaForObject(value);
        if (type == null) {
            type = this.object();
        }
        HttpPartSchema.Type t = schema.getType(type);
        HttpPartSchema.Format f = schema.getFormat(type);
        HttpPartSchema.CollectionFormat cf = schema.getCollectionFormat();
        String out = null;
        schema.validateOutput(value, this.ctx);
        if (type.hasTransformTo(schema.getParsedType()) || schema.getParsedType().hasTransformFrom(type)) {
            value = this.toType(value, schema.getParsedType());
            type = schema.getParsedType();
        }
        if (type.isUri()) {
            value = this.getUriResolver().resolve(value);
            type = this.string();
        }
        if (value != null) {
            if (t == HttpPartSchema.Type.STRING) {
                out = f == HttpPartSchema.Format.BYTE ? StringUtils.base64Encode(this.toType(value, CM_ByteArray)) : (f == HttpPartSchema.Format.BINARY ? StringUtils.toHex(this.toType(value, CM_ByteArray)) : (f == HttpPartSchema.Format.BINARY_SPACED ? StringUtils.toSpacedHex(this.toType(value, CM_ByteArray)) : (f == HttpPartSchema.Format.DATE ? StringUtils.toIsoDate(this.toType(value, CM_Calendar)) : (f == HttpPartSchema.Format.DATE_TIME ? StringUtils.toIsoDateTime(this.toType(value, CM_Calendar)) : (f == HttpPartSchema.Format.UON ? super.serialize(partType, schema, value) : this.toType(value, this.string()))))));
            } else if (t == HttpPartSchema.Type.ARRAY) {
                if (cf == HttpPartSchema.CollectionFormat.UON) {
                    out = super.serialize(partType, null, this.toList(partType, type, value, schema));
                } else {
                    ArrayList<String> l = new ArrayList<String>();
                    HttpPartSchema items = schema.getItems();
                    ClassMeta<Object> vt = this.getClassMetaForObject(value);
                    if (type.isArray()) {
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            l.add(this.serialize(partType, items, Array.get(value, i)));
                        }
                    } else if (type.isCollection()) {
                        for (Object o : (Collection)value) {
                            l.add(this.serialize(partType, items, o));
                        }
                    } else if (vt.hasTransformTo(String[].class)) {
                        String[] ss = this.toType(value, CM_StringArray);
                        for (int i = 0; i < ss.length; ++i) {
                            l.add(this.serialize(partType, items, ss[i]));
                        }
                    }
                    out = cf == HttpPartSchema.CollectionFormat.PIPES ? StringUtils.joine(l, '|') : (cf == HttpPartSchema.CollectionFormat.SSV ? StringUtils.join(l, ' ') : (cf == HttpPartSchema.CollectionFormat.TSV ? StringUtils.join(l, '\t') : StringUtils.joine(l, ',')));
                }
            } else if (t == HttpPartSchema.Type.BOOLEAN) {
                out = f == HttpPartSchema.Format.UON ? super.serialize(partType, null, value) : StringUtils.asString(this.toType(value, CM_Boolean));
            } else if (t == HttpPartSchema.Type.INTEGER) {
                out = f == HttpPartSchema.Format.UON ? super.serialize(partType, null, value) : (f == HttpPartSchema.Format.INT64 ? StringUtils.asString(this.toType(value, CM_Long)) : StringUtils.asString(this.toType(value, CM_Integer)));
            } else if (t == HttpPartSchema.Type.NUMBER) {
                out = f == HttpPartSchema.Format.UON ? super.serialize(partType, null, value) : (f == HttpPartSchema.Format.DOUBLE ? StringUtils.asString(this.toType(value, CM_Double)) : StringUtils.asString(this.toType(value, CM_Float)));
            } else if (t == HttpPartSchema.Type.OBJECT) {
                out = f == HttpPartSchema.Format.UON ? super.serialize(partType, null, value) : (schema.hasProperties() && type.isMapOrBean() ? super.serialize(partType, null, this.toMap(partType, type, value, schema)) : super.serialize(partType, null, value));
            } else {
                if (t == HttpPartSchema.Type.FILE) {
                    throw new SerializeException("File part not supported.", new Object[0]);
                }
                if (t == HttpPartSchema.Type.NO_TYPE) {
                    throw new SerializeException("Invalid type.", new Object[0]);
                }
            }
        }
        schema.validateInput(out);
        if (out == null) {
            out = schema.getDefault();
        }
        if (out == null) {
            out = "null";
        }
        return out;
    }

    private Map toMap(HttpPartType partType, ClassMeta<?> type, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        ObjectMap m = new ObjectMap();
        if (type.isBean()) {
            for (BeanPropertyValue p : this.toBeanMap(o).getValues(this.isTrimNullProperties(), new BeanPropertyValue[0])) {
                Throwable t;
                if (!p.getMeta().canRead() || (t = p.getThrown()) != null) continue;
                m.put(p.getName(), this.toObject(partType, p.getValue(), s.getProperty(p.getName())));
            }
        } else {
            for (Map.Entry e : ((Map)o).entrySet()) {
                m.put(StringUtils.asString(e.getKey()), this.toObject(partType, e.getValue(), s.getProperty(StringUtils.asString(e.getKey()))));
            }
        }
        if (this.isSortMaps()) {
            return this.sort(m);
        }
        return m;
    }

    private Collection toList(HttpPartType partType, ClassMeta<?> type, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        ObjectList l = new ObjectList();
        HttpPartSchema items = s.getItems();
        if (type.isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                l.add(this.toObject(partType, Array.get(o, i), items));
            }
        } else if (type.isCollection()) {
            for (Object o2 : (Collection)o) {
                l.add(this.toObject(partType, o2, items));
            }
        } else {
            l.add(this.toObject(partType, o, items));
        }
        if (this.isSortCollections()) {
            return this.sort(l);
        }
        return l;
    }

    private Object toObject(HttpPartType partType, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (o == null) {
            return null;
        }
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        ClassMeta<Object> cm = this.getClassMetaForObject(o);
        HttpPartSchema.Type t = s.getType(cm);
        HttpPartSchema.Format f = s.getFormat(cm);
        HttpPartSchema.CollectionFormat cf = s.getCollectionFormat();
        if (t == HttpPartSchema.Type.STRING) {
            if (f == HttpPartSchema.Format.BYTE) {
                return StringUtils.base64Encode(this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartSchema.Format.BINARY) {
                return StringUtils.toHex(this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartSchema.Format.BINARY_SPACED) {
                return StringUtils.toSpacedHex(this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartSchema.Format.DATE) {
                return StringUtils.toIsoDate(this.toType(o, CM_Calendar));
            }
            if (f == HttpPartSchema.Format.DATE_TIME) {
                return StringUtils.toIsoDateTime(this.toType(o, CM_Calendar));
            }
            return o;
        }
        if (t == HttpPartSchema.Type.ARRAY) {
            Collection l = this.toList(partType, this.getClassMetaForObject(o), o, s);
            if (cf == HttpPartSchema.CollectionFormat.CSV) {
                return StringUtils.joine(l, ',');
            }
            if (cf == HttpPartSchema.CollectionFormat.PIPES) {
                return StringUtils.joine(l, '|');
            }
            if (cf == HttpPartSchema.CollectionFormat.SSV) {
                return StringUtils.join(l, ' ');
            }
            if (cf == HttpPartSchema.CollectionFormat.TSV) {
                return StringUtils.join(l, '\t');
            }
            return l;
        }
        if (t == HttpPartSchema.Type.OBJECT) {
            return this.toMap(partType, this.getClassMetaForObject(o), o, s);
        }
        return o;
    }

    private <T> T toType(Object in, ClassMeta<T> type) throws SerializeException {
        try {
            return this.convertToType(in, type);
        }
        catch (InvalidDataConversionException e) {
            throw new SerializeException(e.getMessage(), new Object[0]);
        }
    }
}

