/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.json.JsonSchemaSerializerBuilder;
import org.apache.juneau.json.JsonSchemaSerializerSession;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.serializer.SerializerSessionArgs;

public class JsonSchemaSerializer
extends JsonSerializer {
    public static final JsonSchemaSerializer DEFAULT = new JsonSchemaSerializer(PropertyStore.DEFAULT);
    public static final JsonSchemaSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    public static final JsonSchemaSerializer DEFAULT_SIMPLE = new Simple(PropertyStore.DEFAULT);
    public static final JsonSchemaSerializer DEFAULT_SIMPLE_READABLE = new SimpleReadable(PropertyStore.DEFAULT);
    private final JsonSchemaGenerator generator = JsonSchemaGenerator.create().apply(this.getPropertyStore()).build();

    public JsonSchemaSerializer(PropertyStore ps) {
        super(ps.builder().set("BeanTraverseContext.detectRecursions.b", true).set("BeanTraverseContext.ignoreRecursions.b", true).build(), "application/json", "application/json+schema,text/json+schema");
    }

    @Override
    public JsonSchemaSerializerBuilder builder() {
        return new JsonSchemaSerializerBuilder(this.getPropertyStore());
    }

    public static JsonSchemaSerializerBuilder create() {
        return new JsonSchemaSerializerBuilder();
    }

    @Override
    public JsonSchemaSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsonSchemaSerializerSession createSession(SerializerSessionArgs args) {
        return new JsonSchemaSerializerSession(this, args);
    }

    JsonSchemaGenerator getGenerator() {
        return this.generator;
    }

    public static class SimpleReadable
    extends JsonSchemaSerializer {
        public SimpleReadable(PropertyStore ps) {
            super(ps.builder().set("JsonSerializer.simpleMode.b", true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("Serializer.useWhitespace.b", true).build());
        }
    }

    public static class Simple
    extends JsonSchemaSerializer {
        public Simple(PropertyStore ps) {
            super(ps.builder().set("JsonSerializer.simpleMode.b", true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }

    public static class Readable
    extends JsonSchemaSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().set("Serializer.useWhitespace.b", true).build());
        }
    }
}

