/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.internal.ClassFlags;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.Transform;

public class TransformCache {
    private static final ConcurrentHashMap<Class<?>, Map<Class<?>, Transform<?, ?>>> CACHE = new ConcurrentHashMap();
    public static final Transform<Object, Object> NULL = new Transform<Object, Object>(){

        @Override
        public Object transform(Object outer, Object in) {
            return null;
        }
    };

    public static synchronized void add(Class<?> ic, Class<?> oc, Transform<?, ?> t) {
        Map<Class<?>, Transform<?, ?>> m = CACHE.get(oc);
        if (m == null) {
            m = new ConcurrentHashMap();
            CACHE.put(oc, m);
        }
        m.put(ic, t);
    }

    public static <I, O> Transform<I, O> get(Class<I> ic, Class<O> oc) {
        Transform<Object, Object> t;
        if (ic == null || oc == null) {
            return null;
        }
        Map<Class<?>, Transform<?, ?>> m = CACHE.get(oc);
        if (m == null) {
            m = new ConcurrentHashMap();
            CACHE.putIfAbsent(oc, m);
            m = CACHE.get(oc);
        }
        if ((t = m.get(ic)) != null) {
            return t == NULL ? null : t;
        }
        Iterator<Class<?>> i = ClassUtils.getParentClasses(ic, false, true);
        while (i.hasNext()) {
            Class<?> pic = i.next();
            t = m.get(pic);
            if (t == null) continue;
            m.put(pic, t);
            return t == NULL ? null : t;
        }
        if (ic == oc) {
            t = new Transform<I, O>(){

                @Override
                public O transform(Object outer, I in) {
                    return in;
                }
            };
        } else if (ic == String.class) {
            Class<Object> oc2;
            Class<Object> clazz = oc2 = ClassUtils.hasPrimitiveWrapper(oc) ? ClassUtils.getPrimitiveWrapper(oc) : oc;
            if (oc2.isEnum()) {
                t = new Transform<String, O>(){

                    @Override
                    public O transform(Object outer, String in) {
                        return Enum.valueOf(oc2, in);
                    }
                };
            } else {
                final Method fromStringMethod = ClassUtils.findPublicFromStringMethod(oc2);
                if (fromStringMethod != null) {
                    t = new Transform<String, O>(){

                        @Override
                        public O transform(Object outer, String in) {
                            try {
                                return fromStringMethod.invoke(null, in);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
        }
        if (t == null) {
            Method createMethod = ClassUtils.findPublicStaticCreateMethod(oc, ic, "create");
            if (createMethod == null) {
                createMethod = ClassUtils.findPublicStaticCreateMethod(oc, ic, "from" + ic.getSimpleName());
            }
            if (createMethod != null) {
                final Method cm = createMethod;
                t = new Transform<I, O>(){

                    @Override
                    public O transform(Object context, I in) {
                        try {
                            return cm.invoke(null, in);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            } else {
                boolean isMemberClass;
                final Constructor<O> c = ClassUtils.findPublicConstructor(oc, ic);
                boolean bl = isMemberClass = oc.isMemberClass() && !ClassUtils.isStatic(oc);
                if (c != null && !ClassUtils.isDeprecated(c)) {
                    t = new Transform<I, O>(){

                        @Override
                        public O transform(Object outer, I in) {
                            try {
                                if (isMemberClass) {
                                    return c.newInstance(outer, in);
                                }
                                return c.newInstance(in);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
            }
        }
        if (t == null) {
            for (Method m2 : ClassUtils.getAllMethods(ic, false)) {
                if (!ClassUtils.isAll(m2, ClassFlags.PUBLIC, ClassFlags.NOT_STATIC, ClassFlags.HAS_NO_ARGS, ClassFlags.NOT_DEPRECATED) || !m2.getName().startsWith("to") || m2.getReturnType() != oc) continue;
                final Method m3 = m2;
                t = new Transform<I, O>(){

                    @Override
                    public O transform(Object outer, I in) {
                        try {
                            return m3.invoke(in, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                break;
            }
        }
        if (t == null) {
            t = NULL;
        }
        m.put(ic, t);
        return t == NULL ? null : t;
    }

    static {
        TransformCache.add(String.class, TimeZone.class, new Transform<String, TimeZone>(){

            @Override
            public TimeZone transform(Object outer, String in) {
                return TimeZone.getTimeZone(in);
            }
        });
        TransformCache.add(TimeZone.class, String.class, new Transform<TimeZone, String>(){

            @Override
            public String transform(Object outer, TimeZone in) {
                return in.getID();
            }
        });
        TransformCache.add(String.class, Locale.class, new Transform<String, Locale>(){

            @Override
            public Locale transform(Object outer, String in) {
                return Locale.forLanguageTag(in.replace('_', '-'));
            }
        });
        TransformCache.add(String.class, Boolean.class, new Transform<String, Boolean>(){

            @Override
            public Boolean transform(Object outer, String in) {
                if (in == null || "null".equals(in) || in.isEmpty()) {
                    return null;
                }
                return Boolean.valueOf(in);
            }
        });
    }
}

