/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;

public final class ObjectUtils {
    private static final BeanSession session = BeanContext.DEFAULT.createSession();

    public static <T> T toType(Object value, Class<T> type) {
        return session.convertToType(value, type);
    }

    public static <T> T toType(Object value, Class<T> type, Type ... args) {
        return session.convertToType(value, type, args);
    }

    public static <T> T toMemberType(Object outer, Object value, Class<T> type) {
        return session.convertToMemberType(outer, value, type);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        return o.toString().isEmpty();
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... t) {
        if (t != null) {
            for (T tt : t) {
                if (tt == null) continue;
                return tt;
            }
        }
        return null;
    }

    public static Boolean toBoolean(Object o) {
        return ObjectUtils.toType(o, Boolean.class);
    }

    public static Integer toInteger(Object o) {
        return ObjectUtils.toType(o, Integer.class);
    }

    public static Number toNumber(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        try {
            return StringUtils.parseNumber(o.toString(), null);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Enum<?>[] getEnumConstants(Class<?> c) {
        return (Enum[])c.getEnumConstants();
    }

    public static <T> T castOrNull(Object o, Class<T> c) {
        if (c.isInstance(o)) {
            return (T)o;
        }
        return null;
    }

    public static int firstNonZero(int ... ints) {
        for (int i : ints) {
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @SafeVarargs
    public static <T> T firstNonEmpty(T ... o) {
        for (T oo : o) {
            if (ObjectUtils.isEmpty(oo)) continue;
            return oo;
        }
        return null;
    }
}

