/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMetaRuntimeException;
import org.apache.juneau.FormattedIllegalArgumentException;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.ClassFlags;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.Transform;
import org.apache.juneau.internal.TransformCache;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;

public final class ClassUtils {
    private static final Map<Class<?>, ConstructorCacheEntry> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();
    private static Comparator<Method> METHOD_COMPARATOR;
    private static Comparator<Field> FIELD_COMPARATOR;
    private static final Map<Class<?>, Object> primitiveDefaultMap;

    public static ObjectList getReadableClassNames(Object[] o) {
        ObjectList l = new ObjectList();
        for (int i = 0; i < o.length; ++i) {
            l.add(o[i] == null ? "null" : ClassUtils.getReadableClassName(o[i].getClass()));
        }
        return l;
    }

    public static String getReadableClassName(Class<?> c) {
        if (c == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(c.getName());
    }

    public static String getReadableClassNameForObject(Object o) {
        if (o == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(o.getClass().getName());
    }

    public static String getReadableClassName(String className) {
        String c;
        if (className == null) {
            return null;
        }
        if (!StringUtils.startsWith(className, '[')) {
            return className;
        }
        int depth = 0;
        for (int i = 0; i < className.length() && className.charAt(i) == '['; ++i) {
            ++depth;
        }
        char type = className.charAt(depth);
        switch (type) {
            case 'Z': {
                c = "boolean";
                break;
            }
            case 'B': {
                c = "byte";
                break;
            }
            case 'C': {
                c = "char";
                break;
            }
            case 'D': {
                c = "double";
                break;
            }
            case 'F': {
                c = "float";
                break;
            }
            case 'I': {
                c = "int";
                break;
            }
            case 'J': {
                c = "long";
                break;
            }
            case 'S': {
                c = "short";
                break;
            }
            default: {
                c = className.substring(depth + 1, className.length() - 1);
            }
        }
        StringBuilder sb = new StringBuilder(c.length() + 2 * depth).append(c);
        for (int i = 0; i < depth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static Class<?> getClassFromReadableName(ClassLoader cl, String name) throws ClassNotFoundException {
        return cl.loadClass(name);
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child, boolean strict) {
        return parent.isAssignableFrom(child) && (!strict || !parent.equals(child));
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child) {
        return ClassUtils.isParentClass(parent, child, false);
    }

    public static boolean isParentClass(Class<?> parent, Type child) {
        if (child instanceof Class) {
            return ClassUtils.isParentClass(parent, (Class)child);
        }
        return false;
    }

    public static String getMethodSignature(Method m) {
        StringBuilder sb = new StringBuilder(m.getName());
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length > 0) {
            sb.append('(');
            for (int i = 0; i < pt.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(ClassUtils.getReadableClassName(pt[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static boolean hasPrimitiveWrapper(Class<?> c) {
        return pmap1.containsKey(c);
    }

    public static Class<?> getPrimitiveWrapper(Class<?> c) {
        return pmap1.get(c);
    }

    public static Class<?> getPrimitiveForWrapper(Class<?> c) {
        return pmap2.get(c);
    }

    public static Class<?> getWrapperIfPrimitive(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        return pmap1.get(c);
    }

    public static boolean isAll(Class<?> x, ClassFlags ... flags) {
        block10: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block10;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block10;
                    return false;
                }
                case PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block10;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block10;
                    return false;
                }
                case STATIC: {
                    if (!ClassUtils.isNotStatic(x)) continue block10;
                    return false;
                }
                case NOT_STATIC: {
                    if (!ClassUtils.isStatic(x)) continue block10;
                    return false;
                }
                case ABSTRACT: {
                    if (!ClassUtils.isNotAbstract(x)) continue block10;
                    return false;
                }
                case NOT_ABSTRACT: {
                    if (!ClassUtils.isAbstract(x)) continue block10;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAll(Method x, ClassFlags ... flags) {
        block12: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block12;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block12;
                    return false;
                }
                case HAS_ARGS: {
                    if (!ClassUtils.hasNoArgs(x)) continue block12;
                    return false;
                }
                case HAS_NO_ARGS: {
                    if (!ClassUtils.hasArgs(x)) continue block12;
                    return false;
                }
                case PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block12;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block12;
                    return false;
                }
                case STATIC: {
                    if (!ClassUtils.isNotStatic(x)) continue block12;
                    return false;
                }
                case NOT_STATIC: {
                    if (!ClassUtils.isStatic(x)) continue block12;
                    return false;
                }
                case ABSTRACT: {
                    if (!ClassUtils.isNotAbstract(x)) continue block12;
                    return false;
                }
                case NOT_ABSTRACT: {
                    if (!ClassUtils.isAbstract(x)) continue block12;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAll(Constructor<?> x, ClassFlags ... flags) {
        block8: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block8;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block8;
                    return false;
                }
                case HAS_ARGS: {
                    if (!ClassUtils.hasNoArgs(x)) continue block8;
                    return false;
                }
                case HAS_NO_ARGS: {
                    if (!ClassUtils.hasArgs(x)) continue block8;
                    return false;
                }
                case PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block8;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block8;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAll(Field x, ClassFlags ... flags) {
        block12: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block12;
                    return false;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block12;
                    return false;
                }
                case HAS_ARGS: {
                    continue block12;
                }
                case HAS_NO_ARGS: {
                    continue block12;
                }
                case PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block12;
                    return false;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block12;
                    return false;
                }
                case STATIC: {
                    if (!ClassUtils.isNotStatic(x)) continue block12;
                    return false;
                }
                case NOT_STATIC: {
                    if (!ClassUtils.isStatic(x)) continue block12;
                    return false;
                }
                case TRANSIENT: {
                    if (!ClassUtils.isNotTransient(x)) continue block12;
                    return false;
                }
                case NOT_TRANSIENT: {
                    if (!ClassUtils.isTransient(x)) continue block12;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAny(Class<?> x, ClassFlags ... flags) {
        block10: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block10;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block10;
                    return true;
                }
                case PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block10;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block10;
                    return true;
                }
                case STATIC: {
                    if (!ClassUtils.isStatic(x)) continue block10;
                    return true;
                }
                case NOT_STATIC: {
                    if (!ClassUtils.isNotStatic(x)) continue block10;
                    return true;
                }
                case ABSTRACT: {
                    if (!ClassUtils.isAbstract(x)) continue block10;
                    return true;
                }
                case NOT_ABSTRACT: {
                    if (!ClassUtils.isNotAbstract(x)) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAny(Method x, ClassFlags ... flags) {
        block12: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block12;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block12;
                    return true;
                }
                case HAS_ARGS: {
                    if (!ClassUtils.hasArgs(x)) continue block12;
                    return true;
                }
                case HAS_NO_ARGS: {
                    if (!ClassUtils.hasNoArgs(x)) continue block12;
                    return true;
                }
                case PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block12;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block12;
                    return true;
                }
                case STATIC: {
                    if (!ClassUtils.isStatic(x)) continue block12;
                    return true;
                }
                case NOT_STATIC: {
                    if (!ClassUtils.isNotStatic(x)) continue block12;
                    return true;
                }
                case ABSTRACT: {
                    if (!ClassUtils.isAbstract(x)) continue block12;
                    return true;
                }
                case NOT_ABSTRACT: {
                    if (!ClassUtils.isNotAbstract(x)) continue block12;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAny(Constructor<?> x, ClassFlags ... flags) {
        block8: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block8;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block8;
                    return true;
                }
                case HAS_ARGS: {
                    if (!ClassUtils.hasArgs(x)) continue block8;
                    return true;
                }
                case HAS_NO_ARGS: {
                    if (!ClassUtils.hasNoArgs(x)) continue block8;
                    return true;
                }
                case PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block8;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAny(Field x, ClassFlags ... flags) {
        block10: for (ClassFlags f : flags) {
            switch (f) {
                case DEPRECATED: {
                    if (!ClassUtils.isDeprecated(x)) continue block10;
                    return true;
                }
                case NOT_DEPRECATED: {
                    if (!ClassUtils.isNotDeprecated(x)) continue block10;
                    return true;
                }
                case PUBLIC: {
                    if (!ClassUtils.isPublic(x)) continue block10;
                    return true;
                }
                case NOT_PUBLIC: {
                    if (!ClassUtils.isNotPublic(x)) continue block10;
                    return true;
                }
                case STATIC: {
                    if (!ClassUtils.isStatic(x)) continue block10;
                    return true;
                }
                case NOT_STATIC: {
                    if (!ClassUtils.isNotStatic(x)) continue block10;
                    return true;
                }
                case TRANSIENT: {
                    if (!ClassUtils.isTransient(x)) continue block10;
                    return true;
                }
                case NOT_TRANSIENT: {
                    if (!ClassUtils.isNotTransient(x)) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasArgs(Method x, Class<?> ... args) {
        Class<?>[] pt = x.getParameterTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i].equals(args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasArgs(Constructor<?> x, Class<?> ... args) {
        Class<?>[] pt = x.getParameterTypes();
        if (pt.length == args.length) {
            for (int i = 0; i < pt.length; ++i) {
                if (pt[i].equals(args[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasArgs(Constructor<?> x) {
        return x.getParameterTypes().length > 0;
    }

    public static boolean hasNoArgs(Constructor<?> x) {
        return x.getParameterTypes().length == 0;
    }

    public static boolean hasNumArgs(Method x, int number) {
        return x.getParameterTypes().length == number;
    }

    public static boolean hasNumArgs(Constructor<?> x, int number) {
        return x.getParameterTypes().length == number;
    }

    public static boolean hasFuzzyArgs(Method x, Class<?> ... args) {
        return ClassUtils.fuzzyArgsMatch(x.getParameterTypes(), args) != -1;
    }

    public static boolean hasFuzzyArgs(Constructor<?> x, Class<?> ... args) {
        return ClassUtils.fuzzyArgsMatch(x.getParameterTypes(), args) != -1;
    }

    public static boolean isDeprecated(Class<?> c) {
        return c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isDeprecated(Method m) {
        return m.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isDeprecated(Constructor<?> c) {
        return c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isDeprecated(Field f) {
        return f.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Class<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Method m) {
        return !m.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Constructor<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Field f) {
        return !f.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isPublic(Class<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isNotPublic(Class<?> c) {
        return !Modifier.isPublic(c.getModifiers());
    }

    public static boolean isStatic(Class<?> c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public static boolean isNotStatic(Class<?> c) {
        return !Modifier.isStatic(c.getModifiers());
    }

    public static boolean isAbstract(Class<?> c) {
        return Modifier.isAbstract(c.getModifiers());
    }

    public static boolean isNotAbstract(Class<?> c) {
        return !Modifier.isAbstract(c.getModifiers());
    }

    public static boolean isAbstract(Method m) {
        return Modifier.isAbstract(m.getModifiers());
    }

    public static boolean isNotAbstract(Method m) {
        return !Modifier.isAbstract(m.getModifiers());
    }

    public static boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    public static boolean isNotPublic(Method m) {
        return !Modifier.isPublic(m.getModifiers());
    }

    public static boolean isPublic(Field f) {
        return Modifier.isPublic(f.getModifiers());
    }

    public static boolean isNotPublic(Field f) {
        return !Modifier.isPublic(f.getModifiers());
    }

    public static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static boolean isNotStatic(Method m) {
        return !Modifier.isStatic(m.getModifiers());
    }

    public static boolean isStatic(Field f) {
        return Modifier.isStatic(f.getModifiers());
    }

    public static boolean isNotStatic(Field f) {
        return !Modifier.isStatic(f.getModifiers());
    }

    public static boolean isPublic(Constructor<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isNotPublic(Constructor<?> c) {
        return !Modifier.isPublic(c.getModifiers());
    }

    public static boolean isTransient(Field f) {
        return Modifier.isTransient(f.getModifiers());
    }

    public static boolean isNotTransient(Field f) {
        return !Modifier.isTransient(f.getModifiers());
    }

    public static boolean hasArgs(Method x) {
        return x.getParameterTypes().length > 0;
    }

    public static boolean hasNoArgs(Method x) {
        return x.getParameterTypes().length == 0;
    }

    public static boolean hasName(Method m, String name) {
        return m.getName().equals(name);
    }

    public static boolean hasReturnType(Method m, Class<?> c) {
        return m.getReturnType() == c;
    }

    public static boolean hasReturnTypeParent(Method m, Class<?> c) {
        return ClassUtils.isParentClass(c, m.getReturnType());
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<T> a, Method m, boolean searchParentMethods, boolean searchReturnType, boolean parentFirst) {
        ArrayList<Annotation> l = new ArrayList<Annotation>();
        List<Method> methods = searchParentMethods ? ClassUtils.findMatchingMethods(m) : Collections.singletonList(m);
        for (Method m2 : methods) {
            for (Annotation a2 : m2.getAnnotations()) {
                if (!a.isInstance(a2)) continue;
                l.add(a2);
            }
        }
        if (searchReturnType) {
            Type t = m.getGenericReturnType();
            if (Value.isType(t)) {
                ClassUtils.appendAnnotations(a, Value.getParameterType(t), l);
            } else {
                ClassUtils.appendAnnotations(a, t, l);
            }
        }
        if (parentFirst) {
            Collections.reverse(l);
        }
        return l;
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<T> a, Method m) {
        return ClassUtils.getAnnotations(a, m, true, true, false);
    }

    public static <T extends Annotation> List<T> getAnnotationsParentFirst(Class<T> a, Method m) {
        return ClassUtils.getAnnotations(a, m, true, true, true);
    }

    public static <T extends Annotation> T getAnnotation(Class<T> a, Method m, boolean searchParentMethods, boolean searchReturnType) {
        List<Method> methods = searchParentMethods ? ClassUtils.findMatchingMethods(m) : Collections.singletonList(m);
        for (Method m2 : methods) {
            for (Annotation a2 : m2.getAnnotations()) {
                if (!a.isInstance(a2)) continue;
                return (T)a2;
            }
        }
        if (searchReturnType) {
            Type t = m.getGenericReturnType();
            if (Value.isType(t)) {
                return ClassUtils.getAnnotation(a, Value.getParameterType(t));
            }
            return ClassUtils.getAnnotation(a, t);
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<T> a, Method m) {
        return ClassUtils.getAnnotation(a, m, true, true);
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<T> a, Method m, int index, boolean searchParentMethods, boolean searchArgType, boolean parentFirst) {
        ArrayList<Annotation> l = new ArrayList<Annotation>();
        List<Method> methods = searchParentMethods ? ClassUtils.findMatchingMethods(m) : Collections.singletonList(m);
        for (Method m2 : methods) {
            for (Annotation a2 : m2.getParameterAnnotations()[index]) {
                if (!a.isInstance(a2)) continue;
                l.add(a2);
            }
        }
        if (searchArgType) {
            Type t = m.getGenericParameterTypes()[index];
            if (Value.isType(t)) {
                ClassUtils.appendAnnotations(a, Value.getParameterType(t), l);
            } else {
                ClassUtils.appendAnnotations(a, t, l);
            }
        }
        if (parentFirst) {
            Collections.reverse(l);
        }
        return l;
    }

    public static <T extends Annotation> T getAnnotation(Class<T> a, Method m, int index, boolean searchParentMethods, boolean searchArgType) {
        List<Method> methods = searchParentMethods ? ClassUtils.findMatchingMethods(m) : Collections.singletonList(m);
        for (Method m2 : methods) {
            for (Annotation a2 : m2.getParameterAnnotations()[index]) {
                if (!a.isInstance(a2)) continue;
                return (T)a2;
            }
        }
        if (searchArgType) {
            Type t = m.getGenericParameterTypes()[index];
            if (Value.isType(t)) {
                return ClassUtils.getAnnotation(a, Value.getParameterType(t));
            }
            return ClassUtils.getAnnotation(a, t);
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<T> a, Method m, int index) {
        return ClassUtils.getAnnotation(a, m, index, true, true);
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<T> a, Method m, int index) {
        return ClassUtils.getAnnotations(a, m, index, true, true, false);
    }

    public static <T extends Annotation> List<T> getAnnotationsParentFirst(Class<T> a, Method m, int index) {
        return ClassUtils.getAnnotations(a, m, index, true, true, true);
    }

    public static List<Method> findMatchingMethods(Method m) {
        return ClassUtils.findMatchingMethods(new ArrayList<Method>(), m);
    }

    private static List<Method> findMatchingMethods(List<Method> l, Method m) {
        l.add(m);
        Class<?> c = m.getDeclaringClass();
        Class<?> pc = c.getSuperclass();
        if (pc != null) {
            for (GenericDeclaration genericDeclaration : pc.getDeclaredMethods()) {
                if (!ClassUtils.isSameMethod(m, (Method)genericDeclaration)) continue;
                ClassUtils.findMatchingMethods(l, (Method)genericDeclaration);
            }
        }
        for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
            for (Method m2 : ((Class)genericDeclaration).getDeclaredMethods()) {
                if (!ClassUtils.isSameMethod(m, m2)) continue;
                ClassUtils.findMatchingMethods(l, m2);
            }
        }
        return l;
    }

    private static boolean isSameMethod(Method m1, Method m2) {
        return m1.getName().equals(m2.getName()) && Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    public static final <T> Constructor<T> findNoArgConstructor(Class<T> c, Visibility v) {
        int mod = c.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return null;
        }
        boolean isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
        for (Constructor<?> cc : c.getConstructors()) {
            mod = cc.getModifiers();
            if (!ClassUtils.hasNumArgs(cc, isMemberClass ? 1 : 0) || !v.isVisible(mod) || !ClassUtils.isNotDeprecated(cc)) continue;
            return v.transform(cc);
        }
        return null;
    }

    public static Class<?> resolveParameterType(Class<?> c, int index, Class<?> oc) {
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (c != oc.getSuperclass()) {
            ClassUtils.extractTypes(typeMap, oc);
            oc = oc.getSuperclass();
        }
        Type gsc = oc.getGenericSuperclass();
        if (!(gsc instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType opt = (ParameterizedType)gsc;
        Type actualType = opt.getActualTypeArguments()[index];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof GenericArrayType) {
            Class cmpntType = (Class)((GenericArrayType)actualType).getGenericComponentType();
            return Array.newInstance(cmpntType, 0).getClass();
        }
        if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            LinkedList nestedOuterTypes = new LinkedList();
            for (Class<?> ec = oc.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
                try {
                    Class<?> outerClass = oc.getClass();
                    nestedOuterTypes.add(outerClass);
                    HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                    ClassUtils.extractTypes(outerTypeMap, outerClass);
                    for (Map.Entry entry : outerTypeMap.entrySet()) {
                        TypeVariable keyType;
                        Type key = (Type)entry.getKey();
                        Type value = (Type)entry.getValue();
                        if (!(key instanceof TypeVariable) || !(keyType = (TypeVariable)key).getName().equals(typeVariable.getName()) || !ClassUtils.isInnerClass(keyType.getGenericDeclaration(), typeVariable.getGenericDeclaration())) continue;
                        if (value instanceof Class) {
                            return (Class)value;
                        }
                        typeVariable = (TypeVariable)entry.getValue();
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new FormattedRuntimeException("Could not resolve type: {0}", actualType);
        }
        throw new FormattedRuntimeException("Invalid type found in resolveParameterType: {0}", actualType);
    }

    public static Object invokeMethodFuzzy(Method m, Object pojo, Object ... args) throws Exception {
        return m.invoke(pojo, ClassUtils.getMatchingArgs(m.getParameterTypes(), args));
    }

    public static <T> T invokeConstructorFuzzy(Constructor<T> c, Object ... args) throws Exception {
        return c.newInstance(ClassUtils.getMatchingArgs(c.getParameterTypes(), args));
    }

    private static boolean isInnerClass(GenericDeclaration od, GenericDeclaration id) {
        if (od instanceof Class && id instanceof Class) {
            Class oc = (Class)od;
            Class<?> ic = (Class<?>)id;
            while ((ic = ic.getEnclosingClass()) != null) {
                if (ic != oc) continue;
                return true;
            }
        }
        return false;
    }

    private static void extractTypes(Map<Type, Type> typeMap, Class<?> c) {
        Type gs = c.getGenericSuperclass();
        if (gs instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gs;
            TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (typeMap.containsKey(actualTypeArguments[i])) {
                    actualTypeArguments[i] = typeMap.get(actualTypeArguments[i]);
                }
                typeMap.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
    }

    public static Method findPublicMethod(Class<?> c, String name, Class<?> returnType, Class<?> ... argTypes) {
        for (Method m : c.getMethods()) {
            if (!ClassUtils.isPublic(m) || !ClassUtils.hasName(m, name) || !ClassUtils.hasReturnTypeParent(m, returnType) || !ClassUtils.argsMatch(m.getParameterTypes(), argTypes)) continue;
            return m;
        }
        return null;
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, boolean fuzzyArgs, Class<?> ... argTypes) {
        return ClassUtils.findConstructor(c, Visibility.PUBLIC, fuzzyArgs, argTypes);
    }

    public static <T> Constructor<T> findConstructor(Class<T> c, Visibility vis, boolean fuzzyArgs, Class<?> ... argTypes) {
        ConstructorCacheEntry cce = CONSTRUCTOR_CACHE.get(c);
        if (cce != null && ClassUtils.argsMatch(cce.paramTypes, argTypes) && cce.isVisible(vis)) {
            return cce.constructor;
        }
        if (fuzzyArgs) {
            int bestCount = -1;
            Constructor<?> bestMatch = null;
            for (Constructor<?> n : c.getDeclaredConstructors()) {
                int m;
                if (!vis.isVisible(n) || (m = ClassUtils.fuzzyArgsMatch(n.getParameterTypes(), argTypes)) <= bestCount) continue;
                bestCount = m;
                bestMatch = n;
            }
            if (bestCount >= 0) {
                CONSTRUCTOR_CACHE.put(c, new ConstructorCacheEntry(c, bestMatch));
            }
            return bestMatch;
        }
        boolean isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
        for (Constructor<?> n : c.getConstructors()) {
            Class<?>[] paramTypes = n.getParameterTypes();
            if (isMemberClass) {
                paramTypes = Arrays.copyOfRange(paramTypes, 1, paramTypes.length);
            }
            if (!ClassUtils.argsMatch(paramTypes, argTypes) || !vis.isVisible(n)) continue;
            CONSTRUCTOR_CACHE.put(c, new ConstructorCacheEntry(c, n));
            return n;
        }
        return null;
    }

    public static boolean argsMatch(Class<?>[] paramTypes, Class<?>[] argTypes) {
        if (paramTypes.length == argTypes.length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (ClassUtils.isParentClass(paramTypes[i], argTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int fuzzyArgsMatch(Class<?>[] paramTypes, Class<?> ... argTypes) {
        int matches = 0;
        block0: for (Class<?> p : paramTypes) {
            p = ClassUtils.getWrapperIfPrimitive(p);
            for (Class<?> a : argTypes) {
                if (!ClassUtils.isParentClass(p, a)) continue;
                ++matches;
                continue block0;
            }
            return -1;
        }
        return matches;
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, Object ... args) {
        return ClassUtils.findPublicConstructor(c, false, ClassUtils.getClasses(args));
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, Class<?> ... args) {
        return ClassUtils.findPublicConstructor(c, false, args);
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, boolean fuzzyArgs, Object ... args) {
        return ClassUtils.findPublicConstructor(c, fuzzyArgs, ClassUtils.getClasses(args));
    }

    public static Class<?>[] getClasses(Object ... args) {
        Class[] pt = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            pt[i] = args[i] == null ? null : args[i].getClass();
        }
        return pt;
    }

    public static MethodInfo getMethodInfo(Method m) {
        return new MethodInfo(m);
    }

    public static MethodInfo[] getMethodInfo(Collection<Method> m) {
        MethodInfo[] mi = new MethodInfo[m.size()];
        int i = 0;
        for (Method mm : m) {
            mi[i++] = ClassUtils.getMethodInfo(mm);
        }
        return mi;
    }

    public static <T> T newInstance(Class<T> c, Object c2) {
        return ClassUtils.newInstanceFromOuter(null, c, c2, false, new Object[0]);
    }

    public static <T> T newInstance(Class<T> c, Object c2, boolean fuzzyArgs, Object ... args) {
        return ClassUtils.newInstanceFromOuter(null, c, c2, fuzzyArgs, args);
    }

    public static <T> T newInstanceFromOuter(Object outer, Class<T> c, Object c2, boolean fuzzyArgs, Object ... args) {
        if (c2 == null) {
            return null;
        }
        if (c2 instanceof Class) {
            try {
                Class c3 = (Class)c2;
                if (c3.isInterface() || ClassUtils.isAbstract(c3)) {
                    return null;
                }
                Constructor<T> con = ClassUtils.findPublicConstructor(c3, false, args);
                if (con != null) {
                    return con.newInstance(args);
                }
                if (outer != null && (con = ClassUtils.findPublicConstructor(c3, false, args = new AList<Object>().append(outer).appendAll((Object[])args).toArray())) != null) {
                    return con.newInstance(args);
                }
                if (fuzzyArgs && (con = ClassUtils.findPublicConstructor(c3, true, args)) != null) {
                    return con.newInstance(ClassUtils.getMatchingArgs(con.getParameterTypes(), args));
                }
                throw new FormattedRuntimeException("Could not instantiate class {0}/{1}.  Constructor not found.", c.getName(), c2);
            }
            catch (Exception e) {
                throw new FormattedRuntimeException(e, "Could not instantiate class {0}", c.getName());
            }
        }
        if (ClassUtils.isParentClass(c, c2.getClass())) {
            return (T)c2;
        }
        throw new FormattedRuntimeException("Object of type {0} found but was expecting {1}.", c2.getClass(), c.getClass());
    }

    public static Object[] getMatchingArgs(Class<?>[] paramTypes, Object ... args) {
        Object[] params = new Object[paramTypes.length];
        block0: for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> pt = ClassUtils.getWrapperIfPrimitive(paramTypes[i]);
            for (int j = 0; j < args.length; ++j) {
                if (!ClassUtils.isParentClass(pt, args[j].getClass())) continue;
                params[i] = args[j];
                continue block0;
            }
        }
        return params;
    }

    public static Iterable<Field> getAllFields(final Class c, final boolean parentFirst) {
        return new Iterable<Field>(){

            @Override
            public Iterator<Field> iterator() {
                return new Iterator<Field>(){
                    final Iterator<Class<?>> classIterator;
                    Field[] fields;
                    int fIndex;
                    Field next;
                    {
                        this.classIterator = ClassUtils.getParentClasses(c, parentFirst, false);
                        this.fields = this.classIterator.hasNext() ? ClassUtils.sort(this.classIterator.next().getDeclaredFields()) : new Field[]{};
                        this.fIndex = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        this.prime();
                        return this.next != null;
                    }

                    private void prime() {
                        if (this.next == null) {
                            while (this.fIndex >= this.fields.length) {
                                if (this.classIterator.hasNext()) {
                                    this.fields = ClassUtils.sort(this.classIterator.next().getDeclaredFields());
                                    this.fIndex = 0;
                                    continue;
                                }
                                this.fIndex = -1;
                            }
                            if (this.fIndex != -1) {
                                this.next = this.fields[this.fIndex++];
                            }
                        }
                    }

                    @Override
                    public Field next() {
                        this.prime();
                        Field f = this.next;
                        this.next = null;
                        return f;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static Iterable<Method> getAllMethods(final Class c, final boolean parentFirst) {
        return new Iterable<Method>(){

            @Override
            public Iterator<Method> iterator() {
                return new Iterator<Method>(){
                    final Iterator<Class<?>> classIterator;
                    Method[] methods;
                    int mIndex;
                    Method next;
                    {
                        this.classIterator = ClassUtils.getParentClasses(c, parentFirst, true);
                        this.methods = this.classIterator.hasNext() ? ClassUtils.sort(this.classIterator.next().getDeclaredMethods()) : new Method[]{};
                        this.mIndex = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        this.prime();
                        return this.next != null;
                    }

                    private void prime() {
                        if (this.next == null) {
                            while (this.mIndex >= this.methods.length) {
                                if (this.classIterator.hasNext()) {
                                    this.methods = ClassUtils.sort(this.classIterator.next().getDeclaredMethods());
                                    this.mIndex = 0;
                                    continue;
                                }
                                this.mIndex = -1;
                            }
                            if (this.mIndex != -1) {
                                this.next = this.methods[this.mIndex++];
                            }
                        }
                    }

                    @Override
                    public Method next() {
                        this.prime();
                        Method m = this.next;
                        this.next = null;
                        return m;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static Method[] sort(Method[] m) {
        Arrays.sort(m, METHOD_COMPARATOR);
        return m;
    }

    public static Field[] sort(Field[] m) {
        Arrays.sort(m, FIELD_COMPARATOR);
        return m;
    }

    public static Iterator<Class<?>> getParentClasses(Class<?> c, boolean parentFirst, boolean includeInterfaces) {
        List<Class<?>> l = ClassUtils.getParentClasses(new ArrayList(), c, parentFirst, includeInterfaces);
        return l.iterator();
    }

    private static List<Class<?>> getParentClasses(List<Class<?>> l, Class<?> c, boolean parentFirst, boolean includeInterfaces) {
        if (parentFirst) {
            if (includeInterfaces) {
                for (Class<?> i : c.getInterfaces()) {
                    l.add(i);
                }
            }
            if (c.getSuperclass() != Object.class && c.getSuperclass() != null) {
                ClassUtils.getParentClasses(l, c.getSuperclass(), parentFirst, includeInterfaces);
            }
            l.add(c);
        } else {
            l.add(c);
            if (c.getSuperclass() != Object.class && c.getSuperclass() != null) {
                ClassUtils.getParentClasses(l, c.getSuperclass(), parentFirst, includeInterfaces);
            }
            if (includeInterfaces) {
                for (Class<?> i : c.getInterfaces()) {
                    l.add(i);
                }
            }
        }
        return l;
    }

    public static Object getPrimitiveDefault(Class<?> primitiveClass) {
        return primitiveDefaultMap.get(primitiveClass);
    }

    public static String toString(Method m) {
        StringBuilder sb = new StringBuilder(m.getDeclaringClass().getName() + "." + m.getName() + "(");
        for (int i = 0; i < m.getParameterTypes().length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(m.getParameterTypes()[i].getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toString(Field f) {
        return f.getDeclaringClass().getName() + "." + f.getName();
    }

    public static void assertArgsOfType(Method m, Class<?> ... args) throws FormattedIllegalArgumentException {
        for (Class<?> c1 : m.getParameterTypes()) {
            boolean foundMatch = false;
            for (Class<?> c2 : args) {
                if (c1 != c2) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            throw new FormattedIllegalArgumentException("Invalid argument of type {0} passed in method {1}.  Only arguments of type {2} are allowed.", c1, m, args);
        }
    }

    public static Method findPublicFromStringMethod(Class<?> c) {
        for (String methodName : new String[]{"create", "fromString", "fromValue", "valueOf", "parse", "parseString", "forName", "forString"}) {
            for (Method m : c.getMethods()) {
                if (!ClassUtils.isAll(m, ClassFlags.STATIC, ClassFlags.PUBLIC, ClassFlags.NOT_DEPRECATED) || !ClassUtils.hasName(m, methodName) || !ClassUtils.hasReturnType(m, c) || !ClassUtils.hasArgs(m, String.class)) continue;
                return m;
            }
        }
        return null;
    }

    public static Method findPublicStaticCreateMethod(Class<?> oc, Class<?> ic, String name) {
        for (Method m : oc.getMethods()) {
            if (!ClassUtils.isAll(m, ClassFlags.STATIC, ClassFlags.PUBLIC, ClassFlags.NOT_DEPRECATED) || !ClassUtils.hasName(m, name) || !ClassUtils.hasReturnType(m, oc) || !ClassUtils.hasArgs(m, ic)) continue;
            return m;
        }
        return null;
    }

    public static <T> T fromString(Class<T> c, String s) {
        Transform<String, T> t = TransformCache.get(String.class, c);
        return t == null ? null : (T)t.transform(s);
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        Transform<?, String> t = TransformCache.get(o.getClass(), String.class);
        return t == null ? o.toString() : t.transform(o);
    }

    public static boolean setAccessible(Constructor<?> x, boolean ignoreExceptions) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            if (ignoreExceptions) {
                return false;
            }
            throw new ClassMetaRuntimeException("Could not set accessibility to true on constructor ''{0}''", x);
        }
    }

    public static boolean setAccessible(Method x, boolean ignoreExceptions) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            if (ignoreExceptions) {
                return false;
            }
            throw new ClassMetaRuntimeException("Could not set accessibility to true on method ''{0}''", x);
        }
    }

    public static boolean setAccessible(Field x, boolean ignoreExceptions) {
        try {
            if (x != null && !x.isAccessible()) {
                x.setAccessible(true);
            }
            return true;
        }
        catch (SecurityException e) {
            if (ignoreExceptions) {
                return false;
            }
            throw new ClassMetaRuntimeException("Could not set accessibility to true on field ''{0}''", x);
        }
    }

    public static String getSimpleName(Class<?> c) {
        if (c.isLocalClass()) {
            return ClassUtils.getSimpleName(c.getEnclosingClass()) + '.' + c.getSimpleName();
        }
        if (c.isMemberClass()) {
            return ClassUtils.getSimpleName(c.getDeclaringClass()) + '.' + c.getSimpleName();
        }
        return c.getSimpleName();
    }

    public static String getSimpleName(Type t) {
        if (t instanceof Class) {
            return ClassUtils.getSimpleName((Class)t);
        }
        if (t instanceof ParameterizedType) {
            StringBuilder sb = new StringBuilder();
            ParameterizedType pt = (ParameterizedType)t;
            sb.append(ClassUtils.getSimpleName(pt.getRawType()));
            sb.append("<");
            boolean first = true;
            for (Type t2 : pt.getActualTypeArguments()) {
                if (!first) {
                    sb.append(',');
                }
                first = false;
                sb.append(ClassUtils.getSimpleName(t2));
            }
            sb.append(">");
            return sb.toString();
        }
        return null;
    }

    public static boolean hasAnnotation(Class<? extends Annotation> a, Method m, int index) {
        return ClassUtils.getAnnotation(a, m, index) != null;
    }

    public static boolean hasAnnotation(Class<? extends Annotation> a, Method m) {
        return ClassUtils.getAnnotation(a, m) != null;
    }

    public static boolean hasAnnotation(Class<? extends Annotation> a, Type t) {
        return ClassUtils.getAnnotation(a, t) != null;
    }

    public static <T extends Annotation> T getAnnotation(Class<T> a, Type t) {
        Class<?> c = ClassUtils.toClass(t);
        if (c != null) {
            T t2 = ClassUtils.getDeclaredAnnotation(a, c);
            if (t2 != null) {
                return t2;
            }
            t2 = ClassUtils.getAnnotation(a, c.getSuperclass());
            if (t2 != null) {
                return t2;
            }
            for (Class<?> c2 : c.getInterfaces()) {
                t2 = ClassUtils.getAnnotation(a, c2);
                if (t2 == null) continue;
                return t2;
            }
        }
        return null;
    }

    public static <T extends Annotation> T getDeclaredAnnotation(Class<T> a, Type t) {
        Class<?> c = ClassUtils.toClass(t);
        if (c != null) {
            for (Annotation a2 : c.getDeclaredAnnotations()) {
                if (a2.annotationType() != a) continue;
                return (T)a2;
            }
        }
        return null;
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<T> a, Type t) {
        LinkedList l = new LinkedList();
        ClassUtils.appendAnnotations(a, t, l);
        return l;
    }

    public static <T extends Annotation> List<T> getAnnotationsParentFirst(Class<T> a, Type t) {
        List<T> l = ClassUtils.getAnnotations(a, t);
        Collections.reverse(l);
        return l;
    }

    public static <T extends Annotation> LinkedHashMap<Class<?>, T> getAnnotationsMap(Class<T> a, Type t) {
        LinkedHashMap m = new LinkedHashMap();
        ClassUtils.findAnnotationsMap(a, t, m);
        return m;
    }

    public static <T extends Annotation> LinkedHashMap<Class<?>, T> getAnnotationsMapParentFirst(Class<T> a, Type t) {
        return CollectionUtils.reverse(ClassUtils.getAnnotationsMap(a, t));
    }

    private static <T extends Annotation> void findAnnotationsMap(Class<T> a, Type t, Map<Class<?>, T> m) {
        Class<?> c = ClassUtils.toClass(t);
        if (c != null) {
            T t2 = ClassUtils.getDeclaredAnnotation(a, c);
            if (t2 != null) {
                m.put(c, t2);
            }
            ClassUtils.findAnnotationsMap(a, c.getSuperclass(), m);
            for (Class<?> c2 : c.getInterfaces()) {
                ClassUtils.findAnnotationsMap(a, c2, m);
            }
        }
    }

    public static <T extends Annotation> void appendAnnotations(Class<T> a, Type t, List<T> l) {
        Class<?> c = ClassUtils.toClass(t);
        if (c != null) {
            CollectionUtils.addIfNotNull(l, ClassUtils.getDeclaredAnnotation(a, c));
            if (c.getPackage() != null) {
                CollectionUtils.addIfNotNull(l, c.getPackage().getAnnotation(a));
            }
            ClassUtils.appendAnnotations(a, c.getSuperclass(), l);
            for (Class<?> c2 : c.getInterfaces()) {
                ClassUtils.appendAnnotations(a, c2, l);
            }
        }
    }

    public static Class<?> toClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            return (Class)pt.getRawType();
        }
        return null;
    }

    public static InputStream getResource(Class<?> c, String name) {
        if (name == null) {
            return null;
        }
        while (c != null) {
            InputStream is = c.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
            c = c.getSuperclass();
        }
        return null;
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
        METHOD_COMPARATOR = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int i = o1.getName().compareTo(o2.getName());
                if (i == 0 && (i = o1.getParameterTypes().length - o2.getParameterTypes().length) == 0) {
                    for (int j = 0; j < o1.getParameterTypes().length && i == 0; ++j) {
                        i = o1.getParameterTypes()[j].getName().compareTo(o2.getParameterTypes()[j].getName());
                    }
                }
                return i;
            }
        };
        FIELD_COMPARATOR = new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        primitiveDefaultMap = Collections.unmodifiableMap(new AMap<Class<Boolean>, Boolean>().append(Boolean.TYPE, false).append(Character.TYPE, (Boolean)((Object)Character.valueOf('\u0000'))).append(Short.TYPE, (Boolean)((Object)Short.valueOf((short)0))).append(Integer.TYPE, (Boolean)((Object)Integer.valueOf(0))).append(Long.TYPE, (Boolean)((Object)Long.valueOf(0L))).append(Float.TYPE, (Boolean)((Object)Float.valueOf(0.0f))).append(Double.TYPE, (Boolean)((Object)Double.valueOf(0.0))).append(Byte.TYPE, (Boolean)((Object)Byte.valueOf((byte)0))).append(Boolean.class, false).append(Character.class, (Boolean)((Object)Character.valueOf('\u0000'))).append(Short.class, (Boolean)((Object)Short.valueOf((short)0))).append(Integer.class, (Boolean)((Object)Integer.valueOf(0))).append(Long.class, (Boolean)((Object)Long.valueOf(0L))).append(Float.class, (Boolean)((Object)Float.valueOf(0.0f))).append(Double.class, (Boolean)((Object)Double.valueOf(0.0))).append(Byte.class, (Boolean)((Object)Byte.valueOf((byte)0))));
    }

    public static class MethodInfo {
        public final String methodName;
        public final String[] parameterTypes;
        public final String returnType;

        MethodInfo(Method m) {
            this.methodName = m.getName();
            Type[] pt = m.getGenericParameterTypes();
            this.parameterTypes = new String[pt.length];
            for (int i = 0; i < pt.length; ++i) {
                this.parameterTypes[i] = BeanContext.DEFAULT.getClassMeta(pt[i], new Type[0]).toString();
            }
            this.returnType = BeanContext.DEFAULT.getClassMeta(m.getGenericReturnType(), new Type[0]).toString();
        }
    }

    private static final class ConstructorCacheEntry {
        final Constructor<?> constructor;
        final Class<?>[] paramTypes;

        ConstructorCacheEntry(Class<?> forClass, Constructor<?> constructor) {
            this.constructor = constructor;
            this.paramTypes = constructor.getParameterTypes();
        }

        boolean isVisible(Visibility vis) {
            return vis.isVisible(this.constructor);
        }
    }
}

