/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.lang.reflect.Method;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;

public class ResponseBeanPropertyMeta {
    private final Method getter;
    private final HttpPartType partType;
    private final HttpPartSerializer serializer;
    private final HttpPartParser parser;
    private final HttpPartSchema schema;

    static Builder create(HttpPartType partType, HttpPartSchema schema, Method m) {
        return new Builder().partType(partType).schema(schema).getter(m);
    }

    static Builder create(HttpPartType partType, Method m) {
        return new Builder().partType(partType).getter(m);
    }

    ResponseBeanPropertyMeta(Builder b, HttpPartSerializer serializer, HttpPartParser parser) {
        this.partType = b.partType;
        this.schema = b.schema;
        this.getter = b.getter;
        this.serializer = this.schema.getSerializer() == null ? serializer : ClassUtils.newInstance(HttpPartSerializer.class, this.schema.getSerializer(), true, b.ps);
        this.parser = this.schema.getParser() == null ? parser : ClassUtils.newInstance(HttpPartParser.class, this.schema.getParser(), true, b.ps);
    }

    public String getPartName() {
        return this.schema == null ? null : this.schema.getName();
    }

    public Method getGetter() {
        return this.getter;
    }

    public HttpPartType getPartType() {
        return this.partType;
    }

    public HttpPartSerializer getSerializer(HttpPartSerializer _default) {
        return this.serializer == null ? _default : this.serializer;
    }

    public HttpPartParser getParser(HttpPartParser _default) {
        return this.parser == null ? _default : this.parser;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    static class Builder {
        HttpPartType partType;
        HttpPartSchema schema = HttpPartSchema.DEFAULT;
        String name;
        Method getter;
        PropertyStore ps = PropertyStore.DEFAULT;

        Builder() {
        }

        Builder name(String value) {
            this.name = value;
            return this;
        }

        Builder getter(Method value) {
            this.getter = value;
            return this;
        }

        Builder partType(HttpPartType value) {
            this.partType = value;
            return this;
        }

        Builder schema(HttpPartSchema value) {
            this.schema = value;
            return this;
        }

        ResponseBeanPropertyMeta build(HttpPartSerializer serializer, HttpPartParser parser) {
            return new ResponseBeanPropertyMeta(this, serializer, parser);
        }
    }
}

