/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanProxyInvocationHandler;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.ClassMetaRuntimeException;
import org.apache.juneau.Delegate;
import org.apache.juneau.Setter;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Example;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.Null;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.annotation.Swaps;
import org.apache.juneau.annotation.URI;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ClassFlags;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.Transform;
import org.apache.juneau.internal.TransformCache;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.AnnotationBeanFilterBuilder;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.BuilderSwap;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.transform.Surrogate;
import org.apache.juneau.transform.SurrogateSwap;
import org.apache.juneau.utils.MetadataMap;

@Bean(properties="innerClass,classCategory,elementType,keyType,valueType,notABeanReason,initException,beanMeta")
public final class ClassMeta<T>
implements Type {
    final Class<T> innerClass;
    private final Class<? extends T> implClass;
    private final ClassCategory cc;
    private final Method fromStringMethod;
    private final Constructor<? extends T> noArgConstructor;
    private final Constructor<T> stringConstructor;
    private final Constructor<T> numberConstructor;
    private final Constructor<T> swapConstructor;
    private final Class<?> swapMethodType;
    private final Class<?> numberConstructorType;
    private final Method swapMethod;
    private final Method unswapMethod;
    private final Method exampleMethod;
    private final Field exampleField;
    private final Setter namePropertyMethod;
    private final Setter parentPropertyMethod;
    private final boolean isDelegate;
    private final boolean isAbstract;
    private final boolean isMemberClass;
    private final Object primitiveDefault;
    private final Map<String, Method> publicMethods;
    private final PojoSwap<?, ?>[] childPojoSwaps;
    private final ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childSwapMap;
    private final ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childUnswapMap;
    private final PojoSwap<T, ?>[] pojoSwaps;
    private final BeanFilter beanFilter;
    private final BuilderSwap<T, ?> builderSwap;
    private final MetadataMap extMeta;
    private final BeanContext beanContext;
    private final ClassMeta<?> elementType;
    private final ClassMeta<?> keyType;
    private final ClassMeta<?> valueType;
    private final BeanMeta<T> beanMeta;
    private final String typePropertyName;
    private final String notABeanReason;
    private final String dictionaryName;
    private final Throwable initException;
    private final InvocationHandler invocationHandler;
    private final BeanRegistry beanRegistry;
    private final ClassMeta<?>[] args;
    private final Object example;
    private final Map<Class<?>, Transform<?, T>> fromTransforms = new ConcurrentHashMap();
    private final Map<Class<?>, Transform<T, ?>> toTransforms = new ConcurrentHashMap();
    private final Transform<Reader, T> readerTransform;
    private final Transform<InputStream, T> inputStreamTransform;
    private final Transform<String, T> stringTransform;
    private ReadWriteLock lock = new ReentrantReadWriteLock(false);
    private Lock rLock = this.lock.readLock();
    private Lock wLock = this.lock.writeLock();

    ClassMeta(Class<T> innerClass, BeanContext beanContext, Class<? extends T> implClass, BeanFilter beanFilter, PojoSwap<T, ?>[] pojoSwaps, PojoSwap<?, ?>[] childPojoSwaps, Object example) {
        this.innerClass = innerClass;
        this.beanContext = beanContext;
        this.extMeta = new MetadataMap();
        String notABeanReason = null;
        this.wLock.lock();
        try {
            if (beanContext != null && beanContext.cmCache != null) {
                beanContext.cmCache.put(innerClass, this);
            }
            ClassMetaBuilder<? extends T> builder = new ClassMetaBuilder<T>(innerClass, beanContext, implClass, beanFilter, pojoSwaps, childPojoSwaps, example);
            this.cc = builder.cc;
            this.isDelegate = builder.isDelegate;
            this.fromStringMethod = builder.fromStringMethod;
            this.swapMethod = builder.swapMethod;
            this.unswapMethod = builder.unswapMethod;
            this.swapMethodType = builder.swapMethodType;
            this.parentPropertyMethod = builder.parentPropertyMethod;
            this.namePropertyMethod = builder.namePropertyMethod;
            this.noArgConstructor = builder.noArgConstructor;
            this.stringConstructor = builder.stringConstructor;
            this.swapConstructor = builder.swapConstructor;
            this.numberConstructor = builder.numberConstructor;
            this.numberConstructorType = builder.numberConstructorType;
            this.primitiveDefault = builder.primitiveDefault;
            this.publicMethods = builder.publicMethods;
            this.beanFilter = beanFilter;
            this.pojoSwaps = builder.pojoSwaps.isEmpty() ? null : builder.pojoSwaps.toArray(new PojoSwap[builder.pojoSwaps.size()]);
            this.builderSwap = builder.builderSwap;
            this.keyType = builder.keyType;
            this.valueType = builder.valueType;
            this.elementType = builder.elementType;
            notABeanReason = builder.notABeanReason;
            this.beanMeta = builder.beanMeta;
            this.initException = builder.initException;
            this.typePropertyName = builder.typePropertyName;
            this.dictionaryName = builder.dictionaryName;
            this.invocationHandler = builder.invocationHandler;
            this.beanRegistry = builder.beanRegistry;
            this.isMemberClass = builder.isMemberClass;
            this.isAbstract = builder.isAbstract;
            this.implClass = builder.implClass;
            this.childUnswapMap = builder.childUnswapMap;
            this.childSwapMap = builder.childSwapMap;
            this.childPojoSwaps = builder.childPojoSwaps;
            this.exampleMethod = builder.exampleMethod;
            this.exampleField = builder.exampleField;
            this.example = builder.example;
            this.args = null;
            this.readerTransform = builder.readerTransform;
            this.inputStreamTransform = builder.inputStreamTransform;
            this.stringTransform = builder.stringTransform;
        }
        catch (ClassMetaRuntimeException e) {
            notABeanReason = e.getMessage();
            throw e;
        }
        finally {
            this.notABeanReason = notABeanReason;
            this.wLock.unlock();
        }
    }

    final void waitForInit() {
        this.rLock.lock();
        this.rLock.unlock();
    }

    ClassMeta(ClassMeta<T> mainType, ClassMeta<?> keyType, ClassMeta<?> valueType, ClassMeta<?> elementType) {
        this.innerClass = mainType.innerClass;
        this.implClass = mainType.implClass;
        this.childPojoSwaps = mainType.childPojoSwaps;
        this.childSwapMap = mainType.childSwapMap;
        this.childUnswapMap = mainType.childUnswapMap;
        this.cc = mainType.cc;
        this.fromStringMethod = mainType.fromStringMethod;
        this.noArgConstructor = mainType.noArgConstructor;
        this.stringConstructor = mainType.stringConstructor;
        this.numberConstructor = mainType.numberConstructor;
        this.swapConstructor = mainType.swapConstructor;
        this.swapMethodType = mainType.swapMethodType;
        this.numberConstructorType = mainType.numberConstructorType;
        this.swapMethod = mainType.swapMethod;
        this.unswapMethod = mainType.unswapMethod;
        this.namePropertyMethod = mainType.namePropertyMethod;
        this.parentPropertyMethod = mainType.parentPropertyMethod;
        this.isDelegate = mainType.isDelegate;
        this.isAbstract = mainType.isAbstract;
        this.isMemberClass = mainType.isMemberClass;
        this.primitiveDefault = mainType.primitiveDefault;
        this.publicMethods = mainType.publicMethods;
        this.beanContext = mainType.beanContext;
        this.elementType = elementType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.invocationHandler = mainType.invocationHandler;
        this.beanMeta = mainType.beanMeta;
        this.typePropertyName = mainType.typePropertyName;
        this.dictionaryName = mainType.dictionaryName;
        this.notABeanReason = mainType.notABeanReason;
        this.pojoSwaps = mainType.pojoSwaps;
        this.builderSwap = mainType.builderSwap;
        this.beanFilter = mainType.beanFilter;
        this.extMeta = mainType.extMeta;
        this.initException = mainType.initException;
        this.beanRegistry = mainType.beanRegistry;
        this.exampleMethod = mainType.exampleMethod;
        this.exampleField = mainType.exampleField;
        this.example = mainType.example;
        this.args = null;
        this.readerTransform = mainType.readerTransform;
        this.inputStreamTransform = mainType.inputStreamTransform;
        this.stringTransform = mainType.stringTransform;
    }

    ClassMeta(ClassMeta<?>[] args) {
        this.innerClass = Object[].class;
        this.extMeta = new MetadataMap();
        this.args = args;
        this.implClass = null;
        this.childPojoSwaps = null;
        this.childSwapMap = null;
        this.childUnswapMap = null;
        this.cc = ClassCategory.ARGS;
        this.fromStringMethod = null;
        this.noArgConstructor = null;
        this.stringConstructor = null;
        this.numberConstructor = null;
        this.swapConstructor = null;
        this.swapMethodType = null;
        this.numberConstructorType = null;
        this.swapMethod = null;
        this.unswapMethod = null;
        this.namePropertyMethod = null;
        this.parentPropertyMethod = null;
        this.isDelegate = false;
        this.isAbstract = false;
        this.isMemberClass = false;
        this.primitiveDefault = null;
        this.publicMethods = null;
        this.beanContext = null;
        this.elementType = null;
        this.keyType = null;
        this.valueType = null;
        this.invocationHandler = null;
        this.beanMeta = null;
        this.typePropertyName = null;
        this.dictionaryName = null;
        this.notABeanReason = null;
        this.pojoSwaps = null;
        this.builderSwap = null;
        this.beanFilter = null;
        this.initException = null;
        this.beanRegistry = null;
        this.exampleMethod = null;
        this.exampleField = null;
        this.example = null;
        this.readerTransform = null;
        this.inputStreamTransform = null;
        this.stringTransform = null;
    }

    public String getBeanTypePropertyName() {
        return this.typePropertyName;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }

    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public ClassCategory getClassCategory() {
        return this.cc;
    }

    public boolean isAssignableFrom(Class<?> c) {
        return ClassUtils.isParentClass(this.innerClass, c);
    }

    public boolean isInstanceOf(Class<?> c) {
        return ClassUtils.isParentClass(c, this.innerClass);
    }

    protected boolean hasChildPojoSwaps() {
        return this.childPojoSwaps != null;
    }

    protected PojoSwap<?, ?> getChildPojoSwapForSwap(Class<?> normalClass) {
        if (this.childSwapMap != null) {
            PojoSwap s = this.childSwapMap.get(normalClass);
            if (s == null) {
                PojoSwap s2;
                for (PojoSwap pojoSwap : this.childPojoSwaps) {
                    if (s != null || !ClassUtils.isParentClass(pojoSwap.getNormalClass(), normalClass)) continue;
                    s = pojoSwap;
                }
                if (s == null) {
                    s = PojoSwap.NULL;
                }
                if ((s2 = this.childSwapMap.putIfAbsent(normalClass, s)) != null) {
                    s = s2;
                }
            }
            if (s == PojoSwap.NULL) {
                return null;
            }
            return s;
        }
        return null;
    }

    protected PojoSwap<?, ?> getChildPojoSwapForUnswap(Class<?> swapClass) {
        if (this.childUnswapMap != null) {
            PojoSwap s = this.childUnswapMap.get(swapClass);
            if (s == null) {
                PojoSwap s2;
                for (PojoSwap pojoSwap : this.childPojoSwaps) {
                    if (s != null || !ClassUtils.isParentClass(pojoSwap.getSwapClass(), swapClass)) continue;
                    s = pojoSwap;
                }
                if (s == null) {
                    s = PojoSwap.NULL;
                }
                if ((s2 = this.childUnswapMap.putIfAbsent(swapClass, s)) != null) {
                    s = s2;
                }
            }
            if (s == PojoSwap.NULL) {
                return null;
            }
            return s;
        }
        return null;
    }

    protected static <T> Constructor<? extends T> findNoArgConstructor(Class<?> c, Visibility v) {
        if (ClassUtils.isAbstract(c)) {
            return null;
        }
        boolean isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
        for (Constructor<?> cc : c.getConstructors()) {
            if (!ClassUtils.hasNumArgs(cc, isMemberClass ? 1 : 0) || !v.isVisible(cc.getModifiers()) || !ClassUtils.isNotDeprecated(cc)) continue;
            return v.transform(cc);
        }
        return null;
    }

    public Class<T> getInnerClass() {
        return this.innerClass;
    }

    @BeanIgnore
    public ClassMeta<?> getSerializedClassMeta(BeanSession session) {
        PojoSwap<T, ?> ps = this.getPojoSwap(session);
        return ps == null ? this : ps.getSwapClassMeta(session);
    }

    @BeanIgnore
    public T getExample(BeanSession session) {
        try {
            Object etExample;
            if (this.example != null) {
                if (this.isInstance(this.example)) {
                    return (T)this.example;
                }
                if (this.example instanceof String) {
                    if (this.isCharSequence()) {
                        return (T)this.example;
                    }
                    String s = this.example.toString();
                    if (this.isMapOrBean() && StringUtils.isObjectMap(s, false)) {
                        return JsonParser.DEFAULT.parse((Object)s, this);
                    }
                    if (this.isCollectionOrArray() && StringUtils.isObjectList(s, false)) {
                        return JsonParser.DEFAULT.parse((Object)s, this);
                    }
                }
                if (this.example instanceof Map && this.isMapOrBean()) {
                    return JsonParser.DEFAULT.parse((Object)SimpleJsonSerializer.DEFAULT_READABLE.toString(this.example), this);
                }
                if (this.example instanceof Collection && this.isCollectionOrArray()) {
                    return JsonParser.DEFAULT.parse((Object)SimpleJsonSerializer.DEFAULT_READABLE.serialize(this.example), this);
                }
            }
            if (this.exampleMethod != null) {
                return (T)ClassUtils.invokeMethodFuzzy(this.exampleMethod, null, session);
            }
            if (this.exampleField != null) {
                return (T)this.exampleField.get(null);
            }
            if (this.isCollection()) {
                etExample = this.getElementType().getExample(session);
                if (etExample != null) {
                    if (this.canCreateNewInstance()) {
                        Collection c = (Collection)this.newInstance();
                        c.add(etExample);
                        return (T)c;
                    }
                    return (T)Collections.singleton(etExample);
                }
            } else if (this.isArray()) {
                etExample = this.getElementType().getExample(session);
                if (etExample != null) {
                    Object o = Array.newInstance(this.getElementType().innerClass, 1);
                    Array.set(o, 0, etExample);
                    return (T)o;
                }
            } else if (this.isMap()) {
                Object vtExample = this.getValueType().getExample(session);
                Object ktExample = this.getKeyType().getExample(session);
                if (ktExample != null && vtExample != null) {
                    if (this.canCreateNewInstance()) {
                        Map m = (Map)this.newInstance();
                        m.put(ktExample, vtExample);
                        return (T)m;
                    }
                    return (T)Collections.singletonMap(ktExample, vtExample);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ClassMetaRuntimeException(e);
        }
    }

    public ClassMeta<?> getElementType() {
        return this.elementType;
    }

    public ClassMeta<?> getKeyType() {
        return this.keyType;
    }

    public ClassMeta<?> getValueType() {
        return this.valueType;
    }

    public boolean isDelegate() {
        return this.isDelegate;
    }

    public boolean isMap() {
        return this.cc == ClassCategory.MAP || this.cc == ClassCategory.BEANMAP;
    }

    public boolean isMapOrBean() {
        return this.cc == ClassCategory.MAP || this.cc == ClassCategory.BEANMAP || this.beanMeta != null;
    }

    public boolean isBeanMap() {
        return this.cc == ClassCategory.BEANMAP;
    }

    public boolean isCollection() {
        return this.cc == ClassCategory.COLLECTION;
    }

    public boolean isCollectionOrArray() {
        return this.cc == ClassCategory.COLLECTION || this.cc == ClassCategory.ARRAY;
    }

    public boolean isSet() {
        return this.cc == ClassCategory.COLLECTION && ClassUtils.isParentClass(Set.class, this.innerClass);
    }

    public boolean isList() {
        return this.cc == ClassCategory.COLLECTION && ClassUtils.isParentClass(List.class, this.innerClass);
    }

    public boolean isByteArray() {
        return this.cc == ClassCategory.ARRAY && this.innerClass == byte[].class;
    }

    public boolean isClass() {
        return this.cc == ClassCategory.CLASS;
    }

    public boolean isMethod() {
        return this.cc == ClassCategory.METHOD;
    }

    public boolean isEnum() {
        return this.cc == ClassCategory.ENUM;
    }

    public boolean isArray() {
        return this.cc == ClassCategory.ARRAY;
    }

    public boolean isBean() {
        return this.beanMeta != null;
    }

    public boolean isObject() {
        return this.cc == ClassCategory.OBJ;
    }

    public boolean isNotObject() {
        return this.cc != ClassCategory.OBJ;
    }

    public boolean isNumber() {
        return this.cc == ClassCategory.NUMBER || this.cc == ClassCategory.DECIMAL;
    }

    public boolean isDecimal() {
        return this.cc == ClassCategory.DECIMAL;
    }

    public boolean isFloat() {
        return this.innerClass == Float.class || this.innerClass == Float.TYPE;
    }

    public boolean isDouble() {
        return this.innerClass == Double.class || this.innerClass == Double.TYPE;
    }

    public boolean isShort() {
        return this.innerClass == Short.class || this.innerClass == Short.TYPE;
    }

    public boolean isInteger() {
        return this.innerClass == Integer.class || this.innerClass == Integer.TYPE;
    }

    public boolean isLong() {
        return this.innerClass == Long.class || this.innerClass == Long.TYPE;
    }

    public boolean isType(Class<?> c) {
        return ClassUtils.isParentClass(c, this.innerClass);
    }

    public boolean isBoolean() {
        return this.cc == ClassCategory.BOOLEAN;
    }

    public boolean isCharSequence() {
        return this.cc == ClassCategory.STR || this.cc == ClassCategory.CHARSEQ;
    }

    public boolean isString() {
        return this.cc == ClassCategory.STR;
    }

    public boolean isChar() {
        return this.cc == ClassCategory.CHAR;
    }

    public boolean isPrimitive() {
        return this.innerClass.isPrimitive();
    }

    public boolean isDateOrCalendar() {
        return this.cc == ClassCategory.DATE;
    }

    public boolean isDate() {
        return this.cc == ClassCategory.DATE && ClassUtils.isParentClass(Date.class, this.innerClass);
    }

    public boolean isCalendar() {
        return this.cc == ClassCategory.DATE && ClassUtils.isParentClass(Calendar.class, this.innerClass);
    }

    public boolean isUri() {
        return this.cc == ClassCategory.URI;
    }

    public boolean isReader() {
        return this.cc == ClassCategory.READER;
    }

    public boolean isInputStream() {
        return this.cc == ClassCategory.INPUTSTREAM;
    }

    public boolean isVoid() {
        return this.cc == ClassCategory.VOID;
    }

    public boolean isArgs() {
        return this.cc == ClassCategory.ARGS;
    }

    public ClassMeta<?>[] getArgs() {
        return this.args;
    }

    public ClassMeta<?> getArg(int index) {
        if (this.args != null && index >= 0 && index < this.args.length) {
            return this.args[index];
        }
        throw new BeanRuntimeException("Invalid argument index specified:  {0}.  Only {1} arguments are defined.", index, this.args == null ? 0 : this.args.length);
    }

    public boolean isNullable() {
        if (this.innerClass.isPrimitive()) {
            return this.cc == ClassCategory.CHAR;
        }
        return true;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    public Map<String, Method> getPublicMethods() {
        return this.publicMethods;
    }

    public PojoSwap<T, ?> getPojoSwap(BeanSession session) {
        if (this.pojoSwaps != null) {
            int matchQuant = 0;
            int matchIndex = -1;
            for (int i = 0; i < this.pojoSwaps.length; ++i) {
                int q = this.pojoSwaps[i].match(session);
                if (q <= matchQuant) continue;
                matchQuant = q;
                matchIndex = i;
            }
            if (matchIndex > -1) {
                return this.pojoSwaps[matchIndex];
            }
        }
        return null;
    }

    public BuilderSwap<T, ?> getBuilderSwap(BeanSession session) {
        return this.builderSwap;
    }

    public BeanMeta<T> getBeanMeta() {
        return this.beanMeta;
    }

    public Constructor<? extends T> getConstructor() {
        return this.noArgConstructor;
    }

    public <M extends ClassMetaExtended> M getExtendedMeta(Class<M> c) {
        return (M)((ClassMetaExtended)this.extMeta.get(c, this));
    }

    public InvocationHandler getProxyInvocationHandler() {
        return this.invocationHandler;
    }

    public boolean canCreateNewInstance() {
        if (this.isMemberClass) {
            return false;
        }
        if (this.noArgConstructor != null) {
            return true;
        }
        if (this.getProxyInvocationHandler() != null) {
            return true;
        }
        return this.isArray() && this.elementType.canCreateNewInstance();
    }

    public boolean canCreateNewInstance(Object outer) {
        if (this.isMemberClass) {
            return outer != null && this.noArgConstructor != null && ClassUtils.hasArgs(this.noArgConstructor, outer.getClass());
        }
        return this.canCreateNewInstance();
    }

    public boolean canCreateNewBean(Object outer) {
        if (this.beanMeta == null) {
            return false;
        }
        if (this.beanMeta.constructor == null) {
            return false;
        }
        if (this.isMemberClass) {
            return outer != null && ClassUtils.hasArgs(this.beanMeta.constructor, outer.getClass());
        }
        return true;
    }

    public boolean canCreateNewInstanceFromString(Object outer) {
        if (this.fromStringMethod != null) {
            return true;
        }
        if (this.stringConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && ClassUtils.hasArgs(this.stringConstructor, outer.getClass(), String.class);
            }
            return true;
        }
        return false;
    }

    public boolean canCreateNewInstanceFromNumber(Object outer) {
        if (this.numberConstructor != null) {
            if (this.isMemberClass) {
                return outer != null && ClassUtils.hasArgs(this.numberConstructor, outer.getClass());
            }
            return true;
        }
        return false;
    }

    public Class<? extends Number> getNewInstanceFromNumberClass() {
        return this.numberConstructorType;
    }

    public Setter getNameProperty() {
        return this.namePropertyMethod;
    }

    public Setter getParentProperty() {
        return this.parentPropertyMethod;
    }

    public synchronized String getNotABeanReason() {
        return this.notABeanReason;
    }

    public Throwable getInitException() {
        return this.initException;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public T getPrimitiveDefault() {
        return (T)this.primitiveDefault;
    }

    public String toString(Object t) {
        if (t == null) {
            return null;
        }
        if (this.isEnum() && this.beanContext.isUseEnumNames()) {
            return ((Enum)t).name();
        }
        return t.toString();
    }

    public T newInstanceFromString(Object outer, String arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.isEnum() && this.beanContext.isUseEnumNames()) {
            return Enum.valueOf(this.innerClass, arg);
        }
        Method m = this.fromStringMethod;
        if (m != null) {
            return (T)m.invoke(null, arg);
        }
        Constructor<T> c = this.stringConstructor;
        if (c != null) {
            if (this.isMemberClass) {
                return c.newInstance(outer, arg);
            }
            return c.newInstance(arg);
        }
        throw new InstantiationError("No string constructor or valueOf(String) method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstanceFromNumber(BeanSession session, Object outer, Number arg) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> c = this.numberConstructor;
        if (c != null) {
            Object arg2 = session.convertToType((Object)arg, this.numberConstructor.getParameterTypes()[0]);
            if (this.isMemberClass) {
                return c.newInstance(outer, arg2);
            }
            return c.newInstance(arg2);
        }
        throw new InstantiationError("No string constructor or valueOf(Number) method found for class '" + this.getInnerClass().getName() + "'");
    }

    public T newInstance() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isArray()) {
            return (T)Array.newInstance(this.getInnerClass().getComponentType(), 0);
        }
        Constructor<T> c = this.getConstructor();
        if (c != null) {
            return c.newInstance(null);
        }
        InvocationHandler h = this.getProxyInvocationHandler();
        if (h != null) {
            return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.getInnerClass(), Serializable.class}, h);
        }
        if (this.isArray()) {
            return (T)Array.newInstance(this.elementType.innerClass, 0);
        }
        return null;
    }

    public T newInstance(Object outer) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isMemberClass) {
            return this.noArgConstructor.newInstance(outer);
        }
        return this.newInstance();
    }

    public boolean equals(Object t) {
        if (t == null || !(t instanceof ClassMeta)) {
            return false;
        }
        ClassMeta t2 = (ClassMeta)t;
        return t2.getInnerClass() == this.getInnerClass();
    }

    public boolean same(ClassMeta<?> cm) {
        if (this.equals(cm)) {
            return true;
        }
        return this.isPrimitive() && this.cc == cm.cc;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean simple) {
        return this.toString(new StringBuilder(), simple).toString();
    }

    protected StringBuilder toString(StringBuilder sb, boolean simple) {
        String n = this.innerClass.getName();
        if (simple) {
            int i = n.lastIndexOf(46);
            n = n.substring(i == -1 ? 0 : i + 1).replace('$', '.');
        }
        if (this.cc == ClassCategory.ARRAY) {
            return this.elementType.toString(sb, simple).append('[').append(']');
        }
        if (this.cc == ClassCategory.MAP) {
            return sb.append(n).append(this.keyType.isObject() && this.valueType.isObject() ? "" : "<" + this.keyType.toString(simple) + "," + this.valueType.toString(simple) + ">");
        }
        if (this.cc == ClassCategory.BEANMAP) {
            return sb.append(BeanMap.class.getName()).append('<').append(n).append('>');
        }
        if (this.cc == ClassCategory.COLLECTION) {
            return sb.append(n).append(this.elementType.isObject() ? "" : "<" + this.elementType.toString(simple) + ">");
        }
        return sb.append(n);
    }

    public boolean isInstance(Object o) {
        if (o != null) {
            return ClassUtils.isParentClass(this.innerClass, o.getClass()) || this.isPrimitive() && ClassUtils.getPrimitiveWrapper(this.innerClass) == o.getClass();
        }
        return false;
    }

    public String getReadableName() {
        return ClassUtils.getReadableClassName(this.innerClass);
    }

    public String getName() {
        return this.innerClass.getName();
    }

    public String getSimpleName() {
        return this.innerClass.getSimpleName();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean hasReaderTransform() {
        return this.hasTransformFrom(Reader.class);
    }

    public Transform<Reader, T> getReaderTransform() {
        return this.getFromTransform(Reader.class);
    }

    public boolean hasInputStreamTransform() {
        return this.hasTransformFrom(InputStream.class);
    }

    public Transform<InputStream, T> getInputStreamTransform() {
        return this.getFromTransform(InputStream.class);
    }

    public boolean hasStringTransform() {
        return this.stringTransform != null;
    }

    public Transform<String, T> getStringTransform() {
        return this.stringTransform;
    }

    public boolean hasTransformFrom(Class<?> c) {
        return this.getFromTransform(c) != null;
    }

    public boolean hasTransformFrom(ClassMeta<?> c) {
        return this.getFromTransform(c.getInnerClass()) != null;
    }

    public boolean hasTransformTo(Class<?> c) {
        return this.getToTransform(c) != null;
    }

    public boolean hasTransformTo(ClassMeta<?> c) {
        return this.getToTransform(c.getInnerClass()) != null;
    }

    public T transformFrom(Object o) {
        Transform<?, T> t = this.getFromTransform(o.getClass());
        return t == null ? null : (T)t.transform(o);
    }

    public <O> O transformTo(Object o, Class<O> c) {
        Transform<T, O> t = this.getToTransform(c);
        return t == null ? null : (O)t.transform(o);
    }

    public <O> O transformTo(Object o, ClassMeta<O> c) {
        return this.transformTo(o, c.getInnerClass());
    }

    public <I> Transform<I, T> getFromTransform(Class<I> c) {
        Transform<Object, Object> t = this.fromTransforms.get(c);
        if (t == TransformCache.NULL) {
            return null;
        }
        if (t == null) {
            t = TransformCache.get(c, this.innerClass);
            if (t == null) {
                t = TransformCache.NULL;
            }
            this.fromTransforms.put(c, t);
        }
        return t == TransformCache.NULL ? null : t;
    }

    public <O> Transform<T, O> getToTransform(Class<O> c) {
        Transform<Object, Object> t = this.toTransforms.get(c);
        if (t == TransformCache.NULL) {
            return null;
        }
        if (t == null) {
            t = TransformCache.get(this.innerClass, c);
            if (t == null) {
                t = TransformCache.NULL;
            }
            this.toTransforms.put(c, t);
        }
        return t == TransformCache.NULL ? null : t;
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> a) {
        return this.innerClass.getAnnotation(a);
    }

    private static class LocaleAsString {
        private static Method forLanguageTagMethod;

        private LocaleAsString() {
        }

        public static final Locale fromString(String localeString) {
            if (forLanguageTagMethod != null) {
                if (localeString.indexOf(95) != -1) {
                    localeString = localeString.replace('_', '-');
                }
                try {
                    return (Locale)forLanguageTagMethod.invoke(null, localeString);
                }
                catch (Exception e) {
                    throw new BeanRuntimeException(e);
                }
            }
            String[] v = localeString.toString().split("[\\-\\_]");
            if (v.length == 1) {
                return new Locale(v[0]);
            }
            if (v.length == 2) {
                return new Locale(v[0], v[1]);
            }
            if (v.length == 3) {
                return new Locale(v[0], v[1], v[2]);
            }
            throw new BeanRuntimeException("Could not convert string ''{0}'' to a Locale.", localeString);
        }

        static {
            try {
                forLanguageTagMethod = Locale.class.getMethod("forLanguageTag", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private final class ClassMetaBuilder<T> {
        Class<T> innerClass;
        Class<? extends T> implClass;
        BeanContext beanContext;
        ClassCategory cc;
        boolean isDelegate;
        boolean isMemberClass;
        boolean isAbstract;
        Method fromStringMethod;
        Method swapMethod;
        Method unswapMethod;
        Setter parentPropertyMethod;
        Setter namePropertyMethod;
        Constructor<T> noArgConstructor;
        Constructor<T> stringConstructor;
        Constructor<T> swapConstructor;
        Constructor<T> numberConstructor;
        Class<?> swapMethodType;
        Class<?> numberConstructorType;
        Object primitiveDefault;
        Map<String, Method> publicMethods;
        ClassMeta<?> keyType;
        ClassMeta<?> valueType;
        ClassMeta<?> elementType;
        String typePropertyName;
        String notABeanReason;
        String dictionaryName;
        Throwable initException;
        BeanMeta beanMeta;
        List<PojoSwap> pojoSwaps;
        BuilderSwap builderSwap;
        InvocationHandler invocationHandler;
        BeanRegistry beanRegistry;
        PojoSwap<?, ?>[] childPojoSwaps;
        ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childSwapMap;
        ConcurrentHashMap<Class<?>, PojoSwap<?, ?>> childUnswapMap;
        Method exampleMethod;
        Field exampleField;
        Object example;
        Transform<Reader, T> readerTransform;
        Transform<InputStream, T> inputStreamTransform;
        Transform<String, T> stringTransform;

        ClassMetaBuilder(Class<T> innerClass, BeanContext beanContext, Class<? extends T> implClass, BeanFilter beanFilter, PojoSwap<T, ?>[] pojoSwaps, PojoSwap<?, ?>[] childPojoSwaps, Object example) {
            Bean b;
            Class<T> c;
            block103: {
                this.cc = ClassCategory.OTHER;
                this.isDelegate = false;
                this.isMemberClass = false;
                this.isAbstract = false;
                this.fromStringMethod = null;
                this.swapMethod = null;
                this.unswapMethod = null;
                this.parentPropertyMethod = null;
                this.namePropertyMethod = null;
                this.noArgConstructor = null;
                this.stringConstructor = null;
                this.swapConstructor = null;
                this.numberConstructor = null;
                this.swapMethodType = null;
                this.numberConstructorType = null;
                this.primitiveDefault = null;
                this.publicMethods = new LinkedHashMap<String, Method>();
                this.keyType = null;
                this.valueType = null;
                this.elementType = null;
                this.typePropertyName = null;
                this.notABeanReason = null;
                this.dictionaryName = null;
                this.initException = null;
                this.beanMeta = null;
                this.pojoSwaps = new ArrayList<PojoSwap>();
                this.invocationHandler = null;
                this.beanRegistry = null;
                this.innerClass = innerClass;
                this.beanContext = beanContext;
                this.implClass = implClass;
                this.childPojoSwaps = childPojoSwaps;
                if (childPojoSwaps == null) {
                    this.childSwapMap = null;
                    this.childUnswapMap = null;
                } else {
                    this.childSwapMap = new ConcurrentHashMap();
                    this.childUnswapMap = new ConcurrentHashMap();
                }
                c = innerClass;
                if (c.isPrimitive()) {
                    if (c == Boolean.TYPE) {
                        this.cc = ClassCategory.BOOLEAN;
                    } else if (c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.TYPE || c == Double.TYPE) {
                        this.cc = c == Float.TYPE || c == Double.TYPE ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                    } else if (c == Character.TYPE) {
                        this.cc = ClassCategory.CHAR;
                    } else if (c == Void.TYPE || c == Void.class) {
                        this.cc = ClassCategory.VOID;
                    }
                } else {
                    if (ClassUtils.isParentClass(Delegate.class, c)) {
                        this.isDelegate = true;
                    }
                    if (c == Object.class) {
                        this.cc = ClassCategory.OBJ;
                    } else if (c.isEnum()) {
                        this.cc = ClassCategory.ENUM;
                    } else if (c.equals(Class.class)) {
                        this.cc = ClassCategory.CLASS;
                    } else if (ClassUtils.isParentClass(Method.class, c)) {
                        this.cc = ClassCategory.METHOD;
                    } else if (ClassUtils.isParentClass(CharSequence.class, c)) {
                        this.cc = c.equals(String.class) ? ClassCategory.STR : ClassCategory.CHARSEQ;
                    } else if (ClassUtils.isParentClass(Number.class, c)) {
                        this.cc = ClassUtils.isParentClass(Float.class, c) || ClassUtils.isParentClass(Double.class, c) ? ClassCategory.DECIMAL : ClassCategory.NUMBER;
                    } else if (ClassUtils.isParentClass(Collection.class, c)) {
                        this.cc = ClassCategory.COLLECTION;
                    } else if (ClassUtils.isParentClass(Map.class, c)) {
                        this.cc = ClassUtils.isParentClass(BeanMap.class, c) ? ClassCategory.BEANMAP : ClassCategory.MAP;
                    } else if (c == Character.class) {
                        this.cc = ClassCategory.CHAR;
                    } else if (c == Boolean.class) {
                        this.cc = ClassCategory.BOOLEAN;
                    } else if (ClassUtils.isParentClass(Date.class, c) || ClassUtils.isParentClass(Calendar.class, c)) {
                        this.cc = ClassCategory.DATE;
                    } else if (c.isArray()) {
                        this.cc = ClassCategory.ARRAY;
                    } else if (ClassUtils.isParentClass(URL.class, c) || ClassUtils.isParentClass(java.net.URI.class, c) || c.isAnnotationPresent(URI.class)) {
                        this.cc = ClassCategory.URI;
                    } else if (ClassUtils.isParentClass(Reader.class, c)) {
                        this.cc = ClassCategory.READER;
                    } else if (ClassUtils.isParentClass(InputStream.class, c)) {
                        this.cc = ClassCategory.INPUTSTREAM;
                    }
                }
                this.isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
                block15: for (String string : new String[]{"fromString", "fromValue", "valueOf", "parse", "parseString", "forName", "forString"}) {
                    if (this.fromStringMethod != null) continue;
                    for (Method m : c.getMethods()) {
                        if (!ClassUtils.isAll(m, ClassFlags.STATIC, ClassFlags.PUBLIC, ClassFlags.NOT_DEPRECATED) || !ClassUtils.hasName(m, string) || !ClassUtils.hasReturnType(m, c) || !ClassUtils.hasArgs(m, String.class)) continue;
                        this.fromStringMethod = m;
                        continue block15;
                    }
                }
                try {
                    if (c == TimeZone.class) {
                        this.fromStringMethod = c.getMethod("getTimeZone", String.class);
                    } else if (c == Locale.class) {
                        this.fromStringMethod = LocaleAsString.class.getMethod("fromString", String.class);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                for (Method method : c.getMethods()) {
                    if (!ClassUtils.isAll(method, ClassFlags.PUBLIC, ClassFlags.NOT_DEPRECATED, ClassFlags.NOT_STATIC) || !ClassUtils.hasName(method, "swap") || !ClassUtils.hasFuzzyArgs(method, BeanSession.class)) continue;
                    this.swapMethod = method;
                    this.swapMethodType = method.getReturnType();
                    break;
                }
                if (this.swapMethod != null) {
                    for (Method method : c.getMethods()) {
                        if (!ClassUtils.isAll(method, ClassFlags.PUBLIC, ClassFlags.NOT_DEPRECATED, ClassFlags.STATIC) || !ClassUtils.hasName(method, "unswap") || !ClassUtils.hasFuzzyArgs(method, BeanSession.class, this.swapMethodType)) continue;
                        this.unswapMethod = method;
                        break;
                    }
                }
                for (Method method : c.getMethods()) {
                    if (!ClassUtils.isAll(method, ClassFlags.PUBLIC, ClassFlags.NOT_DEPRECATED, ClassFlags.STATIC) || !ClassUtils.hasName(method, "example") || !ClassUtils.hasFuzzyArgs(method, BeanSession.class)) continue;
                    this.exampleMethod = method;
                    break;
                }
                for (Field f : ClassUtils.getAllFields(c, true)) {
                    if (f.isAnnotationPresent(ParentProperty.class)) {
                        if (ClassUtils.isStatic(f)) {
                            throw new ClassMetaRuntimeException("@ParentProperty used on invalid field ''{0}''.  Must be static.", f);
                        }
                        ClassUtils.setAccessible(f, false);
                        this.parentPropertyMethod = new Setter.FieldSetter(f);
                    }
                    if (!f.isAnnotationPresent(NameProperty.class)) continue;
                    if (ClassUtils.isStatic(f)) {
                        throw new ClassMetaRuntimeException("@NameProperty used on invalid field ''{0}''.  Must be static.", f);
                    }
                    ClassUtils.setAccessible(f, false);
                    this.namePropertyMethod = new Setter.FieldSetter(f);
                }
                for (Field field : c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Example.class)) continue;
                    if (!ClassUtils.isStatic(field) || !ClassUtils.isParentClass(innerClass, field.getType())) {
                        throw new ClassMetaRuntimeException("@Example used on invalid field ''{0}''.  Must be static and an instance of the type.", field);
                    }
                    ClassUtils.setAccessible(field, false);
                    this.exampleField = field;
                }
                for (Method m : ClassUtils.getAllMethods(c, true)) {
                    if (m.isAnnotationPresent(ParentProperty.class)) {
                        if (ClassUtils.isStatic(m) || !ClassUtils.hasNumArgs(m, 1)) {
                            throw new ClassMetaRuntimeException("@ParentProperty used on invalid method ''{0}''.  Must not be static and have one argument.", m);
                        }
                        ClassUtils.setAccessible(m, false);
                        this.parentPropertyMethod = new Setter.MethodSetter(m);
                    }
                    if (!m.isAnnotationPresent(NameProperty.class)) continue;
                    if (ClassUtils.isStatic(m) || !ClassUtils.hasNumArgs(m, 1)) {
                        throw new ClassMetaRuntimeException("@NameProperty used on invalid method ''{0}''.  Must not be static and have one argument.", m);
                    }
                    ClassUtils.setAccessible(m, false);
                    this.namePropertyMethod = new Setter.MethodSetter(m);
                }
                for (Method method : c.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(Example.class)) continue;
                    if (!(ClassUtils.isStatic(method) && ClassUtils.hasFuzzyArgs(method, BeanSession.class) && ClassUtils.isParentClass(innerClass, method.getReturnType()))) {
                        throw new ClassMetaRuntimeException("@Example used on invalid method ''{0}''.  Must be static and return an instance of the declaring class.", method);
                    }
                    ClassUtils.setAccessible(method, false);
                    this.exampleMethod = method;
                }
                this.isAbstract = ClassUtils.isAbstract(c) && !c.isPrimitive();
                for (Constructor<?> constructor : c.getConstructors()) {
                    if (!ClassUtils.isPublic(constructor) || !ClassUtils.isNotDeprecated(constructor)) continue;
                    Class<?>[] pt = constructor.getParameterTypes();
                    if (pt.length == (this.isMemberClass ? 1 : 0) && c != Object.class && !this.isAbstract) {
                        this.noArgConstructor = constructor;
                        continue;
                    }
                    if (pt.length != (this.isMemberClass ? 2 : 1)) continue;
                    Class<?> arg = pt[this.isMemberClass ? 1 : 0];
                    if (arg == String.class) {
                        this.stringConstructor = constructor;
                        continue;
                    }
                    if (this.swapMethodType != null && this.swapMethodType.isAssignableFrom(arg)) {
                        this.swapConstructor = constructor;
                        continue;
                    }
                    if (this.cc == ClassCategory.NUMBER || !Number.class.isAssignableFrom(arg) && (!arg.isPrimitive() || arg != Integer.TYPE && arg != Short.TYPE && arg != Long.TYPE && arg != Float.TYPE && arg != Double.TYPE)) continue;
                    this.numberConstructor = constructor;
                    this.numberConstructorType = ClassUtils.getWrapperIfPrimitive(arg);
                }
                this.primitiveDefault = ClassUtils.getPrimitiveDefault(c);
                for (Method method : c.getMethods()) {
                    if (!ClassUtils.isAll(method, ClassFlags.PUBLIC, ClassFlags.NOT_DEPRECATED)) continue;
                    this.publicMethods.put(ClassUtils.getMethodSignature(method), method);
                }
                if (innerClass != Object.class) {
                    this.noArgConstructor = ClassMeta.findNoArgConstructor(implClass == null ? innerClass : implClass, Visibility.PUBLIC);
                }
                if (beanFilter == null) {
                    beanFilter = this.findBeanFilter();
                }
                if (this.swapMethod != null) {
                    final Method fSwapMethod = this.swapMethod;
                    final Method fUnswapMethod = this.unswapMethod;
                    final Constructor<T> fSwapConstructor = this.swapConstructor;
                    this.pojoSwaps.add(new PojoSwap<T, Object>(c, this.swapMethod.getReturnType()){

                        @Override
                        public Object swap(BeanSession session, Object o) throws SerializeException {
                            try {
                                return fSwapMethod.invoke(o, ClassUtils.getMatchingArgs(fSwapMethod.getParameterTypes(), session));
                            }
                            catch (Exception e) {
                                throw new SerializeException(e);
                            }
                        }

                        @Override
                        public T unswap(BeanSession session, Object f, ClassMeta<?> hint) throws ParseException {
                            try {
                                if (fUnswapMethod != null) {
                                    return fUnswapMethod.invoke(null, ClassUtils.getMatchingArgs(fSwapMethod.getParameterTypes(), session, f));
                                }
                                if (fSwapConstructor != null) {
                                    return fSwapConstructor.newInstance(f);
                                }
                                return super.unswap(session, f, hint);
                            }
                            catch (Exception e) {
                                throw new ParseException(e);
                            }
                        }
                    });
                }
                if (pojoSwaps != null) {
                    this.pojoSwaps.addAll(Arrays.asList(pojoSwaps));
                }
                if (beanContext != null) {
                    this.builderSwap = BuilderSwap.findSwapFromPojoClass(c, beanContext.getBeanConstructorVisibility(), beanContext.getBeanMethodVisibility());
                }
                this.findPojoSwaps(this.pojoSwaps);
                try {
                    ClassMeta<?>[] parameters;
                    if (this.cc == ClassCategory.ARRAY) {
                        this.elementType = this.findClassMeta(innerClass.getComponentType());
                        break block103;
                    }
                    if (this.cc == ClassCategory.MAP) {
                        parameters = this.findParameters();
                        if (parameters != null && parameters.length == 2) {
                            this.keyType = parameters[0];
                            this.valueType = parameters[1];
                        } else {
                            this.keyType = this.findClassMeta(Object.class);
                            this.valueType = this.findClassMeta(Object.class);
                        }
                        break block103;
                    }
                    if (this.cc == ClassCategory.COLLECTION) {
                        parameters = this.findParameters();
                        this.elementType = parameters != null && parameters.length == 1 ? parameters[0] : this.findClassMeta(Object.class);
                        break block103;
                    }
                    if (this.cc != ClassCategory.OTHER) break block103;
                    BeanMeta newMeta = null;
                    try {
                        newMeta = new BeanMeta(ClassMeta.this, beanContext, beanFilter, null);
                        this.notABeanReason = newMeta.notABeanReason;
                        this.beanRegistry = newMeta.beanRegistry;
                        this.typePropertyName = newMeta.typePropertyName;
                    }
                    catch (RuntimeException e) {
                        this.notABeanReason = e.getMessage();
                        throw e;
                    }
                    if (this.notABeanReason == null) {
                        this.beanMeta = newMeta;
                    }
                }
                catch (NoClassDefFoundError e) {
                    this.initException = e;
                }
                catch (RuntimeException e) {
                    this.initException = e;
                    throw e;
                }
            }
            if (this.beanMeta != null) {
                this.dictionaryName = this.beanMeta.getDictionaryName();
            }
            if (this.beanMeta != null && beanContext != null && beanContext.isUseInterfaceProxies() && innerClass.isInterface()) {
                this.invocationHandler = new BeanProxyInvocationHandler(this.beanMeta);
            }
            if ((b = c.getAnnotation(Bean.class)) != null) {
                if (b.beanDictionary().length != 0) {
                    this.beanRegistry = new BeanRegistry(beanContext, null, b.beanDictionary());
                }
                if (this.dictionaryName == null && !b.typeName().isEmpty()) {
                    this.dictionaryName = b.typeName();
                }
            }
            Example e = c.getAnnotation(Example.class);
            if (example == null && e != null && !e.value().isEmpty()) {
                example = e.value();
            }
            if (example == null) {
                switch (this.cc) {
                    case BOOLEAN: {
                        example = true;
                        break;
                    }
                    case CHAR: {
                        example = Character.valueOf('a');
                        break;
                    }
                    case CHARSEQ: 
                    case STR: {
                        example = "foo";
                        break;
                    }
                    case DECIMAL: {
                        if (ClassMeta.this.isFloat()) {
                            example = new Float(1.0f);
                            break;
                        }
                        if (!ClassMeta.this.isDouble()) break;
                        example = new Double(1.0);
                        break;
                    }
                    case ENUM: {
                        Iterator i = EnumSet.allOf(c).iterator();
                        if (!i.hasNext()) break;
                        example = i.next();
                        break;
                    }
                    case NUMBER: {
                        if (ClassMeta.this.isShort()) {
                            example = new Short(1);
                            break;
                        }
                        if (ClassMeta.this.isInteger()) {
                            example = new Integer(1);
                            break;
                        }
                        if (!ClassMeta.this.isLong()) break;
                        example = new Long(1L);
                        break;
                    }
                }
            }
            this.example = example;
            this.readerTransform = TransformCache.get(Reader.class, c);
            this.inputStreamTransform = TransformCache.get(InputStream.class, c);
            this.stringTransform = TransformCache.get(String.class, c);
        }

        private BeanFilter findBeanFilter() {
            try {
                LinkedHashMap<Class<?>, Bean> ba = ClassUtils.getAnnotationsMap(Bean.class, this.innerClass);
                if (!ba.isEmpty()) {
                    return new AnnotationBeanFilterBuilder<T>(this.innerClass, ba).build();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        private void findPojoSwaps(List<PojoSwap> l) {
            Swaps swaps;
            Swap swap = this.innerClass.getAnnotation(Swap.class);
            if (swap != null) {
                l.add(this.createPojoSwap(swap));
            }
            if ((swaps = this.innerClass.getAnnotation(Swaps.class)) != null) {
                for (Swap s : swaps.value()) {
                    l.add(this.createPojoSwap(s));
                }
            }
        }

        private PojoSwap<T, ?> createPojoSwap(Swap s) {
            List<SurrogateSwap<?, ?>> l;
            Class<?> c = s.value();
            if (c == Null.class) {
                c = s.impl();
            }
            if (ClassUtils.isParentClass(PojoSwap.class, c)) {
                PojoSwap ps = this.beanContext.newInstance(PojoSwap.class, c);
                if (s.mediaTypes().length > 0) {
                    ps.forMediaTypes(MediaType.forStrings(s.mediaTypes()));
                }
                if (!s.template().isEmpty()) {
                    ps.withTemplate(s.template());
                }
                return ps;
            }
            if (ClassUtils.isParentClass(Surrogate.class, c) && !(l = SurrogateSwap.findPojoSwaps(c)).isEmpty()) {
                return l.iterator().next();
            }
            throw new ClassMetaRuntimeException("Invalid swap class ''{0}'' specified.  Must extend from PojoSwap or Surrogate.", c);
        }

        private ClassMeta<?> findClassMeta(Class<?> c) {
            return this.beanContext.getClassMeta(c, false);
        }

        private ClassMeta<?>[] findParameters() {
            return this.beanContext.findParameters(this.innerClass, this.innerClass);
        }
    }

    static enum ClassCategory {
        MAP,
        COLLECTION,
        CLASS,
        METHOD,
        NUMBER,
        DECIMAL,
        BOOLEAN,
        CHAR,
        DATE,
        ARRAY,
        ENUM,
        OTHER,
        CHARSEQ,
        STR,
        OBJ,
        URI,
        BEANMAP,
        READER,
        INPUTSTREAM,
        VOID,
        ARGS;

    }
}

