/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.BeanTraverseBuilder;
import org.apache.juneau.BeanTraverseSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;

public abstract class BeanTraverseContext
extends BeanContext {
    private static final String PREFIX = "BeanTraverseContext.";
    public static final String BEANTRAVERSE_detectRecursions = "BeanTraverseContext.detectRecursions.b";
    public static final String BEANTRAVERSE_ignoreRecursions = "BeanTraverseContext.ignoreRecursions.b";
    public static final String BEANTRAVERSE_initialDepth = "BeanTraverseContext.initialDepth.i";
    public static final String BEANTRAVERSE_maxDepth = "BeanTraverseContext.maxDepth.i";
    private final int initialDepth;
    private final int maxDepth = this.getIntegerProperty("BeanTraverseContext.maxDepth.i", 100);
    private final boolean detectRecursions;
    private final boolean ignoreRecursions;

    protected BeanTraverseContext(PropertyStore ps) {
        super(ps);
        this.initialDepth = this.getIntegerProperty(BEANTRAVERSE_initialDepth, 0);
        this.detectRecursions = this.getBooleanProperty(BEANTRAVERSE_detectRecursions, false);
        this.ignoreRecursions = this.getBooleanProperty(BEANTRAVERSE_ignoreRecursions, false);
    }

    @Override
    public BeanTraverseBuilder builder() {
        return null;
    }

    @Override
    public BeanTraverseSession createSession(BeanSessionArgs args) {
        return new BeanTraverseSession(this, args);
    }

    protected final int getInitialDepth() {
        return this.initialDepth;
    }

    protected final int getMaxDepth() {
        return this.maxDepth;
    }

    protected final boolean isDetectRecursions() {
        return this.detectRecursions;
    }

    protected final boolean isIgnoreRecursions() {
        return this.ignoreRecursions;
    }

    @Override
    public ObjectMap asMap() {
        return super.asMap().append("BeanTraverseContext", new ObjectMap().append("maxDepth", this.maxDepth).append("initialDepth", this.initialDepth).append("detectRecursions", this.detectRecursions).append("ignoreRecursions", this.ignoreRecursions));
    }
}

