/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.IOException;
import java.util.Locale;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.utils.ClasspathResourceFinder;
import org.apache.juneau.utils.ClasspathResourceFinderRecursive;
import org.apache.juneau.utils.ClasspathResourceManager;

public abstract class Widget {
    private final ClasspathResourceManager rm = new ClasspathResourceManager(this.getClass(), (ClasspathResourceFinder)ClasspathResourceFinderRecursive.INSTANCE, false);

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getHtml(RestRequest req) throws Exception {
        return null;
    }

    public String getScript(RestRequest req) throws Exception {
        return null;
    }

    public String getStyle(RestRequest req) throws Exception {
        return null;
    }

    protected String getClasspathResourceAsString(String name) throws IOException {
        return this.rm.getString(name);
    }

    protected String getClasspathResourceAsString(String name, Locale locale) throws IOException {
        return this.rm.getString(name, locale);
    }

    protected String loadScript(String name) throws IOException {
        String s = this.getClasspathResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    protected String loadScriptWithVars(RestRequest req, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadScript(name));
    }

    protected String loadStyle(String name) throws IOException {
        String s = this.getClasspathResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    protected String loadStyleWithVars(RestRequest req, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadStyle(name));
    }

    protected String loadHtml(String name) throws IOException {
        String s = this.getClasspathResourceAsString(name);
        if (s != null) {
            s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
        }
        return s;
    }

    protected String loadHtmlWithVars(RestRequest req, String name) throws IOException {
        return req.getVarResolverSession().resolve(this.loadHtml(name));
    }
}

