/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.svl.SimpleVar;
import org.apache.juneau.svl.VarResolverSession;

public class WidgetVar
extends SimpleVar {
    private static final String SESSION_req = "req";
    public static final String NAME = "W";

    public WidgetVar() {
        super(NAME);
    }

    public String resolve(VarResolverSession session, String key) throws Exception {
        Widget w;
        RestRequest req = (RestRequest)((Object)session.getSessionObject(RestRequest.class, SESSION_req, true));
        boolean isScript = false;
        boolean isStyle = false;
        if (key.endsWith(".script")) {
            key = key.substring(0, key.length() - 7);
            isScript = true;
        }
        if (key.endsWith(".style")) {
            key = key.substring(0, key.length() - 6);
            isStyle = true;
        }
        if ((w = req.getWidgets().get(key)) == null) {
            return "unknown-widget-" + key;
        }
        if (isScript) {
            return w.getScript(req);
        }
        if (isStyle) {
            return w.getStyle(req);
        }
        return w.getHtml(req);
    }
}

