/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Value;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestJavaMethod;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.SwaggerException;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.ResourceSwagger;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.util.AnnotationUtils;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ASet;
import org.apache.juneau.utils.MessageBundle;

final class SwaggerGenerator {
    private final RestRequest req;
    private final VarResolverSession vr;
    private final BeanSession bs;
    private final Locale locale;
    private final RestContext context;
    private final JsonParser jp = JsonParser.create().ignoreUnknownBeanProperties().build();
    private final JsonSchemaGeneratorSession js;
    private final Class<?> c;
    private final Object resource;
    private final MessageBundle mb;

    public SwaggerGenerator(RestRequest req) {
        this.req = req;
        this.vr = req.getVarResolverSession();
        this.locale = req.getLocale();
        this.context = req.getContext();
        this.js = new JsonSchemaGenerator(req.getPropertyStore()).createSession();
        this.c = this.context.getResource().getClass();
        this.resource = this.context.getResource();
        this.mb = this.context.getMessages();
        BeanSession bs = req.getBeanSession();
        if (bs == null) {
            bs = BeanContext.DEFAULT.createBeanSession();
        }
        this.bs = bs;
    }

    public Swagger getSwagger() throws Exception {
        String s;
        ObjectMap omSwagger = this.context.getClasspathResource(ObjectMap.class, MediaType.JSON, ClassUtils.getSimpleName(this.resource.getClass()) + ".json", this.locale);
        if (omSwagger == null) {
            omSwagger = this.context.getClasspathResource(ObjectMap.class, MediaType.JSON, this.resource.getClass().getSimpleName() + ".json", this.locale);
        }
        if (omSwagger == null) {
            omSwagger = new ObjectMap();
        }
        for (Map.Entry e : ClassUtils.getAnnotationsMapParentFirst(RestResource.class, this.resource.getClass()).entrySet()) {
            RestResource rr = (RestResource)e.getValue();
            ObjectMap sInfo = omSwagger.getObjectMap("info", true);
            sInfo.appendSkipEmpty("title", (Object)this.firstNonEmpty(sInfo.getString("title"), this.resolve(rr.title())));
            sInfo.appendSkipEmpty("description", (Object)this.firstNonEmpty(sInfo.getString("description"), this.resolve(rr.description())));
            ResourceSwagger r = rr.swagger();
            omSwagger.appendAll((Map)this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty(r)) {
                ObjectMap info = omSwagger.getObjectMap("info", true);
                info.appendSkipEmpty("title", (Object)this.resolve(r.title()));
                info.appendSkipEmpty("description", (Object)this.resolve(r.description()));
                info.appendSkipEmpty("version", (Object)this.resolve(r.version()));
                info.appendSkipEmpty("termsOfService", (Object)this.resolve(r.termsOfService()));
                info.appendSkipEmpty("contact", (Object)this.merge(info.getObjectMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c)));
                info.appendSkipEmpty("license", (Object)this.merge(info.getObjectMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c)));
            }
            omSwagger.appendSkipEmpty("externalDocs", (Object)this.merge(omSwagger.getObjectMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c)));
            omSwagger.appendSkipEmpty("tags", (Object)this.merge(omSwagger.getObjectList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c)));
        }
        omSwagger.appendSkipEmpty("externalDocs", (Object)this.parseMap(this.mb.findFirstString(this.locale, new String[]{"externalDocs"}), "Messages/externalDocs on class {0}", this.c));
        ObjectMap info = omSwagger.getObjectMap("info", true);
        info.appendSkipEmpty("title", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"title"})));
        info.appendSkipEmpty("description", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"description"})));
        info.appendSkipEmpty("version", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"version"})));
        info.appendSkipEmpty("termsOfService", (Object)this.resolve(this.mb.findFirstString(this.locale, new String[]{"termsOfService"})));
        info.appendSkipEmpty("contact", (Object)this.parseMap(this.mb.findFirstString(this.locale, new String[]{"contact"}), "Messages/contact on class {0}", this.c));
        info.appendSkipEmpty("license", (Object)this.parseMap(this.mb.findFirstString(this.locale, new String[]{"license"}), "Messages/license on class {0}", this.c));
        if (info.isEmpty()) {
            omSwagger.remove((Object)"info");
        }
        ObjectList produces = omSwagger.getObjectList("produces", true);
        ObjectList consumes = omSwagger.getObjectList("consumes", true);
        if (consumes.isEmpty()) {
            consumes.addAll(this.context.getConsumes());
        }
        if (produces.isEmpty()) {
            produces.addAll(this.context.getProduces());
        }
        LinkedHashMap<Object, Object> tagMap = new LinkedHashMap<Object, Object>();
        if (omSwagger.containsKey((Object)"tags")) {
            for (Object om : omSwagger.getObjectList("tags").elements(ObjectMap.class)) {
                String name = om.getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in swagger JSON.", new Object[0]);
                }
                tagMap.put(name, om);
            }
        }
        if ((s = this.mb.findFirstString(this.locale, new String[]{"tags"})) != null) {
            for (Iterator<Object> m : this.parseListOrCdl(s, "Messages/tags on class {0}", this.c).elements(ObjectMap.class)) {
                String string = m.getString("name");
                if (string == null) {
                    throw new SwaggerException(null, "Tag definition found without name in resource bundle on class {0}", this.c);
                }
                if (tagMap.containsKey(string)) {
                    ((ObjectMap)tagMap.get(string)).putAll(m);
                    continue;
                }
                tagMap.put(string, m);
            }
        }
        ObjectMap definitions = omSwagger.getObjectMap("definitions", true);
        for (String string : definitions.keySet()) {
            this.js.addBeanDef(string, definitions.getObjectMap(string));
        }
        for (RestJavaMethod restJavaMethod : this.context.getCallMethods().values()) {
            List<MediaType> mProduces;
            List<MediaType> mConsumes;
            Object om;
            if (!restJavaMethod.isRequestAllowed(this.req)) continue;
            Method m = restJavaMethod.method;
            RestMethod rm = (RestMethod)ClassUtils.getAnnotation(RestMethod.class, (Method)m);
            String mn = m.getName();
            ObjectMap op = this.getOperation(omSwagger, restJavaMethod.getPathPattern(), restJavaMethod.getHttpMethod().toLowerCase());
            MethodSwagger ms = rm.swagger();
            op.appendAll((Map)this.parseMap(ms.value(), "@MethodSwagger(value) on class {0} method {1}", this.c, m));
            op.appendSkipEmpty("operationId", (Object)this.firstNonEmpty(this.resolve(ms.operationId()), op.getString("operationId"), mn));
            op.appendSkipEmpty("summary", (Object)this.firstNonEmpty(this.resolve(ms.summary()), this.resolve(this.mb.findFirstString(this.locale, new String[]{mn + ".summary"})), op.getString("summary"), this.resolve(rm.summary())));
            op.appendSkipEmpty("description", (Object)this.firstNonEmpty(this.resolve(ms.description()), this.resolve(this.mb.findFirstString(this.locale, new String[]{mn + ".description"})), op.getString("description"), this.resolve(rm.description())));
            op.appendSkipEmpty("deprecated", (Object)this.firstNonEmpty(this.resolve(ms.deprecated()), m.getAnnotation(Deprecated.class) != null || m.getDeclaringClass().getAnnotation(Deprecated.class) != null ? "true" : null));
            op.appendSkipEmpty("tags", (Object)this.merge(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".tags"}), "Messages/tags on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.tags(), "@MethodSwagger(tags) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("schemes", (Object)this.merge(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".schemes"}), "Messages/schemes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.schemes(), "@MethodSwagger(schemes) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("consumes", (Object)this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".consumes"}), "Messages/consumes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.consumes(), "@MethodSwagger(consumes) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("produces", (Object)this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(this.locale, new String[]{mn + ".produces"}), "Messages/produces on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.produces(), "@MethodSwagger(produces) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("parameters", (Object)this.merge(this.parseList(this.mb.findFirstString(this.locale, new String[]{mn + ".parameters"}), "Messages/parameters on class {0} method {1}", this.c, m), this.parseList(ms.parameters(), "@MethodSwagger(parameters) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("responses", (Object)this.merge(this.parseMap(this.mb.findFirstString(this.locale, new String[]{mn + ".responses"}), "Messages/responses on class {0} method {1}", this.c, m), this.parseMap(ms.responses(), "@MethodSwagger(responses) on class {0} method {1}", this.c, m)));
            op.appendSkipEmpty("externalDocs", (Object)this.merge(op.getObjectMap("externalDocs"), this.parseMap(this.mb.findFirstString(this.locale, new String[]{mn + ".externalDocs"}), "Messages/externalDocs on class {0} method {1}", this.c, m), this.toMap(ms.externalDocs(), "@MethodSwagger(externalDocs) on class {0} method {1}", this.c, m)));
            if (op.containsKey((Object)"tags")) {
                for (Object tag : op.getObjectList("tags").elements(String.class)) {
                    if (tagMap.containsKey(tag)) continue;
                    tagMap.put(tag, new ObjectMap().append("name", tag));
                }
            }
            ObjectMap paramMap = new ObjectMap();
            if (op.containsKey((Object)"parameters")) {
                Object tag;
                tag = op.getObjectList("parameters").elements(ObjectMap.class).iterator();
                while (tag.hasNext()) {
                    Class<?>[] param = (Class<?>[])tag.next();
                    paramMap.put((Object)(param.getString("in") + '.' + ("body".equals(param.getString("in")) ? "body" : param.getString("name"))), param);
                }
            }
            for (RestMethodParam mp : this.context.getRestMethodParams(m)) {
                RestParamType in = mp.getParamType();
                int index = mp.index;
                if (!in.isAny(RestParamType.BODY, RestParamType.QUERY, RestParamType.FORM_DATA, RestParamType.HEADER, RestParamType.PATH)) continue;
                String key = in.toString() + '.' + (in == RestParamType.BODY ? "body" : mp.getName());
                Iterator<Object> param = paramMap.getObjectMap(key, true);
                param.append("in", (Object)in);
                if (in != RestParamType.BODY) {
                    param.append("name", mp.name);
                }
                try {
                    if (mp.method != null) {
                        if (in == RestParamType.BODY) {
                            for (ResponseHeader a : ClassUtils.getAnnotationsParentFirst(Body.class, (Method)mp.method, (int)mp.index)) {
                                this.merge((ObjectMap)param, (Body)a);
                            }
                        } else if (in == RestParamType.QUERY) {
                            for (ResponseHeader a : ClassUtils.getAnnotationsParentFirst(Query.class, (Method)mp.method, (int)mp.index)) {
                                this.merge((ObjectMap)param, (Query)a);
                            }
                        } else if (in == RestParamType.FORM_DATA) {
                            for (ResponseHeader a : ClassUtils.getAnnotationsParentFirst(FormData.class, (Method)mp.method, (int)mp.index)) {
                                this.merge((ObjectMap)param, (FormData)a);
                            }
                        } else if (in == RestParamType.HEADER) {
                            for (ResponseHeader a : ClassUtils.getAnnotationsParentFirst(Header.class, (Method)mp.method, (int)mp.index)) {
                                this.merge((ObjectMap)param, (Header)a);
                            }
                        } else if (in == RestParamType.PATH) {
                            for (Path a2 : ClassUtils.getAnnotationsParentFirst(Path.class, (Method)mp.method, (int)mp.index)) {
                                this.merge((ObjectMap)param, a2);
                            }
                        }
                    }
                }
                catch (ParseException parseException) {
                    throw new SwaggerException((Exception)((Object)parseException), "Malformed swagger JSON object encountered in {0} class {1} method {2} parameter {3}", new Object[]{in, this.c, m, index});
                }
                if (!(in != RestParamType.BODY && in != RestParamType.PATH || param.containsKeyNotEmpty("required"))) {
                    param.put("required", true);
                }
                if (in == RestParamType.BODY) {
                    param.appendSkipEmpty("schema", this.getSchema(param.getObjectMap("schema"), mp.getType()));
                    this.addBodyExamples(restJavaMethod, (ObjectMap)param, false, mp.getType());
                    continue;
                }
                this.mergePartSchema((ObjectMap)param, this.getSchema(param.getObjectMap("schema"), mp.getType()));
                this.addParamExample(restJavaMethod, (ObjectMap)param, in, mp.getType());
            }
            if (!paramMap.isEmpty()) {
                op.put((Object)"parameters", (Object)paramMap.values());
            }
            ObjectMap responses = op.getObjectMap("responses", true);
            for (Class<?> ec : m.getExceptionTypes()) {
                if (!ClassUtils.hasAnnotation(Response.class, ec)) continue;
                List la = ClassUtils.getAnnotationsParentFirst(Response.class, ec);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 500);
                for (Response response : la) {
                    Path a2;
                    a2 = codes.iterator();
                    while (a2.hasNext()) {
                        Integer code3 = a2.next();
                        om = responses.getObjectMap(String.valueOf(code3), true);
                        this.merge((ObjectMap)om, response);
                        if (om.containsKey((Object)"schema")) continue;
                        om.appendSkipEmpty("schema", (Object)this.getSchema(om.getObjectMap("schema"), ec));
                    }
                }
                for (Method method : ClassUtils.getAllMethods(ec, (boolean)true)) {
                    ResponseHeader a;
                    if (!ClassUtils.hasAnnotation(ResponseHeader.class, (Method)method)) continue;
                    a = method.getAnnotation(ResponseHeader.class);
                    Iterator<Integer> ha = a.name();
                    for (Integer code : codes) {
                        ObjectMap header = responses.getObjectMap(String.valueOf(code), true).getObjectMap("headers", true).getObjectMap(ha, true);
                        this.merge(header, a);
                        this.mergePartSchema(header, this.getSchema(header, method.getGenericReturnType()));
                    }
                }
            }
            if (ClassUtils.hasAnnotation(Response.class, (Method)m)) {
                List la = ClassUtils.getAnnotationsParentFirst(Response.class, (Method)m);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 200);
                for (Response a4 : la) {
                    for (Integer code : codes) {
                        ObjectMap om2 = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(om2, a4);
                        if (!om2.containsKey((Object)"schema")) {
                            om2.appendSkipEmpty("schema", (Object)this.getSchema(om2.getObjectMap("schema"), m.getGenericReturnType()));
                        }
                        this.addBodyExamples(restJavaMethod, om2, true, m.getGenericReturnType());
                    }
                }
                if (ClassUtils.hasAnnotation(Response.class, m.getReturnType())) {
                    for (Method ecm : ClassUtils.getAllMethods(m.getReturnType(), (boolean)true)) {
                        if (!ClassUtils.hasAnnotation(ResponseHeader.class, (Method)ecm)) continue;
                        ResponseHeader a5 = ecm.getAnnotation(ResponseHeader.class);
                        String ha = a5.name();
                        for (Integer n : codes) {
                            ObjectMap header = responses.getObjectMap(String.valueOf(n), true).getObjectMap("headers", true).getObjectMap(ha, true);
                            this.merge(header, a5);
                            this.mergePartSchema(header, this.getSchema(header, ecm.getGenericReturnType()));
                        }
                    }
                }
            } else if (m.getGenericReturnType() != Void.TYPE) {
                RestMethodParam[] om3 = responses.getObjectMap("200", true);
                if (!om3.containsKey((Object)"schema")) {
                    om3.appendSkipEmpty("schema", (Object)this.getSchema(om3.getObjectMap("schema"), m.getGenericReturnType()));
                }
                this.addBodyExamples(restJavaMethod, (ObjectMap)om3, true, m.getGenericReturnType());
            }
            for (RestMethodParam mp : this.context.getRestMethodParams(m)) {
                Set<Integer> codes;
                List la;
                RestParamType in = mp.getParamType();
                if (in == RestParamType.RESPONSE_HEADER) {
                    la = ClassUtils.getAnnotationsParentFirst(ResponseHeader.class, (Method)mp.method, (int)mp.index);
                    codes = SwaggerGenerator.getCodes2(la, 200);
                    for (ResponseHeader a : la) {
                        for (Integer code2 : codes) {
                            ObjectMap header = responses.getObjectMap(String.valueOf(code2), true).getObjectMap("headers", true).getObjectMap(mp.name, true);
                            this.merge(header, a);
                            this.mergePartSchema(header, this.getSchema(header, Value.getParameterType((Type)mp.type)));
                        }
                    }
                    continue;
                }
                if (in != RestParamType.RESPONSE) continue;
                la = ClassUtils.getAnnotationsParentFirst(Response.class, (Method)mp.method, (int)mp.index);
                codes = SwaggerGenerator.getCodes(la, 200);
                for (ResponseHeader a : la) {
                    for (Integer code : codes) {
                        ObjectMap response = responses.getObjectMap(String.valueOf(code), true);
                        this.merge(response, (Response)a);
                    }
                }
                Type type = Value.getParameterType((Type)mp.type);
                if (type == null) continue;
                for (String code : responses.keySet()) {
                    om = responses.getObjectMap(code);
                    if (om.containsKey((Object)"schema")) continue;
                    om.appendSkipEmpty("schema", (Object)this.getSchema(om.getObjectMap("schema"), type));
                }
            }
            for (Map.Entry e : responses.entrySet()) {
                String key = (String)e.getKey();
                ObjectMap val = responses.getObjectMap(key);
                if (!StringUtils.isDecimal((String)key)) continue;
                val.appendIf(false, true, true, "description", (Object)RestUtils.getHttpResponseText(Integer.parseInt(key)));
            }
            if (responses.isEmpty()) {
                op.remove((Object)"responses");
            } else {
                op.put((Object)"responses", new TreeMap(responses));
            }
            if (!op.containsKey((Object)"consumes") && !(mConsumes = restJavaMethod.supportedContentTypes).equals(consumes)) {
                op.put((Object)"consumes", mConsumes);
            }
            if (op.containsKey((Object)"produces") || (mProduces = restJavaMethod.supportedAcceptTypes).equals(produces)) continue;
            op.put((Object)"produces", mProduces);
        }
        if (this.js.getBeanDefs() != null) {
            for (Map.Entry entry : this.js.getBeanDefs().entrySet()) {
                definitions.put(entry.getKey(), (Object)this.fixSwaggerExtensions((ObjectMap)entry.getValue()));
            }
        }
        if (definitions.isEmpty()) {
            omSwagger.remove((Object)"definitions");
        }
        if (!tagMap.isEmpty()) {
            omSwagger.put((Object)"tags", tagMap.values());
        }
        if (consumes.isEmpty()) {
            omSwagger.remove((Object)"consumes");
        }
        if (produces.isEmpty()) {
            omSwagger.remove((Object)"produces");
        }
        try {
            String swaggerJson = omSwagger.toString((WriterSerializer)SimpleJsonSerializer.DEFAULT_READABLE);
            return (Swagger)this.jp.parse((Object)swaggerJson, Swagger.class);
        }
        catch (Exception e) {
            throw new RestServletException("Error detected in swagger.", new Object[0]).initCause(e);
        }
    }

    private ObjectMap resolve(ObjectMap om) throws ParseException {
        ObjectMap om2 = null;
        if (om.containsKey((Object)"_value")) {
            om = om.modifiable();
            om2 = this.parseMap(om.remove((Object)"_value"));
        } else {
            om2 = new ObjectMap();
        }
        for (Map.Entry e : om.entrySet()) {
            Object val = e.getValue();
            if (val instanceof ObjectMap) {
                val = this.resolve((ObjectMap)val);
            } else if (val instanceof ObjectList) {
                val = this.resolve((ObjectList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            om2.put(e.getKey(), val);
        }
        return om2;
    }

    private ObjectList resolve(ObjectList om) throws ParseException {
        ObjectList ol2 = new ObjectList();
        for (Object val : om) {
            if (val instanceof ObjectMap) {
                val = this.resolve((ObjectMap)val);
            } else if (val instanceof ObjectList) {
                val = this.resolve((ObjectList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            ol2.add(val);
        }
        return ol2;
    }

    private String resolve(String[] ss) {
        if (ss.length == 0) {
            return null;
        }
        return this.resolve(SwaggerGenerator.joinnl(ss));
    }

    private String resolve(String s) {
        if (s == null) {
            return null;
        }
        return this.vr.resolve(s.trim());
    }

    private ObjectMap parseMap(String[] o, String location, Object ... args) throws ParseException {
        if (o.length == 0) {
            return ObjectMap.EMPTY_MAP;
        }
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private ObjectMap parseMap(String o, String location, Object ... args) throws ParseException {
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private ObjectMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = SwaggerGenerator.joinnl((String[])o);
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase(s = this.resolve(s))) {
                return new ObjectMap().append("ignore", (Object)true);
            }
            if (!StringUtils.isObjectMap((Object)s, (boolean)true)) {
                s = "{" + s + "}";
            }
            return new ObjectMap((CharSequence)s);
        }
        if (o instanceof ObjectMap) {
            return (ObjectMap)o;
        }
        throw new SwaggerException(null, "Unexpected data type ''{0}''.  Expected ObjectMap or String.", o.getClass().getName());
    }

    private ObjectList parseList(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl((String[])o) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if (!StringUtils.isObjectList((Object)(s = this.resolve(s)), (boolean)true)) {
                s = "[" + s + "]";
            }
            return new ObjectList((CharSequence)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private ObjectList parseListOrCdl(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl((String[])o) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            s = this.resolve(s);
            return StringUtils.parseListOrCdl((String)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private ObjectMap newMap(ObjectMap om, String[] value, String location, Object ... locationArgs) throws ParseException {
        if (value.length == 0) {
            return om == null ? new ObjectMap() : om;
        }
        ObjectMap om2 = this.parseMap(SwaggerGenerator.joinnl(value), location, locationArgs);
        if (om == null) {
            return om2;
        }
        return om.appendAll((Map)om2);
    }

    private ObjectMap merge(ObjectMap ... maps) {
        ObjectMap m = maps[0];
        for (int i = 1; i < maps.length; ++i) {
            if (maps[i] == null) continue;
            if (m == null) {
                m = new ObjectMap();
            }
            m.putAll((Map)maps[i]);
        }
        return m;
    }

    private ObjectList merge(ObjectList ... lists) {
        ObjectList l = lists[0];
        for (int i = 1; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            if (l == null) {
                l = new ObjectList();
            }
            l.addAll((Collection)lists[i]);
        }
        return l;
    }

    @SafeVarargs
    private final <T> T firstNonEmpty(T ... t) {
        return (T)ObjectUtils.firstNonEmpty((Object[])t);
    }

    private ObjectMap toMap(ExternalDocs a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((ExternalDocs)a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("description", (Object)this.resolve(SwaggerGenerator.joinnl(a.description())));
        om.appendSkipEmpty("url", (Object)this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(Contact a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((Contact)a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", (Object)this.resolve(a.name()));
        om.appendSkipEmpty("url", (Object)this.resolve(a.url()));
        om.appendSkipEmpty("email", (Object)this.resolve(a.email()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(License a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((License)a)) {
            return null;
        }
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", (Object)this.resolve(a.name()));
        om.appendSkipEmpty("url", (Object)this.resolve(a.url()));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap toMap(Tag a, String location, Object ... locationArgs) throws ParseException {
        ObjectMap om = this.newMap(new ObjectMap(), a.value(), location, locationArgs);
        om.appendSkipEmpty("name", (Object)this.resolve(a.name()));
        om.appendSkipEmpty("description", (Object)this.resolve(SwaggerGenerator.joinnl(a.description())));
        om.appendSkipNull("externalDocs", (Object)this.merge(om.getObjectMap("externalDocs"), this.toMap(a.externalDocs(), location, locationArgs)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectList toList(Tag[] aa, String location, Object ... locationArgs) throws ParseException {
        if (aa.length == 0) {
            return null;
        }
        ObjectList ol = new ObjectList();
        for (Tag a : aa) {
            ol.add((Object)this.toMap(a, location, locationArgs));
        }
        return SwaggerGenerator.nullIfEmpty(ol);
    }

    private ObjectMap getSchema(ObjectMap schema, Type type) throws Exception {
        schema = SwaggerGenerator.newMap(schema);
        ClassMeta cm = this.bs.getClassMeta(type, new Type[0]);
        if (schema.getBoolean("ignore", Boolean.valueOf(false)).booleanValue()) {
            return null;
        }
        if (schema.containsKey((Object)"type") || schema.containsKey((Object)"$ref")) {
            return schema;
        }
        ObjectMap om = this.fixSwaggerExtensions(schema.appendAll((Map)this.js.getSchema(cm)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private ObjectMap fixSwaggerExtensions(ObjectMap om) {
        om.appendSkipNull("discriminator", om.remove((Object)"x-discriminator"));
        om.appendSkipNull("readOnly", om.remove((Object)"x-readOnly"));
        om.appendSkipNull("xml", om.remove((Object)"x-xml"));
        om.appendSkipNull("externalDocs", om.remove((Object)"x-externalDocs"));
        om.appendSkipNull("example", om.remove((Object)"x-example"));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private void addBodyExamples(RestJavaMethod sm, ObjectMap piri, boolean response, Type type) throws Exception {
        ObjectMap schema;
        String sex = piri.getString("x-example");
        if (sex == null && (schema = this.resolveRef(piri.getObjectMap("schema"))) != null) {
            sex = schema.getString("example", schema.getString("x-example"));
        }
        if (StringUtils.isEmpty((String)sex)) {
            return;
        }
        Object example = null;
        if (StringUtils.isJson((String)sex)) {
            example = this.jp.parse((Object)sex, type, new Type[0]);
        } else {
            ClassMeta cm = this.js.getClassMeta(type, new Type[0]);
            if (cm.hasStringTransform()) {
                example = cm.getStringTransform().transform((Object)sex);
            }
        }
        String examplesKey = response ? "examples" : "x-examples";
        ObjectMap examples = piri.getObjectMap(examplesKey);
        if (examples == null) {
            examples = new ObjectMap();
        }
        List mediaTypes = response ? sm.getSerializers().getSupportedMediaTypes() : sm.getParsers().getSupportedMediaTypes();
        for (MediaType mt : mediaTypes) {
            Serializer s2;
            if (mt == MediaType.HTML || (s2 = sm.getSerializers().getSerializer(mt)) == null) continue;
            SerializerSessionArgs args = new SerializerSessionArgs(null, this.req.getJavaMethod(), this.req.getLocale(), null, mt, null, this.req.isDebug() ? Boolean.valueOf(true) : null, this.req.getUriContext(), Boolean.valueOf(true));
            try {
                String eVal = s2.createSession(args).serializeToString(example);
                examples.put((Object)s2.getPrimaryMediaType().toString(), (Object)eVal);
            }
            catch (Exception e) {
                System.err.println("Could not serialize to media type [" + mt + "]: " + e.getLocalizedMessage());
            }
        }
        if (!examples.isEmpty()) {
            piri.put((Object)examplesKey, (Object)examples);
        }
    }

    private void addParamExample(RestJavaMethod sm, ObjectMap piri, RestParamType in, Type type) throws Exception {
        String s = piri.getString("x-example");
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        ObjectMap examples = piri.getObjectMap("x-examples");
        if (examples == null) {
            examples = new ObjectMap();
        }
        String paramName = piri.getString("name");
        if (in == RestParamType.QUERY) {
            s = "?" + StringUtils.urlEncodeLax((String)paramName) + "=" + StringUtils.urlEncodeLax((String)s);
        } else if (in == RestParamType.FORM_DATA) {
            s = paramName + "=" + s;
        } else if (in == RestParamType.HEADER) {
            s = paramName + ": " + s;
        } else if (in == RestParamType.PATH) {
            s = sm.getPathPattern().replace("{" + paramName + "}", StringUtils.urlEncodeLax((String)s));
        }
        examples.put((Object)"example", (Object)s);
        if (!examples.isEmpty()) {
            piri.put((Object)"x-examples", (Object)examples);
        }
    }

    private ObjectMap resolveRef(ObjectMap m) {
        String ref;
        if (m == null) {
            return null;
        }
        if (m.containsKey((Object)"$ref") && this.js.getBeanDefs() != null && (ref = m.getString("$ref")).startsWith("#/definitions/")) {
            return (ObjectMap)this.js.getBeanDefs().get(ref.substring(14));
        }
        return m;
    }

    private ObjectMap getOperation(ObjectMap om, String path, String httpMethod) {
        if (!om.containsKey((Object)"paths")) {
            om.put((Object)"paths", (Object)new ObjectMap());
        }
        if (!(om = om.getObjectMap("paths")).containsKey((Object)path)) {
            om.put((Object)path, (Object)new ObjectMap());
        }
        if (!(om = om.getObjectMap(path)).containsKey((Object)httpMethod)) {
            om.put((Object)httpMethod, (Object)new ObjectMap());
        }
        return om.getObjectMap(httpMethod);
    }

    private static ObjectMap newMap(ObjectMap om) {
        if (om == null) {
            return new ObjectMap();
        }
        return om.modifiable();
    }

    private ObjectMap merge(ObjectMap om, Body a) throws ParseException {
        if (AnnotationUtils.empty((Body)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipEmpty("x-examples", (Object)this.parseMap(a.examples())).appendSkipFalse("required", a.required()).appendSkipEmpty("schema", (Object)this.merge(om.getObjectMap("schema"), a.schema()));
    }

    private ObjectMap merge(ObjectMap om, Query a) throws ParseException {
        if (AnnotationUtils.empty((Query)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipFalse("allowEmptyValue", a.allowEmptyValue()).appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, FormData a) throws ParseException {
        if (AnnotationUtils.empty((FormData)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipFalse("allowEmptyValue", a.allowEmptyValue()).appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Header a) throws ParseException {
        if (AnnotationUtils.empty((Header)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("required", a.required()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Path a) throws ParseException {
        if (AnnotationUtils.empty((Path)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems());
    }

    private ObjectMap merge(ObjectMap om, Schema a) throws ParseException {
        if (AnnotationUtils.empty((Schema)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("additionalProperties", (Object)this.toObjectMap(a.additionalProperties())).appendSkipEmpty("allOf", (Object)SwaggerGenerator.joinnl(a.allOf())).appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("discriminator", (Object)a.discriminator()).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipEmpty("examples", (Object)this.parseMap(a.examples())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("externalDocs", (Object)this.merge(om.getObjectMap("externalDocs"), a.externalDocs())).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("ignore", (Object)(a.ignore() ? "true" : null)).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipMinusOne("maxProperties", (Number)a.maxProperties()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipMinusOne("minProperties", (Number)a.minProperties()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("properties", (Object)this.toObjectMap(a.properties())).appendSkipFalse("readOnly", a.readOnly()).appendSkipFalse("required", a.required()).appendSkipEmpty("title", (Object)a.title()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("xml", (Object)SwaggerGenerator.joinnl(a.xml())).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap merge(ObjectMap om, ExternalDocs a) throws ParseException {
        if (AnnotationUtils.empty((ExternalDocs)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("url", (Object)a.url());
    }

    private ObjectMap merge(ObjectMap om, Items a) throws ParseException {
        if (AnnotationUtils.empty((Items)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("format", (Object)a.format()).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("type", (Object)a.type()).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap merge(ObjectMap om, SubItems a) throws ParseException {
        if (AnnotationUtils.empty((SubItems)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.toObjectMap(a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap merge(ObjectMap om, Response a) throws ParseException {
        if (AnnotationUtils.empty((Response)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipEmpty("examples", (Object)this.parseMap(a.examples())).appendSkipEmpty("headers", (Object)this.merge(om.getObjectMap("headers"), a.headers())).appendSkipEmpty("schema", (Object)this.merge(om.getObjectMap("schema"), a.schema()));
    }

    private ObjectMap merge(ObjectMap om, ResponseHeader[] a) throws ParseException {
        if (a.length == 0) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        for (ResponseHeader aa : a) {
            String name = StringUtils.firstNonEmpty((String[])new String[]{aa.name(), aa.value()});
            if (StringUtils.isEmpty((String)name)) {
                throw new RuntimeException("@ResponseHeader used without name or value.");
            }
            om.getObjectMap(name, true).putAll((Map)this.merge(null, aa));
        }
        return om;
    }

    private ObjectMap merge(ObjectMap om, ResponseHeader a) throws ParseException {
        if (AnnotationUtils.empty((ResponseHeader)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.appendSkipEmpty("collectionFormat", (Object)a.collectionFormat()).appendSkipEmpty("default", (Object)SwaggerGenerator.joinnl(a._default())).appendSkipEmpty("description", (Object)this.resolve(a.description())).appendSkipEmpty("enum", this.toSet(a._enum())).appendSkipEmpty("x-example", (Object)this.resolve(a.example())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", (Object)a.format()).appendSkipEmpty("items", (Object)this.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", (Object)a.maximum()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipMinusOne("maxLength", (Number)a.maxLength()).appendSkipMinusOne("maxItems", (Number)a.maxItems()).appendSkipEmpty("minimum", (Object)a.minimum()).appendSkipMinusOne("minItems", (Number)a.minItems()).appendSkipMinusOne("minLength", (Number)a.minLength()).appendSkipEmpty("multipleOf", (Object)a.multipleOf()).appendSkipEmpty("pattern", (Object)a.pattern()).appendSkipEmpty("type", (Object)a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("$ref", (Object)a.$ref());
    }

    private ObjectMap mergePartSchema(ObjectMap param, ObjectMap schema) {
        if (schema != null) {
            param.appendIf(false, true, true, "collectionFormat", schema.remove((Object)"collectionFormat")).appendIf(false, true, true, "default", schema.remove((Object)"default")).appendIf(false, true, true, "description", schema.remove((Object)"enum")).appendIf(false, true, true, "enum", schema.remove((Object)"enum")).appendIf(false, true, true, "x-example", schema.remove((Object)"x-example")).appendIf(false, true, true, "exclusiveMaximum", schema.remove((Object)"exclusiveMaximum")).appendIf(false, true, true, "exclusiveMinimum", schema.remove((Object)"exclusiveMinimum")).appendIf(false, true, true, "format", schema.remove((Object)"format")).appendIf(false, true, true, "items", schema.remove((Object)"items")).appendIf(false, true, true, "maximum", schema.remove((Object)"maximum")).appendIf(false, true, true, "maxItems", schema.remove((Object)"maxItems")).appendIf(false, true, true, "maxLength", schema.remove((Object)"maxLength")).appendIf(false, true, true, "minimum", schema.remove((Object)"minimum")).appendIf(false, true, true, "minItems", schema.remove((Object)"minItems")).appendIf(false, true, true, "minLength", schema.remove((Object)"minLength")).appendIf(false, true, true, "multipleOf", schema.remove((Object)"multipleOf")).appendIf(false, true, true, "pattern", schema.remove((Object)"pattern")).appendIf(false, true, true, "required", schema.remove((Object)"required")).appendIf(false, true, true, "type", schema.remove((Object)"type")).appendIf(false, true, true, "uniqueItems", schema.remove((Object)"uniqueItems"));
            if ("object".equals(param.getString("type")) && !schema.isEmpty()) {
                param.put((Object)"schema", (Object)schema);
            }
        }
        return param;
    }

    private ObjectMap toObjectMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isObjectMap((Object)s, (boolean)true)) {
            s = "{" + s + "}";
        }
        s = this.resolve(s);
        return new ObjectMap((CharSequence)s);
    }

    private Set<String> toSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        s = this.resolve(s);
        ASet set = new ASet();
        for (Object o : StringUtils.parseListOrCdl((String)s)) {
            set.add(o.toString());
        }
        return set;
    }

    static String joinnl(String[] ss) {
        if (ss.length == 0) {
            return "";
        }
        return StringUtils.joinnl((Object[])ss).trim();
    }

    private static Set<Integer> getCodes(List<Response> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (Response a : la) {
            for (int i : a.value()) {
                codes.add(i);
            }
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static Set<Integer> getCodes2(List<ResponseHeader> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (ResponseHeader a : la) {
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static ObjectMap nullIfEmpty(ObjectMap m) {
        return m == null || m.isEmpty() ? null : m;
    }

    private static ObjectList nullIfEmpty(ObjectList l) {
        return l == null || l.isEmpty() ? null : l;
    }
}

