/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.juneau.rest.RestJavaMethod;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletException;

public class RestCallRouter {
    private final RestJavaMethod[] restJavaMethods;

    RestCallRouter(RestJavaMethod[] callMethods) {
        this.restJavaMethods = callMethods;
    }

    int invoke(String pathInfo, RestRequest req, RestResponse res) throws Throwable {
        if (this.restJavaMethods.length == 1) {
            return this.restJavaMethods[0].invoke(pathInfo, req, res);
        }
        int maxRc = 0;
        for (RestJavaMethod m : this.restJavaMethods) {
            int rc = m.invoke(pathInfo, req, res);
            if (rc == 200) {
                return 200;
            }
            maxRc = Math.max(maxRc, rc);
        }
        return maxRc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RestCallRouter: [\n");
        for (RestJavaMethod sm : this.restJavaMethods) {
            sb.append("\t" + sm + "\n");
        }
        sb.append("]");
        return sb.toString();
    }

    static final class Builder {
        private List<RestJavaMethod> childMethods = new ArrayList<RestJavaMethod>();
        private Set<String> collisions = new HashSet<String>();
        private String httpMethodName;

        Builder(String httpMethodName) {
            this.httpMethodName = httpMethodName;
        }

        String getHttpMethodName() {
            return this.httpMethodName;
        }

        Builder add(RestJavaMethod m) throws RestServletException {
            if (!m.hasGuardsOrMatchers()) {
                String p = m.getHttpMethod() + ":" + m.getPathPattern();
                if (this.collisions.contains(p)) {
                    throw new RestServletException("Duplicate Java methods assigned to the same method/pattern:  ''{0}''", p);
                }
                this.collisions.add(p);
            }
            this.childMethods.add(m);
            return this;
        }

        RestCallRouter build() {
            Collections.sort(this.childMethods);
            return new RestCallRouter(this.childMethods.toArray(new RestJavaMethod[this.childMethods.size()]));
        }
    }
}

