/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.exception.BadRequest;
import org.apache.juneau.rest.exception.InternalServerError;

public class RequestFormData
extends LinkedHashMap<String, String[]> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private final HttpPartParser parser;

    RequestFormData(RestRequest req, HttpPartParser parser) {
        this.req = req;
        this.parser = parser;
    }

    public RequestFormData addDefault(Map<String, Object> defaultEntries) {
        if (defaultEntries != null) {
            for (Map.Entry<String, Object> e : defaultEntries.entrySet()) {
                String key = e.getKey();
                Object value = e.getValue();
                String[] v = (String[])this.get(key);
                if (v != null && v.length != 0 && !StringUtils.isEmpty((String)v[0])) continue;
                this.put(key, StringUtils.asStrings((Object[])new Object[]{value}));
            }
        }
        return this;
    }

    public RequestFormData addDefault(String name, Object value) {
        return this.addDefault(Collections.singletonMap(name, value));
    }

    @Override
    public void put(String name, Object value) {
        super.put(name, StringUtils.asStrings((Object[])new Object[]{value}));
    }

    public String getString(String name) {
        String[] v = (String[])this.get(name);
        if (v == null || v.length == 0) {
            return null;
        }
        if (v.length == 1 && v[0] == null) {
            return "";
        }
        return v[0];
    }

    public String getString(String name, String def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : s;
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : Integer.parseInt(s);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : Boolean.parseBoolean(s);
    }

    public <T> T get(String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type));
    }

    public <T> T get(HttpPartParser parser, HttpPartSchema schema, String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type));
    }

    public <T> T get(String name, T def, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, def, this.getClassMeta(type));
    }

    public <T> T get(HttpPartParser parser, HttpPartSchema schema, String name, T def, Class<T> type) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, def, this.getClassMeta(type));
    }

    public <T> T getAll(String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getAllInner(null, null, name, null, this.getClassMeta(type));
    }

    public <T> T getAll(HttpPartParser parser, HttpPartSchema schema, String name, Class<T> type) throws BadRequest, InternalServerError {
        return this.getAllInner(parser, schema, name, null, this.getClassMeta(type));
    }

    public <T> T get(String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, null, this.getClassMeta(type, args));
    }

    public <T> T get(HttpPartParser parser, HttpPartSchema schema, String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, null, this.getClassMeta(type, args));
    }

    public <T> T get(String name, T def, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(null, null, name, def, this.getClassMeta(type, args));
    }

    public <T> T get(HttpPartParser parser, HttpPartSchema schema, String name, T def, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getInner(parser, schema, name, def, this.getClassMeta(type, args));
    }

    public <T> T getAll(String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getAllInner(null, null, name, null, this.getClassMeta(type, args));
    }

    public <T> T getAll(HttpPartParser parser, HttpPartSchema schema, String name, Type type, Type ... args) throws BadRequest, InternalServerError {
        return this.getAllInner(parser, schema, name, null, this.getClassMeta(type, args));
    }

    private <T> T getInner(HttpPartParser parser, HttpPartSchema schema, String name, T def, ClassMeta<T> cm) throws BadRequest, InternalServerError {
        try {
            if (cm.isMapOrBean() && StringUtils.isOneOf((String)name, (String[])new String[]{"*", ""})) {
                ObjectMap m = new ObjectMap();
                for (Map.Entry e : this.entrySet()) {
                    String k = (String)e.getKey();
                    HttpPartSchema pschema = schema == null ? null : schema.getProperty(k);
                    ClassMeta cm2 = cm.getValueType();
                    if (cm.getValueType().isCollectionOrArray()) {
                        m.put((Object)k, this.getAllInner(parser, pschema, k, null, cm2));
                        continue;
                    }
                    m.put((Object)k, this.getInner(parser, pschema, k, null, cm2));
                }
                return (T)this.req.getBeanSession().convertToType((Object)m, cm);
            }
            T t = this.parse(parser, schema, this.getString(name), cm);
            return t == null ? def : t;
        }
        catch (SchemaValidationException e) {
            throw new BadRequest((Throwable)e, "Validation failed on form-data parameter ''{0}''. ", name);
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not parse form-data parameter ''{0}''.", name);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Could not parse form-data parameter ''{0}''.", name);
        }
    }

    <T> T getAllInner(HttpPartParser parser, HttpPartSchema schema, String name, T def, ClassMeta<T> cm) throws BadRequest, InternalServerError {
        String[] p = (String[])this.get(name);
        if (p == null) {
            return def;
        }
        if (schema == null) {
            schema = HttpPartSchema.DEFAULT;
        }
        try {
            if (cm.isArray()) {
                ArrayList<T> c = new ArrayList<T>();
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parse(parser, schema.getItems(), p[i], cm.getElementType()));
                }
                return (T)ArrayUtils.toArray(c, (Class)cm.getElementType().getInnerClass());
            }
            if (cm.isCollection()) {
                Collection c = (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new ObjectList());
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parse(parser, schema.getItems(), p[i], cm.getElementType()));
                }
                return (T)c;
            }
        }
        catch (SchemaValidationException e) {
            throw new BadRequest((Throwable)e, "Validation failed on form-data parameter ''{0}''. ", name);
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not parse form-data parameter ''{0}''.", name);
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e, "Could not parse form-data parameter ''{0}''.", name);
        }
        throw new InternalServerError("Invalid call to getParameters(String, ClassMeta).  Class type must be a Collection or array.");
    }

    private <T> T parse(HttpPartParser parser, HttpPartSchema schema, String val, ClassMeta<T> c) throws SchemaValidationException, ParseException {
        if (parser == null) {
            parser = this.parser;
        }
        return (T)parser.createPartSession(this.req.getParserSessionArgs()).parse(HttpPartType.FORMDATA, schema, val, c);
    }

    public String toString(boolean sorted) {
        AbstractMap m = null;
        m = sorted ? new TreeMap() : new LinkedHashMap();
        for (Map.Entry e : this.entrySet()) {
            String[] v = (String[])e.getValue();
            if (v == null) continue;
            m.put(e.getKey(), v.length == 1 ? v[0] : v);
        }
        return SimpleJsonSerializer.DEFAULT.toString(m);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    private <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        return this.req.getBeanSession().getClassMeta(type, args);
    }

    private <T> ClassMeta<T> getClassMeta(Class<T> type) {
        return this.req.getBeanSession().getClassMeta(type);
    }
}

