/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestLogger;

public class BasicRestLogger
implements RestLogger {
    private final JuneauLogger logger = JuneauLogger.getLogger(this.getClass());

    protected Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLevel(Level level) {
        this.getLogger().setLevel(level);
    }

    @Override
    public void log(Level level, Throwable cause, String msg, Object ... args) {
        msg = StringUtils.format((String)msg, (Object[])args);
        this.getLogger().log(level, msg, cause);
    }

    @Override
    public void log(Level level, String msg, Object ... args) {
        this.log(level, null, msg, args);
    }

    @Override
    public void logObjects(Level level, String msg, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = SimpleJsonSerializer.DEFAULT_READABLE.toStringObject(args[i]);
        }
        this.log(level, null, msg, args);
    }

    @Override
    public void onError(HttpServletRequest req, HttpServletResponse res, RestException e) {
        if (this.shouldLog(req, res, e)) {
            String qs = req.getQueryString();
            String msg = "HTTP " + req.getMethod() + " " + e.getStatus() + " " + req.getRequestURI() + (qs == null ? "" : "?" + qs);
            int c = e.getOccurrence();
            if (this.shouldLogStackTrace(req, res, e)) {
                msg = '[' + Integer.toHexString(e.hashCode()) + '.' + e.getStatus() + '.' + c + "] " + msg;
                this.log(Level.WARNING, e, msg, new Object[0]);
            } else {
                msg = '[' + Integer.toHexString(e.hashCode()) + '.' + e.getStatus() + '.' + c + "] " + msg + ", " + e.getLocalizedMessage();
                this.log(Level.WARNING, msg, new Object[0]);
            }
        }
    }

    protected boolean shouldLog(HttpServletRequest req, HttpServletResponse res, RestException e) {
        return !BasicRestLogger.isNoTrace(req) || BasicRestLogger.isDebug(req);
    }

    protected boolean shouldLogStackTrace(HttpServletRequest req, HttpServletResponse res, RestException e) {
        if (e.getOccurrence() == 1) {
            switch (e.getStatus()) {
                case 401: 
                case 403: 
                case 404: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isNoTrace(HttpServletRequest req) {
        return StringUtils.contains((String)req.getHeader("No-Trace"), (CharSequence)"true") || StringUtils.contains((String)req.getQueryString(), (CharSequence)"noTrace=true");
    }

    private static boolean isDebug(HttpServletRequest req) {
        return StringUtils.contains((String)req.getHeader("Debug"), (CharSequence)"true");
    }
}

