/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.http.StreamResource;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestCallRouter;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.exception.MethodNotAllowed;
import org.apache.juneau.rest.exception.NotFound;
import org.apache.juneau.rest.exception.NotImplemented;
import org.apache.juneau.rest.exception.PreconditionFailed;
import org.apache.juneau.rest.util.RestUtils;

public class BasicRestCallHandler
implements RestCallHandler {
    private final RestContext context;
    private final RestLogger logger;
    private final Map<String, RestCallRouter> restCallRouters;

    public BasicRestCallHandler(RestContext context) {
        this.context = context;
        this.logger = context.getLogger();
        this.restCallRouters = context.getCallRouters();
    }

    @Override
    public RestRequest createRequest(HttpServletRequest req) throws ServletException {
        return new RestRequest(this.context, req);
    }

    @Override
    public RestResponse createResponse(RestRequest req, HttpServletResponse res) throws ServletException {
        return new RestResponse(this.context, req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        this.logger.log(Level.FINE, "HTTP: {0} {1}", r1.getMethod(), r1.getRequestURI());
        long startTime = System.currentTimeMillis();
        RestRequest req = null;
        try {
            int i;
            String pathInfoPart;
            RestContext childResource;
            this.context.checkForInitException();
            String pathInfo = RestUtils.getPathInfoUndecoded(r1);
            if (pathInfo != null && this.context.hasChildResources() && !pathInfo.equals("/") && (childResource = this.context.getChildResource(pathInfoPart = (i = pathInfo.indexOf(47, 1)) == -1 ? pathInfo.substring(1) : pathInfo.substring(1, i))) != null) {
                final String pathInfoRemainder = i == -1 ? null : pathInfo.substring(i);
                final String servletPath = r1.getServletPath() + "/" + pathInfoPart;
                HttpServletRequestWrapper childRequest = new HttpServletRequestWrapper(r1){

                    public String getPathInfo() {
                        return StringUtils.urlDecode((String)pathInfoRemainder);
                    }

                    public String getServletPath() {
                        return servletPath;
                    }
                };
                childResource.getCallHandler().service((HttpServletRequest)childRequest, r2);
                return;
            }
            this.context.startCall(r1, r2);
            req = this.createRequest(r1);
            RestResponse res = this.createResponse(req, r2);
            this.context.setRequest(req);
            this.context.setResponse(res);
            String method = req.getMethod();
            String methodUC = method.toUpperCase(Locale.ENGLISH);
            StreamResource r = null;
            if (pathInfo != null) {
                String p = pathInfo.substring(1);
                if (this.context.isStaticFile(p)) {
                    RestContext.StaticFile sf = this.context.resolveStaticFile(p);
                    r = sf.resource;
                    res.setResponseMeta(sf.meta);
                } else if (p.equals("favicon.ico")) {
                    res.setOutput(null);
                }
            }
            if (r != null) {
                res.setStatus(200);
                res.setOutput(r);
            } else {
                int rc = 405;
                if (this.restCallRouters.containsKey(methodUC)) {
                    rc = this.restCallRouters.get(methodUC).invoke(pathInfo, req, res);
                } else if (this.restCallRouters.containsKey("*")) {
                    rc = this.restCallRouters.get("*").invoke(pathInfo, req, res);
                }
                if (rc != 200) {
                    this.handleNotFound(rc, req, res);
                }
                if (res.getStatus() == 0) {
                    res.setStatus(rc);
                }
            }
            if (res.hasOutput()) {
                for (RestConverter converter : this.context.getConverters()) {
                    res.setOutput(converter.convert(req, res.getOutput()));
                }
                this.handleResponse(req, res);
            }
            res.flushBuffer();
            req.close();
            r1.setAttribute("ExecTime", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Throwable e) {
            r1.setAttribute("Exception", (Object)e);
            r1.setAttribute("ExecTime", (Object)(System.currentTimeMillis() - startTime));
            this.handleError(r1, r2, e);
        }
        finally {
            this.context.clearState();
        }
        this.context.finishCall(r1, r2);
        this.logger.log(Level.FINE, "HTTP: [{0} {1}] finished in {2}ms", r1.getMethod(), r1.getRequestURI(), System.currentTimeMillis() - startTime);
    }

    @Override
    public void handleResponse(RestRequest req, RestResponse res) throws IOException, RestException, NotImplemented {
        for (ResponseHandler h : this.context.getResponseHandlers()) {
            if (!h.handle(req, res)) continue;
            return;
        }
        Object output = res.getOutput();
        throw new NotImplemented("No response handlers found to process output of type '" + (output == null ? null : output.getClass().getName()) + "'");
    }

    @Override
    public void handleNotFound(int rc, RestRequest req, RestResponse res) throws NotFound, PreconditionFailed, MethodNotAllowed, ServletException {
        String onPath;
        String pathInfo = req.getPathInfo();
        String methodUC = req.getMethod();
        String string = onPath = pathInfo == null ? " on no pathInfo" : String.format(" on path '%s'", pathInfo);
        if (rc == 404) {
            throw new NotFound("Method ''{0}'' not found on resource with matching pattern{1}.", methodUC, onPath);
        }
        if (rc == 412) {
            throw new PreconditionFailed("Method ''{0}'' not found on resource{1} with matching matcher.", methodUC, onPath);
        }
        if (rc == 405) {
            throw new MethodNotAllowed("Method ''{0}'' not found on resource.", methodUC);
        }
        throw new ServletException("Invalid method response: " + rc);
    }

    @Override
    public synchronized void handleError(HttpServletRequest req, HttpServletResponse res, Throwable e) throws IOException {
        int occurrence;
        RestException e2 = (e instanceof RestException ? (RestException)e : new RestException(e, 500)).setOccurrence(occurrence = this.context == null ? 0 : this.context.getStackTraceOccurrence(e));
        Throwable t = e2.getRootCause();
        if (t != null) {
            res.setHeader("Exception-Name", t.getClass().getName());
            res.setHeader("Exception-Message", t.getMessage());
        }
        try {
            res.setContentType("text/plain");
            res.setHeader("Content-Encoding", "identity");
            res.setStatus(e2.getStatus());
            PrintWriter w = null;
            try {
                w = res.getWriter();
            }
            catch (IllegalStateException x) {
                w = new PrintWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), IOUtils.UTF8));
            }
            try (PrintWriter w2 = w;){
                String httpMessage = RestUtils.getHttpResponseText(e2.getStatus());
                if (httpMessage != null) {
                    w2.append("HTTP ").append(String.valueOf(e2.getStatus())).append(": ").append(httpMessage).append("\n\n");
                }
                if (this.context != null && this.context.isRenderResponseStackTraces()) {
                    e.printStackTrace(w2);
                } else {
                    w2.append(e2.getFullStackMessage(true));
                }
            }
        }
        catch (Exception e1) {
            this.logger.onError(req, res, new RestException(e1, 0));
        }
        if (this.context.isDebug()) {
            String qs = req.getQueryString();
            String msg = '[' + Integer.toHexString(e.hashCode()) + '.' + e2.getStatus() + '.' + e2.getOccurrence() + "] HTTP " + req.getMethod() + " " + e2.getStatus() + " " + req.getRequestURI() + (qs == null ? "" : "?" + qs);
            System.err.println(msg);
            e.printStackTrace(System.err);
            this.logger.log(Level.SEVERE, e, e.getLocalizedMessage(), new Object[0]);
        }
        this.logger.onError(req, res, e2);
    }

    @Override
    public Map<String, Object> getSessionObjects(RestRequest req) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("req", (Object)req);
        return m;
    }
}

