/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.Reader;
import java.io.Writer;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringBuilderWriter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;

public abstract class MenuItemWidget
extends Widget {
    @Override
    public String getScript(RestRequest req) throws Exception {
        return this.loadScript("MenuItemWidget.js");
    }

    public String getBeforeShowScript(RestRequest req) throws Exception {
        return null;
    }

    public String getAfterShowScript(RestRequest req) throws Exception {
        return null;
    }

    @Override
    public String getStyle(RestRequest req) throws Exception {
        return this.loadStyle("MenuItemWidget.css");
    }

    @Override
    public String getHtml(RestRequest req) throws Exception {
        StringBuilder sb;
        block30: {
            sb = new StringBuilder();
            Integer id = null;
            String pre = StringUtils.nullIfEmpty((String)this.getBeforeShowScript(req));
            String post = StringUtils.nullIfEmpty((String)this.getAfterShowScript(req));
            sb.append("\n<div class='menu-item'>");
            if (pre != null || post != null) {
                id = this.getId(req);
                sb.append("\n\t<script>");
                if (pre != null) {
                    sb.append("\n\t\tfunction onPreShow" + id + "() {");
                    sb.append("\n").append(pre);
                    sb.append("\n\t\t}");
                }
                if (post != null) {
                    sb.append("\n\t\tfunction onPostShow" + id + "() {");
                    sb.append("\n").append(pre);
                    sb.append("\n\t\t}");
                }
                sb.append("\n\t</script>");
            }
            String onclick = (pre == null ? "" : "onPreShow" + id + "();") + "menuClick(this);" + (post == null ? "" : "onPostShow" + id + "();");
            sb.append("\n\t<a onclick='" + onclick + "'>" + this.getLabel(req) + "</a>\n<div class='popup-content'>");
            Object o = this.getContent(req);
            if (o instanceof Reader) {
                try (Reader r = (Reader)o;
                     StringBuilderWriter w = new StringBuilderWriter(sb);){
                    IOUtils.pipe((Object)r, (Writer)w);
                    break block30;
                }
            }
            if (o instanceof CharSequence) {
                sb.append((CharSequence)o);
            } else {
                SerializerSessionArgs args = new SerializerSessionArgs((ObjectMap)req.getProperties(), null, req.getLocale(), null, null, null, req.isDebug() ? Boolean.valueOf(true) : null, req.getUriContext(), req.isPlainText() ? Boolean.valueOf(true) : null);
                WriterSerializerSession session = HtmlSerializer.DEFAULT.createSession(args);
                session.indent = 2;
                session.serialize(o, (Object)sb);
            }
        }
        sb.append("\n\t</div>\n</div>");
        return sb.toString();
    }

    private Integer getId(RestRequest req) {
        Integer id = (Integer)req.getAttribute("LastMenuItemId");
        id = id == null ? Integer.valueOf(1) : Integer.valueOf(id + 1);
        req.setAttribute("LastMenuItemId", id);
        return id;
    }

    public abstract String getLabel(RestRequest var1) throws Exception;

    public abstract Object getContent(RestRequest var1) throws Exception;
}

