/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.ParameterInfo;
import org.apache.juneau.dto.swagger.ResponseInfo;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.BeanPropertyUtils;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.ASet;

@Bean(properties="operationId,summary,description,tags,externalDocs,consumes,produces,parameters,responses,schemes,deprecated,security,*")
public class Operation
extends SwaggerElement {
    private String summary;
    private String description;
    private String operationId;
    private Boolean deprecated;
    private ExternalDocumentation externalDocs;
    private List<String> tags;
    private List<String> schemes;
    private List<MediaType> consumes;
    private List<MediaType> produces;
    private List<ParameterInfo> parameters;
    private List<Map<String, List<String>>> security;
    private Map<String, ResponseInfo> responses;

    public Operation() {
    }

    public Operation(Operation copyFrom) {
        super(copyFrom);
        this.summary = copyFrom.summary;
        this.description = copyFrom.description;
        this.operationId = copyFrom.operationId;
        this.deprecated = copyFrom.deprecated;
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.tags = BeanPropertyUtils.newList(copyFrom.tags);
        this.schemes = BeanPropertyUtils.newList(copyFrom.schemes);
        this.consumes = BeanPropertyUtils.newList(copyFrom.consumes);
        this.produces = BeanPropertyUtils.newList(copyFrom.produces);
        if (copyFrom.parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = new ArrayList<ParameterInfo>();
            for (ParameterInfo parameterInfo : copyFrom.parameters) {
                this.parameters.add(parameterInfo.copy());
            }
        }
        if (copyFrom.security == null) {
            this.security = null;
        } else {
            this.security = new ArrayList<Map<String, List<String>>>();
            for (Map map : copyFrom.security) {
                LinkedHashMap m2 = new LinkedHashMap();
                for (Map.Entry e : map.entrySet()) {
                    m2.put(e.getKey(), BeanPropertyUtils.newList((Collection)((Collection)e.getValue())));
                }
                this.security.add(m2);
            }
        }
        if (copyFrom.responses == null) {
            this.responses = null;
        } else {
            this.responses = new LinkedHashMap<String, ResponseInfo>();
            for (Map.Entry entry : copyFrom.responses.entrySet()) {
                this.responses.put((String)entry.getKey(), ((ResponseInfo)entry.getValue()).copy());
            }
        }
    }

    public Operation copy() {
        return new Operation(this);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Operation setTags(Collection<String> value) {
        this.tags = BeanPropertyUtils.newList(value);
        return this;
    }

    public Operation addTags(Collection<String> value) {
        this.tags = BeanPropertyUtils.addToList(this.tags, value);
        return this;
    }

    public Operation tags(Object ... values) {
        this.tags = BeanPropertyUtils.addToList(this.tags, (Object[])values, String.class, (Type[])new Type[0]);
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation setSummary(String value) {
        this.summary = value;
        return this;
    }

    public Operation summary(Object value) {
        return this.setSummary(BeanPropertyUtils.toStringVal((Object)value));
    }

    public String getDescription() {
        return this.description;
    }

    public Operation setDescription(String value) {
        this.description = value;
        return this;
    }

    public Operation description(Object value) {
        return this.setDescription(BeanPropertyUtils.toStringVal((Object)value));
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Operation setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public Operation externalDocs(Object value) {
        return this.setExternalDocs((ExternalDocumentation)BeanPropertyUtils.toType((Object)value, ExternalDocumentation.class, (Type[])new Type[0]));
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Operation setOperationId(String value) {
        this.operationId = value;
        return this;
    }

    public Operation operationId(Object value) {
        return this.setOperationId(BeanPropertyUtils.toStringVal((Object)value));
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public Operation setConsumes(Collection<MediaType> value) {
        this.consumes = BeanPropertyUtils.newList(value);
        return this;
    }

    public Operation addConsumes(Collection<MediaType> value) {
        this.consumes = BeanPropertyUtils.addToList(this.consumes, value);
        return this;
    }

    public Operation consumes(Object ... values) {
        this.consumes = BeanPropertyUtils.addToList(this.consumes, (Object[])values, MediaType.class, (Type[])new Type[0]);
        return this;
    }

    public List<MediaType> getProduces() {
        return this.produces;
    }

    public Operation setProduces(Collection<MediaType> value) {
        this.produces = BeanPropertyUtils.newList(value);
        return this;
    }

    public Operation addProduces(Collection<MediaType> value) {
        this.produces = BeanPropertyUtils.addToList(this.produces, value);
        return this;
    }

    public Operation produces(Object ... values) {
        this.produces = BeanPropertyUtils.addToList(this.produces, (Object[])values, MediaType.class, (Type[])new Type[0]);
        return this;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public ParameterInfo getParameter(String in, String name) {
        if (this.parameters != null) {
            for (ParameterInfo pi : this.parameters) {
                if (!StringUtils.isEquals((String)pi.getIn(), (String)in) || !StringUtils.isEquals((String)pi.getName(), (String)name) && !"body".equals(pi.getIn())) continue;
                return pi;
            }
        }
        return null;
    }

    public Operation setParameters(Collection<ParameterInfo> value) {
        this.parameters = BeanPropertyUtils.newList(value);
        return this;
    }

    public Operation addParameters(Collection<ParameterInfo> value) {
        this.parameters = BeanPropertyUtils.addToList(this.parameters, value);
        return this;
    }

    public Operation parameters(Object ... values) {
        this.parameters = BeanPropertyUtils.addToList(this.parameters, (Object[])values, ParameterInfo.class, (Type[])new Type[0]);
        return this;
    }

    public Map<String, ResponseInfo> getResponses() {
        return this.responses;
    }

    public ResponseInfo getResponse(Object status) {
        if (this.responses != null) {
            return this.responses.get(String.valueOf(status));
        }
        return null;
    }

    public Operation setResponses(Map<String, ResponseInfo> value) {
        this.responses = BeanPropertyUtils.newMap(value);
        return this;
    }

    public Operation addResponses(Map<String, ResponseInfo> values) {
        this.responses = BeanPropertyUtils.addToMap(this.responses, values);
        return this;
    }

    public Operation response(String statusCode, ResponseInfo response) {
        return this.addResponses(Collections.singletonMap(statusCode, response));
    }

    public Operation responses(Object ... value) {
        this.responses = BeanPropertyUtils.addToMap(this.responses, (Object[])value, String.class, ResponseInfo.class, (Type[])new Type[0]);
        return this;
    }

    public List<String> getSchemes() {
        return this.schemes;
    }

    public Operation setSchemes(Collection<String> value) {
        this.schemes = BeanPropertyUtils.newList(value);
        return this;
    }

    public Operation addSchemes(Collection<String> value) {
        this.schemes = BeanPropertyUtils.addToList(this.schemes, value);
        return this;
    }

    public Operation schemes(Object ... values) {
        this.schemes = BeanPropertyUtils.addToList(this.schemes, (Object[])values, String.class, (Type[])new Type[0]);
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated == true;
    }

    public Operation setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public Operation deprecated(Object value) {
        return this.setDeprecated(BeanPropertyUtils.toBoolean((Object)value));
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public Operation setSecurity(Collection<Map<String, List<String>>> value) {
        this.security = BeanPropertyUtils.newList(value);
        return this;
    }

    public Operation addSecurity(Collection<Map<String, List<String>>> values) {
        this.security = BeanPropertyUtils.addToList(this.security, values);
        return this;
    }

    public Operation security(String scheme, String ... alternatives) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        m.put(scheme, Arrays.asList(alternatives));
        return this.addSecurity(Collections.singletonList(m));
    }

    public Operation securities(Object ... value) {
        this.security = BeanPropertyUtils.addToList(this.security, (Object[])value, Map.class, (Type[])new Type[]{String.class, List.class, String.class});
        return this;
    }

    public boolean hasSummary() {
        return StringUtils.isNotEmpty((String)this.summary);
    }

    public boolean hasDescription() {
        return StringUtils.isNotEmpty((String)this.description);
    }

    public boolean hasTag(String name) {
        return this.tags != null && this.tags.contains(name);
    }

    public boolean hasNoTags() {
        return this.tags == null || this.tags.isEmpty();
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public boolean hasResponses() {
        return this.responses != null && !this.responses.isEmpty();
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "tags": {
                return (T)BeanPropertyUtils.toType(this.getTags(), type, (Type[])new Type[0]);
            }
            case "summary": {
                return (T)BeanPropertyUtils.toType((Object)this.getSummary(), type, (Type[])new Type[0]);
            }
            case "description": {
                return (T)BeanPropertyUtils.toType((Object)this.getDescription(), type, (Type[])new Type[0]);
            }
            case "externalDocs": {
                return (T)BeanPropertyUtils.toType((Object)this.getExternalDocs(), type, (Type[])new Type[0]);
            }
            case "operationId": {
                return (T)BeanPropertyUtils.toType((Object)this.getOperationId(), type, (Type[])new Type[0]);
            }
            case "consumes": {
                return (T)BeanPropertyUtils.toType(this.getConsumes(), type, (Type[])new Type[0]);
            }
            case "produces": {
                return (T)BeanPropertyUtils.toType(this.getProduces(), type, (Type[])new Type[0]);
            }
            case "parameters": {
                return (T)BeanPropertyUtils.toType(this.getParameters(), type, (Type[])new Type[0]);
            }
            case "responses": {
                return (T)BeanPropertyUtils.toType(this.getResponses(), type, (Type[])new Type[0]);
            }
            case "schemes": {
                return (T)BeanPropertyUtils.toType(this.getSchemes(), type, (Type[])new Type[0]);
            }
            case "deprecated": {
                return (T)BeanPropertyUtils.toType((Object)this.getDeprecated(), type, (Type[])new Type[0]);
            }
            case "security": {
                return (T)BeanPropertyUtils.toType(this.getSecurity(), type, (Type[])new Type[0]);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Operation set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "tags": {
                return this.setTags(null).tags(value);
            }
            case "summary": {
                return this.summary(value);
            }
            case "description": {
                return this.description(value);
            }
            case "externalDocs": {
                return this.externalDocs(value);
            }
            case "operationId": {
                return this.operationId(value);
            }
            case "consumes": {
                return this.setConsumes(null).consumes(value);
            }
            case "produces": {
                return this.setProduces(null).produces(value);
            }
            case "parameters": {
                return this.setParameters(null).parameters(value);
            }
            case "responses": {
                return this.setResponses(null).responses(value);
            }
            case "schemes": {
                return this.setSchemes(null).schemes(value);
            }
            case "deprecated": {
                return this.deprecated(value);
            }
            case "security": {
                return this.setSecurity(null).securities(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        ASet s = new ASet().appendIf(this.tags != null, (Object)"tags").appendIf(this.summary != null, (Object)"summary").appendIf(this.description != null, (Object)"description").appendIf(this.externalDocs != null, (Object)"externalDocs").appendIf(this.operationId != null, (Object)"operationId").appendIf(this.consumes != null, (Object)"consumes").appendIf(this.produces != null, (Object)"produces").appendIf(this.parameters != null, (Object)"parameters").appendIf(this.responses != null, (Object)"responses").appendIf(this.schemes != null, (Object)"schemes").appendIf(this.deprecated != null, (Object)"deprecated").appendIf(this.security != null, (Object)"security");
        return new MultiSet(new Collection[]{s, super.keySet()});
    }
}

