/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.util.Calendar;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.dto.atom.Category;
import org.apache.juneau.dto.atom.CommonEntry;
import org.apache.juneau.dto.atom.Entry;
import org.apache.juneau.dto.atom.Generator;
import org.apache.juneau.dto.atom.Icon;
import org.apache.juneau.dto.atom.Id;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Logo;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.dto.atom.Text;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

@Bean(typeName="feed")
public class Feed
extends CommonEntry {
    private Generator generator;
    private Icon icon;
    private Logo logo;
    private Text subtitle;
    private Entry[] entries;

    public Feed(Id id, Text title, Calendar updated) {
        super(id, title, updated);
    }

    public Feed(String id, String title, String updated) {
        super(id, title, updated);
    }

    public Feed() {
    }

    public Generator getGenerator() {
        return this.generator;
    }

    @BeanProperty(value="generator")
    public Feed generator(Generator generator) {
        this.generator = generator;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @BeanProperty(value="icon")
    public Feed icon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public Logo getLogo() {
        return this.logo;
    }

    @BeanProperty(value="logo")
    public Feed logo(Logo logo) {
        this.logo = logo;
        return this;
    }

    @BeanProperty(value="subtitle")
    public Text getSubTitle() {
        return this.subtitle;
    }

    @BeanProperty(value="subtitle")
    public Feed subtitle(Text subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public Feed subtitle(String subtitle) {
        this.subtitle = new Text(subtitle);
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED)
    public Entry[] getEntries() {
        return this.entries;
    }

    @BeanProperty(value="entries")
    public Feed entries(Entry ... entries) {
        this.entries = entries;
        return this;
    }

    @Override
    public Feed authors(Person ... authors) {
        super.authors(authors);
        return this;
    }

    @Override
    public Feed categories(Category ... categories) {
        super.categories(categories);
        return this;
    }

    @Override
    public Feed contributors(Person ... contributors) {
        super.contributors(contributors);
        return this;
    }

    @Override
    public Feed id(Id id) {
        super.id(id);
        return this;
    }

    @Override
    public Feed links(Link ... links) {
        super.links(links);
        return this;
    }

    @Override
    public Feed rights(Text rights) {
        super.rights(rights);
        return this;
    }

    @Override
    public Feed rights(String rights) {
        super.rights(rights);
        return this;
    }

    @Override
    public Feed title(Text title) {
        super.title(title);
        return this;
    }

    @Override
    public Feed title(String title) {
        super.title(title);
        return this;
    }

    @Override
    public Feed updated(Calendar updated) {
        super.updated(updated);
        return this;
    }

    @Override
    public Feed updated(String updated) {
        super.updated(updated);
        return this;
    }

    @Override
    public Feed base(Object base) {
        super.base(base);
        return this;
    }

    @Override
    public Feed lang(String lang) {
        super.lang(lang);
        return this;
    }
}

