/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolverException;

public class VarResolverContext {
    private final Class<?>[] vars;
    private final Map<String, Var> varMap;
    private final Map<String, Object> contextObjects;

    public VarResolverContext(Class<? extends Var>[] vars, Map<String, Object> contextObjects) {
        this.vars = Arrays.copyOf(vars, vars.length);
        ConcurrentSkipListMap<String, Var> m = new ConcurrentSkipListMap<String, Var>();
        for (Class<? extends Var> c : vars) {
            if (!ClassUtils.isParentClass(Var.class, c)) {
                throw new VarResolverException("Invalid variable class.  Must extend from Var", new Object[0]);
            }
            Var v = (Var)ClassUtils.newInstance(Var.class, c);
            m.put(v.getName(), v);
        }
        this.varMap = CollectionUtils.unmodifiableMap(m);
        this.contextObjects = CollectionUtils.immutableMap(contextObjects);
    }

    protected Map<String, Var> getVarMap() {
        return this.varMap;
    }

    protected Class<?>[] getVars() {
        return Arrays.copyOf(this.vars, this.vars.length);
    }

    protected Object getContextObject(String name) {
        return this.contextObjects == null ? null : this.contextObjects.get(name);
    }

    protected Map<String, Object> getContextObjects() {
        return this.contextObjects;
    }
}

