/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.PageProvider;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.search.SearchMatcher;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.search.SearchResultComparator;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

public abstract class AbstractFileProvider
implements PageProvider {
    private static final Logger LOG = LogManager.getLogger(AbstractFileProvider.class);
    private String m_pageDirectory = "/tmp/";
    protected String m_encoding;
    protected Engine m_engine;
    public static final String PROP_CUSTOMPROP_MAXLIMIT = "custom.pageproperty.max.allowed";
    public static final String PROP_CUSTOMPROP_MAXKEYLENGTH = "custom.pageproperty.key.length";
    public static final String PROP_CUSTOMPROP_MAXVALUELENGTH = "custom.pageproperty.value.length";
    public static final int DEFAULT_MAX_PROPLIMIT = 200;
    public static final int DEFAULT_MAX_PROPKEYLENGTH = 255;
    public static final int DEFAULT_MAX_PROPVALUELENGTH = 4096;
    public static int MAX_PROPLIMIT = 200;
    public static int MAX_PROPKEYLENGTH = 255;
    public static int MAX_PROPVALUELENGTH = 4096;
    public static final String PROP_PAGEDIR = "jspwiki.fileSystemProvider.pageDir";
    public static final String FILE_EXT = ".txt";
    public static final String DEFAULT_ENCODING = StandardCharsets.ISO_8859_1.toString();
    private boolean m_windowsHackNeeded;
    private static final String[] WINDOWS_DEVICE_NAMES = new String[]{"con", "prn", "nul", "aux", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9"};

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException, FileNotFoundException {
        LOG.debug("Initing FileSystemProvider");
        this.m_pageDirectory = TextUtil.getCanonicalFilePathProperty((Properties)properties, (String)PROP_PAGEDIR, (String)(System.getProperty("user.home") + File.separator + "jspwiki-files"));
        File f = new File(this.m_pageDirectory);
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new IOException("Failed to create page directory " + f.getAbsolutePath() + " , please check property jspwiki.fileSystemProvider.pageDir");
            }
        } else {
            if (!f.isDirectory()) {
                throw new IOException("Page directory is not a directory: " + f.getAbsolutePath());
            }
            if (!f.canWrite()) {
                throw new IOException("Page directory is not writable: " + f.getAbsolutePath());
            }
        }
        this.m_engine = engine;
        this.m_encoding = properties.getProperty("jspwiki.encoding", DEFAULT_ENCODING);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows") || os.equals("nt")) {
            this.m_windowsHackNeeded = true;
        }
        MAX_PROPLIMIT = TextUtil.getIntegerProperty((Properties)properties, (String)PROP_CUSTOMPROP_MAXLIMIT, (int)200);
        MAX_PROPKEYLENGTH = TextUtil.getIntegerProperty((Properties)properties, (String)PROP_CUSTOMPROP_MAXKEYLENGTH, (int)255);
        MAX_PROPVALUELENGTH = TextUtil.getIntegerProperty((Properties)properties, (String)PROP_CUSTOMPROP_MAXVALUELENGTH, (int)4096);
        LOG.info("Wikipages are read from '" + this.m_pageDirectory + "'");
    }

    String getPageDirectory() {
        return this.m_pageDirectory;
    }

    protected String mangleName(String pagename) {
        pagename = TextUtil.urlEncode((String)pagename, (String)this.m_encoding);
        if (((String)(pagename = TextUtil.replaceString((String)pagename, (String)"/", (String)"%2F"))).startsWith(".")) {
            pagename = "%2E" + ((String)pagename).substring(1);
        }
        if (this.m_windowsHackNeeded) {
            String pn = ((String)pagename).toLowerCase();
            StringBuilder pagenameBuilder = new StringBuilder((String)pagename);
            for (String windowsDeviceName : WINDOWS_DEVICE_NAMES) {
                if (!windowsDeviceName.equals(pn)) continue;
                pagenameBuilder.insert(0, "$$$");
            }
            pagename = pagenameBuilder.toString();
        }
        return pagename;
    }

    protected String unmangleName(String filename) {
        if (this.m_windowsHackNeeded && filename.startsWith("$$$") && filename.length() > 3) {
            filename = filename.substring(3);
        }
        return TextUtil.urlDecode((String)filename, (String)this.m_encoding);
    }

    protected File findPage(String page) {
        return new File(this.m_pageDirectory, this.mangleName(page) + FILE_EXT);
    }

    public boolean pageExists(String page) {
        return this.findPage(page).exists();
    }

    public boolean pageExists(String page, int version) {
        return this.pageExists(page);
    }

    public String getPageText(String page, int version) throws ProviderException {
        return this.getPageText(page);
    }

    private String getPageText(String page) {
        String result = null;
        File pagedata = this.findPage(page);
        if (pagedata.exists()) {
            if (pagedata.canRead()) {
                try (InputStream in = Files.newInputStream(pagedata.toPath(), new OpenOption[0]);){
                    result = FileUtil.readContents((InputStream)in, (String)this.m_encoding);
                }
                catch (IOException e) {
                    LOG.error("Failed to read", (Throwable)e);
                }
            } else {
                LOG.warn("Failed to read page '" + page + "' from '" + pagedata.getAbsolutePath() + "', possibly a permissions problem");
            }
        } else {
            LOG.info("New page '" + page + "'");
        }
        return result;
    }

    public void putPageText(Page page, String text) throws ProviderException {
        File file = this.findPage(page.getName());
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), this.m_encoding));){
            out.print(text);
        }
        catch (IOException e) {
            LOG.error("Saving failed", (Throwable)e);
        }
    }

    public Collection<Page> getAllPages() throws ProviderException {
        LOG.debug("Getting all pages...");
        ArrayList<Page> set = new ArrayList<Page>();
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        if (wikipages == null) {
            LOG.error("Wikipages directory '" + this.m_pageDirectory + "' does not exist! Please check jspwiki.fileSystemProvider.pageDir in jspwiki.properties.");
            throw new ProviderException("Page directory does not exist");
        }
        for (File wikipage : wikipages) {
            int cutpoint;
            String wikiname = wikipage.getName();
            Page page = this.getPageInfo(this.unmangleName(wikiname.substring(0, cutpoint = wikiname.lastIndexOf(FILE_EXT))), -1);
            if (page == null) {
                LOG.error("Page " + wikiname + " was found in directory listing, but could not be located individually.");
                continue;
            }
            set.add(page);
        }
        return set;
    }

    public Collection<Page> getAllChangedSince(Date date) {
        return new ArrayList<Page>();
    }

    public int getPageCount() {
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        return wikipages != null ? wikipages.length : 0;
    }

    public Collection<org.apache.wiki.api.search.SearchResult> findPages(QueryItem[] query) {
        File wikipagedir = new File(this.m_pageDirectory);
        TreeSet<org.apache.wiki.api.search.SearchResult> res = new TreeSet<org.apache.wiki.api.search.SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.m_engine, query);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        if (wikipages != null) {
            for (File wikipage : wikipages) {
                String filename = wikipage.getName();
                int cutpoint = filename.lastIndexOf(FILE_EXT);
                String wikiname = this.unmangleName(filename.substring(0, cutpoint));
                try (InputStream input = Files.newInputStream(wikipage.toPath(), new OpenOption[0]);){
                    String pagetext = FileUtil.readContents((InputStream)input, (String)this.m_encoding);
                    SearchResult comparison = matcher.matchPageContent(wikiname, pagetext);
                    if (comparison == null) continue;
                    res.add(comparison);
                }
                catch (IOException e) {
                    LOG.error("Failed to read " + filename, (Throwable)e);
                }
            }
        }
        return res;
    }

    public Page getPageInfo(String page, int version) throws ProviderException {
        File file = this.findPage(page);
        if (!file.exists()) {
            return null;
        }
        Page p = Wiki.contents().page(this.m_engine, page);
        p.setLastModified(new Date(file.lastModified()));
        return p;
    }

    public List<Page> getVersionHistory(String page) throws ProviderException {
        ArrayList<Page> list = new ArrayList<Page>();
        list.add(this.getPageInfo(page, -1));
        return list;
    }

    public String getProviderInfo() {
        return "";
    }

    public void deleteVersion(String pageName, int version) throws ProviderException {
        if (version == -1) {
            File f = this.findPage(pageName);
            f.delete();
        }
    }

    public void deletePage(String pageName) throws ProviderException {
        File f = this.findPage(pageName);
        f.delete();
    }

    protected void setCustomProperties(Page page, Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (key.equals("author") || key.equals("changenote") || key.equals("viewcount")) continue;
            page.setAttribute(key, properties.get(key));
        }
    }

    protected void getCustomProperties(Page page, Properties defaultProperties) throws IOException {
        Properties customPageProperties = this.addCustomProperties(page, defaultProperties);
        this.validateCustomPageProperties(customPageProperties);
        defaultProperties.putAll((Map<?, ?>)customPageProperties);
    }

    protected Properties addCustomProperties(Page page, Properties props) {
        Properties customProperties = new Properties();
        if (page != null) {
            Map atts = page.getAttributes();
            for (String key : atts.keySet()) {
                Object value = atts.get(key);
                if (!key.startsWith("@") || value == null) continue;
                customProperties.put(key, value.toString());
            }
        }
        return customProperties;
    }

    protected void validateCustomPageProperties(Properties customProperties) throws IOException {
        if (customProperties != null && !customProperties.isEmpty()) {
            if (customProperties.size() > MAX_PROPLIMIT) {
                throw new IOException("Too many custom properties. You are adding " + customProperties.size() + ", but max limit is " + MAX_PROPLIMIT);
            }
            Enumeration<?> propertyNames = customProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = (String)propertyNames.nextElement();
                String value = (String)customProperties.get(key);
                if (key != null) {
                    if (key.length() > MAX_PROPKEYLENGTH) {
                        throw new IOException("Custom property key " + key + " is too long. Max allowed length is " + MAX_PROPKEYLENGTH);
                    }
                    if (!StringUtils.isAsciiPrintable((CharSequence)key)) {
                        throw new IOException("Custom property key " + key + " is not simple ASCII!");
                    }
                }
                if (value == null) continue;
                if (value.length() > MAX_PROPVALUELENGTH) {
                    throw new IOException("Custom property key " + key + " has value that is too long. Value=" + value + ". Max allowed length is " + MAX_PROPVALUELENGTH);
                }
                if (StringUtils.isAsciiPrintable((CharSequence)value)) continue;
                throw new IOException("Custom property key " + key + " has value that is not simple ASCII! Value=" + value);
            }
        }
    }

    public static class WikiFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(AbstractFileProvider.FILE_EXT);
        }
    }
}

