/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Element;

public final class ClassUtil {
    private static final Logger LOG = LogManager.getLogger(ClassUtil.class);
    public static final String MAPPINGS = "ini/classmappings.xml";
    public static final String MAPPINGS_EXTRA = "ini/classmappings-extra.xml";
    private static final Map<String, String> c_classMappings = ClassUtil.populateClassMappingsFrom("ini/classmappings.xml");
    private static final Map<String, String> c_classMappingsExtra = ClassUtil.populateClassMappingsFrom("ini/classmappings-extra.xml");
    private static boolean classLoaderSetup;
    private static ClassLoader loader;

    private static Map<String, String> populateClassMappingsFrom(String fileLoc) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        List<Element> nodes = XmlUtil.parse(fileLoc, "/classmappings/mapping");
        if (!nodes.isEmpty()) {
            for (Element f : nodes) {
                String key = f.getChildText("requestedClass");
                String className = f.getChildText("mappedClass");
                map.put(key, className);
                LOG.debug("Mapped class '{}' to class '{}'", (Object)key, (Object)className);
            }
        } else {
            LOG.info("Didn't find class mapping document in {}", (Object)MAPPINGS);
        }
        return map;
    }

    private ClassUtil() {
    }

    public static <T> Class<T> findClass(List<String> packages, List<String> externaljars, String className) throws ClassNotFoundException {
        if (!classLoaderSetup) {
            loader = ClassUtil.setupClassLoader(externaljars);
        }
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            for (String packageName : packages) {
                try {
                    return loader.loadClass(packageName + "." + className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException("Class '" + className + "' not found in search path!");
        }
    }

    private static ClassLoader setupClassLoader(List<String> externaljars) {
        classLoaderSetup = true;
        LOG.info("setting up classloaders for external (plugin) jars");
        if (externaljars.size() == 0) {
            LOG.info("no external jars configured, using standard classloading");
            return ClassUtil.class.getClassLoader();
        }
        URL[] urls = new URL[externaljars.size()];
        int i = 0;
        for (String externaljar : externaljars) {
            try {
                File jarFile = new File(externaljar);
                URL ucl = jarFile.toURI().toURL();
                urls[i++] = ucl;
                LOG.info("added {} to list of external jars", (Object)ucl);
            }
            catch (MalformedURLException e) {
                LOG.error("exception ({}) while setting up classloaders for external jar: {}, continuing without external jars.", (Object)e.getMessage(), (Object)externaljar);
            }
        }
        if (i == 0) {
            LOG.error("all external jars threw an exception while setting up classloaders for them, continuing with standard classloading. See https://jspwiki-wiki.apache.org/Wiki.jsp?page=InstallingPlugins for help on how to install custom plugins.");
            return ClassUtil.class.getClassLoader();
        }
        return new URLClassLoader(urls, ClassUtil.class.getClassLoader());
    }

    public static <T> Class<T> findClass(String packageName, String className) throws ClassNotFoundException {
        try {
            return ClassUtil.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return ClassUtil.class.getClassLoader().loadClass(packageName + "." + className);
        }
    }

    public static List<String> classpathEntriesUnder(String rootPackage) {
        ArrayList<String> results = new ArrayList<String>();
        Enumeration<URL> en = null;
        if (StringUtils.isNotEmpty((CharSequence)rootPackage)) {
            try {
                en = ClassUtil.class.getClassLoader().getResources(rootPackage);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        while (en != null && en.hasMoreElements()) {
            URL url = en.nextElement();
            try {
                if ("jar".equals(url.getProtocol())) {
                    ClassUtil.jarEntriesUnder(results, (JarURLConnection)url.openConnection(), rootPackage);
                    continue;
                }
                if (!"file".equals(url.getProtocol())) continue;
                ClassUtil.fileEntriesUnder(results, new File(url.getFile()), rootPackage);
            }
            catch (IOException ioe) {
                LOG.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        return results;
    }

    static void fileEntriesUnder(List<String> results, File file, String rootPackage) {
        LOG.debug("scanning [{}]", (Object)file.getName());
        if (file.isDirectory()) {
            Iterator files = FileUtils.iterateFiles((File)file, null, (boolean)true);
            while (files.hasNext()) {
                File subfile = (File)files.next();
                String entry = StringUtils.replace((String)subfile.getAbsolutePath(), (String)(file.getAbsolutePath() + File.separatorChar), (String)"");
                results.add(rootPackage + "/" + entry);
            }
        } else {
            results.add(file.getName());
        }
    }

    static void jarEntriesUnder(List<String> results, JarURLConnection jurlcon, String rootPackage) {
        try (JarFile jar = jurlcon.getJarFile();){
            LOG.debug("scanning [{}]", (Object)jar.getName());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(rootPackage) || entry.isDirectory()) continue;
                results.add(entry.getName());
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public static <T> T getMappedObject(String requestedClass) throws ReflectiveOperationException, IllegalArgumentException {
        Object[] initargs = new Object[]{};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static <T> T getMappedObject(String requestedClass, Object ... initargs) throws ReflectiveOperationException, IllegalArgumentException {
        Class<?> cl = ClassUtil.getMappedClass(requestedClass);
        return (T)ClassUtil.buildInstance(cl, initargs);
    }

    public static Class<?> getMappedClass(String requestedClass) throws ClassNotFoundException {
        String mappedClass = c_classMappings.get(requestedClass);
        if (mappedClass == null) {
            mappedClass = requestedClass;
        }
        return Class.forName(mappedClass);
    }

    public static boolean assignable(String srcClassName, String parentClassName) {
        try {
            Class<?> src = Class.forName(srcClassName);
            Class<?> parent = Class.forName(parentClassName);
            return parent.isAssignableFrom(src);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean exists(String className) {
        try {
            Class.forName(className, false, ClassUtil.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, String> getExtraClassMappings() {
        return c_classMappingsExtra;
    }

    public static <T> T buildInstance(String className) throws ReflectiveOperationException {
        return ClassUtil.buildInstance("", className);
    }

    public static <T> T buildInstance(String packageName, String className) throws ReflectiveOperationException {
        return ClassUtil.buildInstance(ClassUtil.findClass(packageName, className));
    }

    public static <T> T buildInstance(Class<T> from) throws ReflectiveOperationException {
        Object[] initArgs = new Object[]{};
        return ClassUtil.buildInstance(from, initArgs);
    }

    public static <T> T buildInstance(Class<T> from, Object ... initArgs) throws ReflectiveOperationException {
        Constructor<?>[] ctors;
        for (Constructor<?> ctor : ctors = from.getConstructors()) {
            Class<?>[] params = ctor.getParameterTypes();
            if (params.length != initArgs.length) continue;
            for (int arg = 0; arg < initArgs.length; ++arg) {
                if (!params[arg].isAssignableFrom(initArgs[arg].getClass())) continue;
                return (T)ctor.newInstance(initArgs);
            }
        }
        return from.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

