/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search.kendra;

import com.amazonaws.services.kendra.AWSkendra;
import com.amazonaws.services.kendra.AWSkendraClientBuilder;
import com.amazonaws.services.kendra.model.BatchDeleteDocumentRequest;
import com.amazonaws.services.kendra.model.BatchDeleteDocumentResult;
import com.amazonaws.services.kendra.model.BatchPutDocumentRequest;
import com.amazonaws.services.kendra.model.BatchPutDocumentResponseFailedDocument;
import com.amazonaws.services.kendra.model.BatchPutDocumentResult;
import com.amazonaws.services.kendra.model.ContentType;
import com.amazonaws.services.kendra.model.DataSourceSummary;
import com.amazonaws.services.kendra.model.Document;
import com.amazonaws.services.kendra.model.DocumentAttribute;
import com.amazonaws.services.kendra.model.DocumentAttributeValue;
import com.amazonaws.services.kendra.model.IndexConfigurationSummary;
import com.amazonaws.services.kendra.model.ListDataSourcesRequest;
import com.amazonaws.services.kendra.model.ListDataSourcesResult;
import com.amazonaws.services.kendra.model.ListIndicesRequest;
import com.amazonaws.services.kendra.model.ListIndicesResult;
import com.amazonaws.services.kendra.model.QueryRequest;
import com.amazonaws.services.kendra.model.QueryResultItem;
import com.amazonaws.services.kendra.model.QueryResultType;
import com.amazonaws.services.kendra.model.ScoreConfidence;
import com.amazonaws.services.kendra.model.StartDataSourceSyncJobRequest;
import com.amazonaws.services.kendra.model.StartDataSourceSyncJobResult;
import com.amazonaws.services.kendra.model.StopDataSourceSyncJobRequest;
import com.amazonaws.services.kendra.model.ThrottlingException;
import com.amazonaws.util.IOUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WatchDog;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.util.TextUtil;

public class KendraSearchProvider
implements SearchProvider {
    private static final Logger LOG = LogManager.getLogger(KendraSearchProvider.class);
    private Engine engine;
    private Properties properties;
    private Map<String, Object> contentTypes;
    private AWSkendra kendra;
    private String indexName;
    private String indexId;
    private String dataSourceName;
    private String dataSourceId;
    private final List<Page> updates = Collections.synchronizedList(new ArrayList());
    private static final String PROP_KENDRA_INDEX_NAME = "jspwiki.kendra.indexName";
    private static final String PROP_KENDRA_DATA_SOURCE_NAME = "jspwiki.kendra.dataSourceName";
    private static final String PROP_KENDRA_INDEXDELAY = "jspwiki.kendra.indexdelay";
    private static final String PROP_KENDRA_INITIALDELAY = "jspwiki.kendra.initialdelay";

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        this.engine = engine;
        this.properties = properties;
        this.contentTypes = this.getContentTypes();
        this.setKendra(this.buildClient());
        this.indexName = TextUtil.getRequiredProperty((Properties)this.properties, (String)PROP_KENDRA_INDEX_NAME);
        this.dataSourceName = TextUtil.getRequiredProperty((Properties)this.properties, (String)PROP_KENDRA_DATA_SOURCE_NAME);
        int initialDelay = TextUtil.getIntegerProperty((Properties)this.properties, (String)PROP_KENDRA_INITIALDELAY, (int)10);
        int indexDelay = TextUtil.getIntegerProperty((Properties)this.properties, (String)PROP_KENDRA_INDEXDELAY, (int)5);
        if (initialDelay >= 0) {
            KendraUpdater updater = new KendraUpdater(engine, this, initialDelay, indexDelay);
            updater.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getContentTypes() {
        Gson gson = new GsonBuilder().create();
        try (InputStream in = KendraSearchProvider.class.getResourceAsStream("content_types.json");){
            if (in == null) return null;
            Type collectionType = new TypeToken<HashMap<String, Object>>(){}.getType();
            Map map = (Map)gson.fromJson((Reader)new InputStreamReader(in), collectionType);
            return map;
        }
        catch (IOException e) {
            LOG.error(String.format("Unable to load default propertyfile 'content_types.json': %s", e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public String getProviderInfo() {
        return "KendraSearchProvider";
    }

    public void pageRemoved(Page page) {
        String pageName = page.getName();
        BatchDeleteDocumentRequest request = new BatchDeleteDocumentRequest().withIndexId(this.indexId).withDocumentIdList(new String[]{pageName});
        BatchDeleteDocumentResult result = this.getKendra().batchDeleteDocument(request);
        if (result.getFailedDocuments().size() == 0) {
            LOG.debug(String.format("Page '%s' was removed from index", pageName));
        } else {
            LOG.error(String.format("Failed to remove Page '%s' from index", pageName));
        }
    }

    public void reindexPage(Page page) {
        if (page != null) {
            this.updates.add(page);
            LOG.debug(String.format("Scheduling page '%s' for indexing ...", page.getName()));
        }
    }

    public Collection<SearchResult> findPages(String query, Context wikiContext) throws ProviderException, IOException {
        List items;
        QueryRequest request = new QueryRequest().withIndexId(this.indexId).withQueryText(query);
        try {
            items = this.getKendra().query(request).getResultItems();
        }
        catch (ThrottlingException e) {
            LOG.error("ThrottlingException. Skipping...");
            return new ArrayList<SearchResult>();
        }
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>(items.size());
        AuthorizationManager mgr = (AuthorizationManager)this.engine.getManager(AuthorizationManager.class);
        for (QueryResultItem item : items) {
            switch (QueryResultType.fromValue((String)item.getType())) {
                case DOCUMENT: {
                    String documentId = item.getDocumentId();
                    String documentExcerpt = item.getDocumentExcerpt().getText();
                    String scoreConfidence = item.getScoreAttributes().getScoreConfidence();
                    Page page = ((PageManager)this.engine.getManager(PageManager.class)).getPage(documentId, -1);
                    if (page != null) {
                        PagePermission pp = new PagePermission(page, "view");
                        if (mgr.checkPermission(wikiContext.getWikiSession(), (Permission)pp)) {
                            SearchResultImpl searchResult = new SearchResultImpl(page, this.confidence2score(scoreConfidence), new String[]{documentExcerpt});
                            searchResults.add(searchResult);
                            break;
                        }
                        LOG.error(String.format("Page '%s' is not accessible", documentId));
                        break;
                    }
                    LOG.error(String.format("Kendra found a result page '%s' that could not be loaded, removing from index", documentId));
                    this.pageRemoved(Wiki.contents().page(this.engine, documentId));
                    break;
                }
                default: {
                    LOG.error(String.format("Unknown query result type: %s", item.getType()));
                }
            }
        }
        return searchResults;
    }

    public void initializeIndexAndDataSource() {
        this.indexId = this.getIndexId(this.indexName);
        if (this.indexId == null) {
            String message = String.format("Index '%s' does not exist", this.indexName);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.dataSourceId = this.getDatasourceId(this.indexId, this.dataSourceName);
        if (this.dataSourceId == null) {
            String message = String.format("Datasource '%s' does not exist in index %s", this.dataSourceName, this.indexName);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    private String getIndexId(String indexName) {
        ListIndicesRequest request = new ListIndicesRequest();
        ListIndicesResult result = this.getKendra().listIndices(request);
        String nextToken = "";
        while (nextToken != null) {
            List items = result.getIndexConfigurationSummaryItems();
            if (items == null || items.isEmpty()) {
                return null;
            }
            for (IndexConfigurationSummary item : items) {
                if (!StringUtils.equals((CharSequence)item.getName(), (CharSequence)indexName)) continue;
                return item.getId();
            }
            nextToken = result.getNextToken();
            request = new ListIndicesRequest().withNextToken(result.getNextToken());
            result = this.getKendra().listIndices(request);
        }
        return null;
    }

    private String getDatasourceId(String indexId, String dataSourceName) {
        ListDataSourcesRequest request = new ListDataSourcesRequest().withIndexId(indexId);
        ListDataSourcesResult result = this.getKendra().listDataSources(request);
        String nextToken = "";
        while (nextToken != null) {
            List items = result.getSummaryItems();
            if (items == null || items.isEmpty()) {
                return null;
            }
            for (DataSourceSummary item : items) {
                if (!StringUtils.equals((CharSequence)item.getName(), (CharSequence)dataSourceName)) continue;
                return item.getId();
            }
            nextToken = result.getNextToken();
            request = new ListDataSourcesRequest().withNextToken(result.getNextToken());
            result = this.getKendra().listDataSources(request);
        }
        return null;
    }

    private int confidence2score(String scoreConfidence) {
        switch (ScoreConfidence.fromValue((String)scoreConfidence)) {
            case VERY_HIGH: {
                return 100;
            }
            case HIGH: {
                return 75;
            }
            case MEDIUM: {
                return 50;
            }
            case LOW: {
                return 25;
            }
        }
        return 0;
    }

    private void doFullReindex() throws IOException {
        try {
            Collection pages = ((PageManager)this.engine.getManager(PageManager.class)).getAllPages();
            if (pages.isEmpty()) {
                return;
            }
            LOG.debug(String.format("Indexing all %d pages. Please wait ...", pages.size()));
            String executionId = this.startExecution();
            for (Page page : pages) {
                this.indexOnePage(page, executionId);
            }
        }
        catch (ProviderException e) {
            LOG.error(e.getMessage());
            throw new IOException(e);
        }
        finally {
            this.stopExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPartialReindex() {
        if (this.updates.isEmpty()) {
            return;
        }
        LOG.debug("Indexing updated pages. Please wait ...");
        String executionId = this.startExecution();
        List<Page> list = this.updates;
        synchronized (list) {
            try {
                while (this.updates.size() > 0) {
                    this.indexOnePage(this.updates.remove(0), executionId);
                }
            }
            finally {
                this.stopExecution();
            }
        }
    }

    private String startExecution() {
        StartDataSourceSyncJobRequest request = new StartDataSourceSyncJobRequest().withIndexId(this.indexId).withId(this.dataSourceId);
        StartDataSourceSyncJobResult result = this.getKendra().startDataSourceSyncJob(request);
        return result.getExecutionId();
    }

    private void stopExecution() {
        StopDataSourceSyncJobRequest request = new StopDataSourceSyncJobRequest().withIndexId(this.indexId).withId(this.dataSourceId);
        this.getKendra().stopDataSourceSyncJob(request);
    }

    private void indexOnePage(Page page, String executionId) {
        String pageName = page.getName();
        try {
            Document document = this.newDocument(page, executionId);
            BatchPutDocumentRequest request = new BatchPutDocumentRequest().withIndexId(this.indexId).withDocuments(new Document[]{document});
            BatchPutDocumentResult result = this.getKendra().batchPutDocument(request);
            if (result.getFailedDocuments().size() == 0) {
                LOG.info(String.format("Successfully indexed Page '%s' as %s", page.getName(), document.getContentType()));
            } else {
                for (BatchPutDocumentResponseFailedDocument failedDocument : result.getFailedDocuments()) {
                    LOG.error(String.format("Failed to index Page '%s': %s", failedDocument.getId(), failedDocument.getErrorMessage()));
                }
            }
        }
        catch (IOException e) {
            LOG.error(String.format("Failed to index Page '%s': %s", pageName, e.getMessage()));
        }
    }

    private Document newDocument(Page page, String executionId) throws IOException {
        ByteBuffer blob;
        ContentType contentType;
        String title;
        ArrayList<DocumentAttribute> attrs;
        String pageName;
        block5: {
            block4: {
                pageName = page.getName();
                attrs = new ArrayList<DocumentAttribute>();
                attrs.add(this.newAttribute("_data_source_id", this.dataSourceId));
                attrs.add(this.newAttribute("_data_source_sync_job_execution_id", executionId));
                title = TextUtil.beautifyString((String)pageName);
                contentType = ContentType.PLAIN_TEXT;
                if (!(page instanceof Attachment)) break block4;
                Attachment attachment = (Attachment)page;
                InputStream is = null;
                try {
                    String filename = attachment.getFileName();
                    contentType = this.getContentType(filename);
                    is = ((AttachmentManager)this.engine.getManager(AttachmentManager.class)).getAttachmentStream(attachment);
                    blob = ByteBuffer.wrap(IOUtils.toByteArray((InputStream)is));
                }
                catch (ProviderException e) {
                    try {
                        throw new IOException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is, null);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)is, null);
                break block5;
            }
            String text = ((PageManager)this.engine.getManager(PageManager.class)).getPureText(page);
            blob = ByteBuffer.wrap(text.getBytes(StandardCharsets.UTF_8));
        }
        return new Document().withId(pageName).withTitle(title).withAttributes(attrs).withBlob(blob).withContentType(contentType);
    }

    private DocumentAttribute newAttribute(String key, String value) {
        return new DocumentAttribute().withKey(key).withValue(new DocumentAttributeValue().withStringValue(value));
    }

    private ContentType getContentType(String filename) {
        String extention = FilenameUtils.getExtension((String)filename);
        Map ct = (Map)this.contentTypes.get("ContentTypes");
        return ContentType.fromValue((String)ct.getOrDefault(extention, ContentType.PLAIN_TEXT.name()));
    }

    public AWSkendra getKendra() {
        return this.kendra;
    }

    public void setKendra(AWSkendra kendra) {
        this.kendra = kendra;
    }

    protected AWSkendra buildClient() {
        return AWSkendraClientBuilder.defaultClient();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    private static final class KendraUpdater
    extends WikiBackgroundThread {
        static final int INDEX_DELAY = 5;
        static final int INITIAL_DELAY = 10;
        private final KendraSearchProvider provider;
        private final int initialDelay;
        private WatchDog watchdog;

        private KendraUpdater(Engine engine, KendraSearchProvider provider, int initialDelay, int indexDelay) {
            super(engine, indexDelay);
            this.provider = provider;
            this.initialDelay = initialDelay;
            this.setName("JSPWiki Kendra Indexer");
        }

        public void startupTask() throws Exception {
            this.watchdog = WatchDog.getCurrentWatchDog((Engine)this.getEngine());
            try {
                Thread.sleep((long)this.initialDelay * 1000L);
            }
            catch (InterruptedException e) {
                throw new InternalWikiException("Interrupted while waiting to start.", (Throwable)e);
            }
            this.watchdog.enterState("Full reindex");
            this.provider.initializeIndexAndDataSource();
            this.provider.doFullReindex();
            this.watchdog.exitState();
        }

        public void backgroundTask() {
            this.watchdog.enterState("Reindexing ...", 60);
            this.provider.doPartialReindex();
            this.watchdog.exitState();
        }
    }

    private static class SearchResultImpl
    implements SearchResult {
        private final Page page;
        private final int score;
        private final String[] contexts;

        public SearchResultImpl(Page page, int score, String[] contexts) {
            this.page = page;
            this.score = score;
            this.contexts = contexts != null ? (String[])contexts.clone() : null;
        }

        public Page getPage() {
            return this.page;
        }

        public int getScore() {
            return this.score;
        }

        public String[] getContexts() {
            return this.contexts;
        }
    }
}

