/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages.haddock;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import java.time.Duration;
import org.apache.wiki.pages.Page;
import org.apache.wiki.pages.haddock.HaddockPage;
import org.apache.wiki.pages.haddock.ViewWikiPage;
import org.openqa.selenium.By;

public class EditWikiPage
implements HaddockPage {
    private static final String EDIT_TEXTAREA = "textarea.editor.form-control.snipeable";

    public static EditWikiPage open(String pageName) {
        return Page.withUrl(Page.baseUrl() + "/Edit.jsp?page=" + pageName).openAs(new EditWikiPage());
    }

    public ViewWikiPage cancel() {
        Selenide.$((By)By.name((String)"cancel")).click();
        return new ViewWikiPage();
    }

    public ViewWikiPage saveText(String text) {
        return this.saveText(text, text);
    }

    public ViewWikiPage saveText(String text, String preview) {
        Selenide.$((By)By.cssSelector((String)EDIT_TEXTAREA)).clear();
        Selenide.$((By)By.cssSelector((String)EDIT_TEXTAREA)).val((CharSequence)text);
        Selenide.$((By)By.className((String)"ajaxpreview")).shouldBe(Condition.text((String)preview), Duration.ofSeconds(1L));
        Selenide.$((By)By.name((String)"ok")).click();
        return new ViewWikiPage();
    }
}

