/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import java.util.List;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.ImageLinkNodePostProcessorState;
import org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor.NodePostProcessorState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.parser.MarkupParser;

public class LocalLinkNodePostProcessorState
implements NodePostProcessorState<JSPWikiLink> {
    private final Context wikiContext;
    private final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;

    public LocalLinkNodePostProcessorState(Context wikiContext, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
    }

    @Override
    public void process(NodeTracker state, JSPWikiLink link) {
        int hashMark = link.getUrl().toString().indexOf(35);
        String attachment = ((AttachmentManager)this.wikiContext.getEngine().getManager(AttachmentManager.class)).getAttachmentInfoName(this.wikiContext, link.getUrl().toString());
        if (attachment != null) {
            if (!this.linkOperations.isImageLink(link.getUrl().toString(), this.isImageInlining, this.inlineImagePatterns)) {
                String attlink = this.wikiContext.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), link.getUrl().toString());
                link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)attlink));
                link.removeChildren();
                HtmlInline content = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)link.getText().toString()));
                link.appendChild((Node)content);
                state.nodeAddedWithChildren((Node)content);
                this.addAttachmentLink(state, link);
            } else {
                new ImageLinkNodePostProcessorState(this.wikiContext, attachment, link.hasRef()).process(state, link);
            }
        } else if (hashMark != -1) {
            String namedSection = link.getUrl().toString().substring(hashMark + 1);
            link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)link.getUrl().toString().substring(0, hashMark)));
            String matchedLink = this.linkOperations.linkIfExists(link.getUrl().toString());
            if (matchedLink != null) {
                String sectref = "#section-" + this.wikiContext.getEngine().encodeName(matchedLink + "-" + MarkupParser.wikifyLink((String)namedSection));
                sectref = sectref.replace('%', '_');
                link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)this.wikiContext.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), link.getUrl().toString() + sectref)));
            } else {
                link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)this.wikiContext.getURL(ContextEnum.PAGE_EDIT.getRequestContext(), link.getUrl().toString())));
            }
        } else if (this.linkOperations.linkExists(link.getUrl().toString())) {
            link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)this.wikiContext.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), link.getUrl().toString())));
        } else {
            link.setUrl((BasedSequence)CharSubSequence.of((CharSequence)this.wikiContext.getURL(ContextEnum.PAGE_EDIT.getRequestContext(), link.getUrl().toString())));
        }
    }

    void addAttachmentLink(NodeTracker state, JSPWikiLink link) {
        String infolink = this.wikiContext.getURL(ContextEnum.PAGE_INFO.getRequestContext(), link.getWikiLink());
        String imglink = this.wikiContext.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "images/attachment_small.png");
        HtmlInline aimg = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)("<a href=\"" + infolink + "\" class=\"infolink\"><img src=\"" + imglink + "\" border=\"0\" alt=\"(info)\" /></a>")));
        link.insertAfter((Node)aimg);
        state.nodeAdded((Node)aimg);
    }
}

