/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.url;

import java.nio.charset.Charset;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.url.DefaultURLConstructor;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.TextUtil;

public class ShortURLConstructor
extends DefaultURLConstructor {
    private static final String DEFAULT_PREFIX = "wiki/";
    private static final Logger LOG = LogManager.getLogger(ShortURLConstructor.class);
    protected String m_urlPrefix = "";
    public static final String PROP_PREFIX = "jspwiki.shortURLConstructor.prefix";

    @Override
    public void initialize(Engine engine, Properties properties) {
        super.initialize(engine, properties);
        this.m_urlPrefix = TextUtil.getStringProperty((Properties)properties, (String)PROP_PREFIX, null);
        if (this.m_urlPrefix == null) {
            this.m_urlPrefix = DEFAULT_PREFIX;
        }
        LOG.info("Short URL prefix path=" + this.m_urlPrefix + " (You can use " + PROP_PREFIX + " to override this)");
    }

    private String makeURL(String context, String name) {
        String viewurl = "%p" + this.m_urlPrefix + "%n";
        if (context.equals(ContextEnum.PAGE_VIEW.getRequestContext())) {
            if (name == null) {
                return this.doReplacement("%u", "");
            }
            return this.doReplacement(viewurl, name);
        }
        if (context.equals(ContextEnum.PAGE_PREVIEW.getRequestContext())) {
            if (name == null) {
                return this.doReplacement("%u", "");
            }
            return this.doReplacement(viewurl + "?do=Preview", name);
        }
        if (context.equals(ContextEnum.PAGE_EDIT.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=Edit", name);
        }
        if (context.equals(ContextEnum.PAGE_ATTACH.getRequestContext())) {
            return this.doReplacement("%uattach/%n", name);
        }
        if (context.equals(ContextEnum.PAGE_INFO.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=PageInfo", name);
        }
        if (context.equals(ContextEnum.PAGE_DIFF.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=Diff", name);
        }
        if (context.equals(ContextEnum.PAGE_NONE.getRequestContext())) {
            return this.doReplacement("%u%n", name);
        }
        if (context.equals(ContextEnum.PAGE_UPLOAD.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=Upload", name);
        }
        if (context.equals(ContextEnum.PAGE_COMMENT.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=Comment", name);
        }
        if (context.equals(ContextEnum.WIKI_LOGIN.getRequestContext())) {
            String loginUrl = "%pLogin.jsp?redirect=%n";
            return this.doReplacement("%pLogin.jsp?redirect=%n", name);
        }
        if (context.equals(ContextEnum.PAGE_DELETE.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=Delete", name);
        }
        if (context.equals(ContextEnum.PAGE_CONFLICT.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=PageModified", name);
        }
        if (context.equals(ContextEnum.WIKI_PREFS.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=UserPreferences", name);
        }
        if (context.equals(ContextEnum.WIKI_FIND.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=Search", name);
        }
        if (context.equals(ContextEnum.WIKI_ERROR.getRequestContext())) {
            return this.doReplacement("%uError.jsp", name);
        }
        if (context.equals(ContextEnum.WIKI_CREATE_GROUP.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=NewGroup", name);
        }
        if (context.equals(ContextEnum.GROUP_DELETE.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=DeleteGroup", name);
        }
        if (context.equals(ContextEnum.GROUP_EDIT.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=EditGroup", name);
        }
        if (context.equals(ContextEnum.GROUP_VIEW.getRequestContext())) {
            return this.doReplacement(viewurl + "?do=Group&group=%n", name);
        }
        throw new InternalWikiException("Requested unsupported context " + context);
    }

    @Override
    public String makeURL(String context, String name, String parameters) {
        parameters = parameters != null && !parameters.isEmpty() ? (context.equals(ContextEnum.PAGE_ATTACH.getRequestContext()) || context.equals(ContextEnum.PAGE_VIEW.getRequestContext()) ? "?" + parameters : (context.equals(ContextEnum.PAGE_NONE.getRequestContext()) ? (name.indexOf(63) != -1 ? "&amp;" : "?" + parameters) : "&amp;" + parameters)) : "";
        return this.makeURL(context, name) + parameters;
    }

    @Override
    public String parsePage(String context, HttpServletRequest request, Charset encoding) {
        String pagereq = request.getParameter("page");
        if (pagereq == null) {
            return URLConstructor.parsePageFromURL(request, encoding);
        }
        return pagereq;
    }

    @Override
    public String getForwardPage(HttpServletRequest req) {
        String jspPage = req.getParameter("do");
        if (jspPage == null) {
            jspPage = "Wiki";
        }
        return jspPage + ".jsp";
    }
}

