/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.ClassUtil;

public interface TemplateManager
extends ModuleManager {
    public static final String SKIN_DIRECTORY = "skins";
    public static final String RESOURCE_JSFUNCTION = "jsfunction";
    public static final String RESOURCE_JSLOCALIZEDSTRINGS = "jslocalizedstrings";
    public static final String RESOURCE_STYLESHEET = "stylesheet";
    public static final String RESOURCE_SCRIPT = "script";
    public static final String RESOURCE_INLINECSS = "inlinecss";
    public static final String DIRECTORY = "templates";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String PROPERTYFILE = "template.properties";
    public static final String I18NRESOURCE_PREFIX = "templates/default_";
    public static final String I18NRESOURCE_SUFFIX = ".properties";
    public static final String I18NRESOURCE_EN = "templates/default.properties";
    public static final String I18NRESOURCE_EN_ID = "en";
    public static final String I18NDEFAULT_LOCALE = "prefs.user.language.default";
    public static final String I18NSERVER_TIMEZONE = "prefs.user.timezone.server";
    public static final String TIMEFORMATPROPERTIES = "jspwiki.defaultprefs.timeformat.";
    public static final String RESOURCE_INCLUDES = "jspwiki.resourceincludes";
    public static final String RESOURCE_HTTPHEADER = "httpheader";

    public boolean templateExists(String var1);

    public String findJSP(PageContext var1, String var2);

    public String findJSP(PageContext var1, String var2, String var3);

    public String findResource(Context var1, String var2, String var3);

    public Set<String> listSkins(PageContext var1, String var2);

    default public Map<String, String> listLanguages(PageContext pageContext) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        String clientLanguage = pageContext.getRequest().getLocale().toString();
        List entries = ClassUtil.classpathEntriesUnder((String)DIRECTORY);
        for (String name : entries) {
            if (!name.equals(I18NRESOURCE_EN) && (!name.startsWith(I18NRESOURCE_PREFIX) || !name.endsWith(I18NRESOURCE_SUFFIX))) continue;
            name = name.equals(I18NRESOURCE_EN) ? I18NRESOURCE_EN_ID : name.substring(I18NRESOURCE_PREFIX.length(), name.lastIndexOf(I18NRESOURCE_SUFFIX));
            Locale locale = new Locale(name.substring(0, 2), !name.contains("_") ? "" : name.substring(3, 5));
            String defaultLanguage = "";
            if (clientLanguage.startsWith(name)) {
                defaultLanguage = LocaleSupport.getLocalizedMessage((PageContext)pageContext, (String)I18NDEFAULT_LOCALE);
            }
            resultMap.put(name, locale.getDisplayName(locale) + " " + defaultLanguage);
        }
        return resultMap;
    }

    public Map<String, String> listTimeFormats(PageContext var1);

    default public Map<String, String> listTimeZones(PageContext pageContext) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        String[][] tzs = new String[][]{{"GMT-12", "Enitwetok, Kwajalien"}, {"GMT-11", "Nome, Midway Island, Samoa"}, {"GMT-10", "Hawaii"}, {"GMT-9", "Alaska"}, {"GMT-8", "Pacific Time"}, {"GMT-7", "Mountain Time"}, {"GMT-6", "Central Time, Mexico City"}, {"GMT-5", "Eastern Time, Bogota, Lima, Quito"}, {"GMT-4", "Atlantic Time, Caracas, La Paz"}, {"GMT-3:30", "Newfoundland"}, {"GMT-3", "Brazil, Buenos Aires, Georgetown, Falkland Is."}, {"GMT-2", "Mid-Atlantic, Ascention Is., St Helena"}, {"GMT-1", "Azores, Cape Verde Islands"}, {"GMT", "Casablanca, Dublin, Edinburgh, London, Lisbon, Monrovia"}, {"GMT+1", "Berlin, Brussels, Copenhagen, Madrid, Paris, Rome"}, {"GMT+2", "Helsinki, Athens, Kaliningrad, South Africa, Warsaw"}, {"GMT+3", "Baghdad, Riyadh, Moscow, Nairobi"}, {"GMT+3:30", "Tehran"}, {"GMT+4", "Adu Dhabi, Baku, Muscat, Tbilisi"}, {"GMT+4:30", "Kabul"}, {"GMT+5", "Islamabad, Karachi, Tashkent"}, {"GMT+5:30", "Bombay, Calcutta, Madras, New Delhi"}, {"GMT+6", "Almaty, Colomba, Dhakra"}, {"GMT+7", "Bangkok, Hanoi, Jakarta"}, {"GMT+8", "Beijing, Hong Kong, Perth, Singapore, Taipei"}, {"GMT+9", "Osaka, Sapporo, Seoul, Tokyo, Yakutsk"}, {"GMT+9:30", "Adelaide, Darwin"}, {"GMT+10", "Melbourne, Papua New Guinea, Sydney, Vladivostok"}, {"GMT+11", "Magadan, New Caledonia, Solomon Islands"}, {"GMT+12", "Auckland, Wellington, Fiji, Marshall Island"}};
        TimeZone servertz = TimeZone.getDefault();
        for (String[] strings : tzs) {
            String tzID = strings[0];
            TimeZone tz = TimeZone.getTimeZone(tzID);
            String serverTimeZone = "";
            if (servertz.getRawOffset() == tz.getRawOffset()) {
                serverTimeZone = LocaleSupport.getLocalizedMessage((PageContext)pageContext, (String)I18NSERVER_TIMEZONE);
                tzID = servertz.getID();
            }
            resultMap.put(tzID, "(" + strings[0] + ") " + strings[1] + " " + serverTimeZone);
        }
        return resultMap;
    }

    public static String getMarker(Context context, String type) {
        if (type.equals(RESOURCE_JSLOCALIZEDSTRINGS)) {
            return TemplateManager.getJSLocalizedStrings(context);
        }
        if (type.equals(RESOURCE_JSFUNCTION)) {
            return "/* INCLUDERESOURCES (" + type + ") */";
        }
        return "<!-- INCLUDERESOURCES (" + type + ") -->";
    }

    public static String getJSLocalizedStrings(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("var LocalizedStrings = {\n");
        ResourceBundle rb = Preferences.getBundle(context, "templates.default");
        boolean first = true;
        Enumeration<String> en = rb.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!key.startsWith("javascript")) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",\n");
            }
            sb.append("\"").append(key).append("\":\"").append(rb.getString(key)).append("\"");
        }
        sb.append("\n};\n");
        return sb.toString();
    }

    public static void addResourceRequest(Context ctx, String type, String resource) {
        String val;
        Vector<String> resources;
        HashMap resourcemap = (HashMap)ctx.getVariable(RESOURCE_INCLUDES);
        if (resourcemap == null) {
            resourcemap = new HashMap();
        }
        if ((resources = (Vector<String>)resourcemap.get(type)) == null) {
            resources = new Vector<String>();
        }
        String resolvedResource = resource;
        if (StringUtils.startsWith((CharSequence)resource, (CharSequence)"engine://") && StringUtils.isNotBlank((CharSequence)(val = ctx.getEngine().getWikiProperties().getProperty(resource.substring(9))))) {
            resolvedResource = val;
        }
        String resourceString = null;
        switch (type) {
            case "script": {
                resourceString = "<script type='text/javascript' src='" + resolvedResource + "'></script>";
                break;
            }
            case "stylesheet": {
                resourceString = "<link rel='stylesheet' type='text/css' href='" + resolvedResource + "' />";
                break;
            }
            case "inlinecss": {
                resourceString = "<style type='text/css'>\n" + resolvedResource + "\n</style>\n";
                break;
            }
            case "jsfunction": 
            case "httpheader": {
                resourceString = resolvedResource;
            }
        }
        if (resourceString != null) {
            resources.add(resourceString);
        }
        LogManager.getLogger(TemplateManager.class).debug("Request to add a resource: {}", (Object)resourceString);
        resourcemap.put(type, resources);
        ctx.setVariable(RESOURCE_INCLUDES, resourcemap);
    }

    public static String[] getResourceRequests(Context ctx, String type) {
        HashMap hm = (HashMap)ctx.getVariable(RESOURCE_INCLUDES);
        if (hm == null) {
            return new String[0];
        }
        Vector resources = (Vector)hm.get(type);
        if (resources == null) {
            return new String[0];
        }
        String[] res = new String[resources.size()];
        return resources.toArray(res);
    }

    public static String[] getResourceTypes(Context ctx) {
        HashMap hm;
        String[] res = new String[]{};
        if (ctx != null && (hm = (HashMap)ctx.getVariable(RESOURCE_INCLUDES)) != null) {
            Set keys = hm.keySet();
            res = keys.toArray(res);
        }
        return res;
    }
}

