/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class Search
implements Plugin {
    private static final Logger LOG = LogManager.getLogger(Search.class);
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SET = "set";
    public static final String DEFAULT_SETNAME = "_defaultSet";
    public static final String PARAM_MAX = "max";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        Collection<SearchResult> results;
        int maxItems = Integer.MAX_VALUE;
        String queryString = params.get(PARAM_QUERY);
        String set = params.get(PARAM_SET);
        String max = params.get(PARAM_MAX);
        if (set == null) {
            set = DEFAULT_SETNAME;
        }
        if (max != null) {
            maxItems = Integer.parseInt(max);
        }
        if (queryString == null) {
            results = (Collection<SearchResult>)context.getVariable(set);
        } else {
            try {
                results = this.doBasicQuery(context, queryString);
                context.setVariable(set, results);
            }
            catch (Exception e) {
                return "<div class='error'>" + e.getMessage() + "</div>\n";
            }
        }
        String res = "";
        if (results != null) {
            res = this.renderResults(results, context, maxItems);
        }
        return res;
    }

    private Collection<SearchResult> doBasicQuery(Context context, String query) throws ProviderException, IOException {
        LOG.debug("Searching for string " + query);
        return ((SearchManager)context.getEngine().getManager(SearchManager.class)).findPages(query, context);
    }

    private String renderResults(Collection<SearchResult> results, Context context, int maxItems) {
        Engine engine = context.getEngine();
        Element table = XhtmlUtil.element((XHTML)XHTML.table);
        table.setAttribute("class", "wikitable search-result");
        Element row = XhtmlUtil.element((XHTML)XHTML.tr);
        table.addContent((Content)row);
        Element th1 = XhtmlUtil.element((XHTML)XHTML.th, (String)"Page");
        th1.setAttribute("width", "30%");
        th1.setAttribute("align", "left");
        row.addContent((Content)th1);
        Element th2 = XhtmlUtil.element((XHTML)XHTML.th, (String)"Score");
        th2.setAttribute("align", "left");
        row.addContent((Content)th2);
        int idx = 0;
        Iterator<SearchResult> i = results.iterator();
        while (i.hasNext() && idx++ <= maxItems) {
            SearchResult sr = i.next();
            row = XhtmlUtil.element((XHTML)XHTML.tr);
            Element name = XhtmlUtil.element((XHTML)XHTML.td);
            name.setAttribute("width", "30%");
            name.addContent((Content)XhtmlUtil.link((String)context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), sr.getPage().getName()), (String)((RenderingManager)engine.getManager(RenderingManager.class)).beautifyTitle(sr.getPage().getName())));
            row.addContent((Content)name);
            row.addContent((Content)XhtmlUtil.element((XHTML)XHTML.td, (String)("" + sr.getScore())));
            table.addContent((Content)row);
        }
        if (results.isEmpty()) {
            row = XhtmlUtil.element((XHTML)XHTML.tr);
            Element td = XhtmlUtil.element((XHTML)XHTML.td);
            td.setAttribute("colspan", "2");
            Element b = XhtmlUtil.element((XHTML)XHTML.b, (String)"No results");
            td.addContent((Content)b);
            row.addContent((Content)td);
            table.addContent((Content)row);
        }
        return XhtmlUtil.serialize((Element)table);
    }
}

