/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class InsertPage
implements Plugin {
    public static final String PARAM_PAGENAME = "page";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_MAXLENGTH = "maxlength";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_SHOW = "show";
    public static final String PARAM_SECTION = "section";
    public static final String PARAM_DEFAULT = "default";
    private static final String DEFAULT_STYLE = "";
    private static final String ONCE_COOKIE = "JSPWiki.Once.";
    public static final String ATTR_RECURSE = "org.apache.wiki.plugin.InsertPage.recurseCheck";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        Engine engine = context.getEngine();
        StringBuilder res = new StringBuilder();
        String clazz = params.get(PARAM_CLASS);
        String includedPage = params.get(PARAM_PAGENAME);
        String style = params.get(PARAM_STYLE);
        boolean showOnce = "once".equals(params.get(PARAM_SHOW));
        String defaultstr = params.get(PARAM_DEFAULT);
        int section = TextUtil.parseIntParameter((String)params.get(PARAM_SECTION), (int)-1);
        int maxlen = TextUtil.parseIntParameter((String)params.get(PARAM_MAXLENGTH), (int)-1);
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        if (style == null) {
            style = DEFAULT_STYLE;
        }
        if (maxlen == -1) {
            maxlen = Integer.MAX_VALUE;
        }
        if (includedPage != null) {
            Page page;
            try {
                String pageName = engine.getFinalPageName(includedPage);
                page = pageName != null ? ((PageManager)engine.getManager(PageManager.class)).getPage(pageName) : ((PageManager)engine.getManager(PageManager.class)).getPage(includedPage);
            }
            catch (ProviderException e) {
                res.append("<span class=\"error\">Page could not be found by the page provider.</span>");
                return res.toString();
            }
            if (page != null) {
                AuthorizationManager mgr;
                ArrayList<String> previousIncludes = (ArrayList<String>)context.getVariable(ATTR_RECURSE);
                if (previousIncludes != null) {
                    if (previousIncludes.contains(page.getName())) {
                        return "<span class=\"error\">Error: Circular reference - you can't include a page in itself!</span>";
                    }
                } else {
                    previousIncludes = new ArrayList<String>();
                }
                if (!(mgr = (AuthorizationManager)engine.getManager(AuthorizationManager.class)).checkPermission(context.getWikiSession(), PermissionFactory.getPagePermission(page, "view"))) {
                    res.append("<span class=\"error\">You do not have permission to view this included page.</span>");
                    return res.toString();
                }
                String cookieName = DEFAULT_STYLE;
                if (showOnce) {
                    cookieName = ONCE_COOKIE + TextUtil.urlEncodeUTF8((String)page.getName()).replaceAll("\\+", "%20");
                    if (HttpUtil.retrieveCookieValue((HttpServletRequest)context.getHttpRequest(), (String)cookieName) != null) {
                        return DEFAULT_STYLE;
                    }
                }
                previousIncludes.add(page.getName());
                context.setVariable(ATTR_RECURSE, previousIncludes);
                Context includedContext = context.clone();
                includedContext.setPage(page);
                String pageData = ((PageManager)engine.getManager(PageManager.class)).getPureText(page);
                String moreLink = DEFAULT_STYLE;
                if (section != -1) {
                    try {
                        pageData = TextUtil.getSection((String)pageData, (int)section);
                    }
                    catch (IllegalArgumentException e) {
                        throw new PluginException(e.getMessage());
                    }
                }
                if (pageData.length() > maxlen) {
                    pageData = pageData.substring(0, maxlen) + " ...";
                    moreLink = "<p><a href=\"" + context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), includedPage) + "\">" + rb.getString("insertpage.more") + "</a></p>";
                }
                res.append("<div class=\"inserted-page ");
                if (clazz != null) {
                    res.append(clazz);
                }
                if (!style.equals(DEFAULT_STYLE)) {
                    res.append("\" style=\"").append(style);
                }
                if (showOnce) {
                    res.append("\" data-once=\"").append(cookieName);
                }
                res.append("\" >");
                res.append(((RenderingManager)engine.getManager(RenderingManager.class)).textToHTML(includedContext, pageData));
                res.append(moreLink);
                res.append("</div>");
                previousIncludes.remove(page.getName());
                context.setVariable(ATTR_RECURSE, previousIncludes);
            } else if (defaultstr != null) {
                res.append(defaultstr);
            } else {
                res.append("There is no page called '").append(includedPage).append("'.  Would you like to ");
                res.append("<a href=\"").append(context.getURL(ContextEnum.PAGE_EDIT.getRequestContext(), includedPage)).append("\">create it?</a>");
            }
        } else {
            res.append("<span class=\"error\">");
            res.append("You have to define a page!");
            res.append("</span>");
        }
        return res.toString();
    }
}

