/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.plugin.AbstractReferralPlugin;
import org.apache.wiki.references.ReferenceManager;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class IndexPlugin
extends AbstractReferralPlugin
implements Plugin {
    private static final Logger LOG = LogManager.getLogger(IndexPlugin.class);
    private final Namespace xmlns_XHTML = Namespace.getNamespace((String)"http://www.w3.org/1999/xhtml");

    public String execute(Context context, Map<String, String> params) throws PluginException {
        String include = params.get("include");
        String exclude = params.get("exclude");
        Element masterDiv = this.getElement("div", "index");
        Element indexDiv = this.getElement("div", "header");
        masterDiv.addContent((Content)indexDiv);
        try {
            List<String> pages = this.listPages(context, include, exclude);
            ((PageManager)context.getEngine().getManager(PageManager.class)).getPageSorter().sort(pages);
            char initialChar = ' ';
            Element currentDiv = new Element("div", this.xmlns_XHTML);
            for (String name : pages) {
                if (StringUtils.isNotBlank((CharSequence)name) && name.charAt(0) != initialChar) {
                    if (initialChar != ' ') {
                        indexDiv.addContent(" - ");
                    }
                    initialChar = name.charAt(0);
                    masterDiv.addContent((Content)this.makeHeader(String.valueOf(initialChar)));
                    currentDiv = this.getElement("div", "body");
                    masterDiv.addContent((Content)currentDiv);
                    indexDiv.addContent((Content)this.getLink("#" + initialChar, String.valueOf(initialChar)));
                } else {
                    currentDiv.addContent(", ");
                }
                currentDiv.addContent((Content)this.getLink(context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), name), name));
            }
        }
        catch (ProviderException e) {
            LOG.warn("could not load page index", (Throwable)e);
            throw new PluginException(e.getMessage());
        }
        XMLOutputter out = new XMLOutputter(Format.getRawFormat());
        return out.outputString(masterDiv);
    }

    private Element getLink(String href, String content) {
        Element a = new Element("a", this.xmlns_XHTML);
        a.setAttribute("href", href);
        a.addContent(content);
        return a;
    }

    private Element makeHeader(String initialChar) {
        Element span = this.getElement("span", "section");
        Element a = new Element("a", this.xmlns_XHTML);
        a.setAttribute("id", initialChar);
        a.addContent(initialChar);
        span.addContent((Content)a);
        return span;
    }

    private Element getElement(String gi, String classValue) {
        Element elt = new Element(gi, this.xmlns_XHTML);
        elt.setAttribute("class", classValue);
        return elt;
    }

    private List<String> listPages(Context context, String include, String exclude) throws ProviderException {
        Pattern includePtrn = include != null ? Pattern.compile(include) : Pattern.compile(".*");
        Pattern excludePtrn = exclude != null ? Pattern.compile(exclude) : Pattern.compile("\\p{Cntrl}");
        ArrayList<String> result = new ArrayList<String>();
        Set<String> pages = ((ReferenceManager)context.getEngine().getManager(ReferenceManager.class)).findCreated();
        for (String pageName : pages) {
            if (excludePtrn.matcher(pageName).matches() || !includePtrn.matcher(pageName).matches()) continue;
            result.add(pageName);
        }
        return result;
    }
}

