/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.parser.ParseException;
import org.jdom2.Attribute;

public class LinkParser {
    private static final Logger LOG = LogManager.getLogger(LinkParser.class);
    private static final String[] PERMITTED_ATTRIBUTES = new String[]{"accesskey", "charset", "class", "dir", "hreflang", "id", "lang", "rel", "rev", "style", "tabindex", "target", "title", "type"};
    private static final String[] PERMITTED_TARGET_VALUES = new String[]{"_blank", "_self", "_parent", "_top"};
    private static final String REL = "rel";
    private static final String NOREFERRER = "noreferrer";
    private static final String EQSQUO = "='";
    private static final String SQUO = "'";
    private static final String EQ = "=";
    private static final String TARGET = "target";
    private static final String DELIMS = " \t\n\r\f=";
    private static final List<Attribute> m_EMPTY = new ArrayList<Attribute>();

    public Link parse(String linktext) throws ParseException {
        if (linktext == null) {
            throw new ParseException("null value passed to link parser");
        }
        Link link = null;
        try {
            int cut2;
            int cut1 = linktext.indexOf(124);
            if (cut1 == -1) {
                return new Link(linktext);
            }
            int n = cut2 = cut1 + 1 < linktext.length() ? linktext.indexOf(124, cut1 + 1) : -1;
            if (cut2 == -1) {
                String text = linktext.substring(0, cut1).trim();
                String ref = linktext.substring(cut1 + 1).trim();
                return new Link(text, ref);
            }
            String text = linktext.substring(0, cut1).trim();
            String ref = linktext.substring(cut1 + 1, cut2).trim();
            String attribs = linktext.substring(cut2 + 1).trim();
            link = new Link(text, ref);
            if (attribs.contains(EQSQUO)) {
                try {
                    StringTokenizer tok = new StringTokenizer(attribs, DELIMS, true);
                    while (tok.hasMoreTokens()) {
                        String token = tok.nextToken(DELIMS).trim();
                        while (LinkParser.isSpace(token) && tok.hasMoreTokens()) {
                            token = tok.nextToken(DELIMS).trim();
                        }
                        this.require(tok, EQ);
                        this.require(tok, SQUO);
                        String value = tok.nextToken(SQUO);
                        this.require(tok, SQUO);
                        if (token != null && value != null) {
                            if (Arrays.binarySearch(PERMITTED_ATTRIBUTES, token) >= 0) {
                                if (!token.equals(TARGET) || Arrays.binarySearch(PERMITTED_TARGET_VALUES, value) >= 0) {
                                    Attribute a = new Attribute(token, value);
                                    link.addAttribute(a);
                                    if (!token.equals(TARGET)) continue;
                                    Attribute rel = new Attribute(REL, NOREFERRER);
                                    link.addAttribute(rel);
                                    continue;
                                }
                                throw new ParseException("unknown target attribute value='" + value + "' on link");
                            }
                            throw new ParseException("unknown attribute name '" + token + "' on link");
                        }
                        throw new ParseException("unable to parse link attributes '" + attribs + SQUO);
                    }
                }
                catch (ParseException pe) {
                    LOG.warn("syntax error parsing link attributes '" + attribs + "': " + pe.getMessage());
                }
                catch (NoSuchElementException nse) {
                    LOG.warn("expected more tokens while parsing link attributes '" + attribs + SQUO);
                }
            }
        }
        catch (Exception e) {
            LOG.warn(e.getClass().getName() + " thrown by link parser: " + e.getMessage());
        }
        return link;
    }

    private String require(StringTokenizer tok, String required) throws ParseException, NoSuchElementException {
        String s = tok.nextToken(required);
        if (!s.equals(required)) {
            throw new ParseException("expected '" + required + "' not '" + s + SQUO);
        }
        return s;
    }

    public static final boolean isSpace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (LinkParser.isSpace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSpace(char c) {
        return ' ' == c || '\n' == c || '\r' == c || '\t' == c || '\u0085' == c || '\u2028' == c;
    }

    public static class Link {
        private String m_text;
        private String m_ref;
        private int m_interwikiPoint = -1;
        private List<Attribute> m_attribs;

        protected Link(String text) throws ParseException {
            this.setText(text);
        }

        protected Link(String text, String ref) throws ParseException {
            this.setText(text);
            this.setReference(ref);
        }

        protected void setText(String text) throws ParseException {
            if (text == null) {
                throw new ParseException("null link text");
            }
            this.m_text = text;
        }

        public String getText() {
            return this.m_text;
        }

        protected void setReference(String ref) throws ParseException {
            if (ref == null) {
                throw new ParseException("null link reference value");
            }
            this.m_ref = ref;
        }

        public boolean hasReference() {
            return this.m_ref != null;
        }

        public String getReference() {
            return this.m_ref != null ? this.m_ref : this.m_text;
        }

        public boolean isInterwikiLink() {
            LinkParsingOperations lpo = new LinkParsingOperations(null);
            if (!this.hasReference()) {
                this.m_ref = this.m_text;
            }
            this.m_interwikiPoint = lpo.interWikiLinkAt(this.m_ref);
            return lpo.isInterWikiLink(this.m_ref);
        }

        public String getExternalWiki() {
            if (this.isInterwikiLink()) {
                return this.m_ref.substring(0, this.m_interwikiPoint);
            }
            return null;
        }

        public String getExternalWikiPage() {
            if (this.isInterwikiLink()) {
                return this.m_ref.substring(this.m_interwikiPoint + 1);
            }
            return null;
        }

        public int attributeCount() {
            return this.m_attribs != null ? this.m_attribs.size() : 0;
        }

        public void addAttribute(Attribute attr) {
            if (this.m_attribs == null) {
                this.m_attribs = new ArrayList<Attribute>();
            }
            this.m_attribs.add(attr);
        }

        public Iterator<Attribute> getAttributes() {
            return this.m_attribs != null ? this.m_attribs.iterator() : m_EMPTY.iterator();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(this.m_text);
            if (this.m_ref != null) {
                sb.append(' ');
                sb.append('|');
                sb.append(' ');
                sb.append(this.m_ref);
            }
            if (this.m_attribs != null) {
                sb.append(' ');
                sb.append('|');
                Iterator<Attribute> it = this.getAttributes();
                while (it.hasNext()) {
                    Attribute a = it.next();
                    sb.append(' ');
                    sb.append(a.getName());
                    sb.append('=');
                    sb.append('\'');
                    sb.append(a.getValue());
                    sb.append('\'');
                }
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

