/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.filters.BasePageFilter;
import org.apache.wiki.util.TextUtil;

public class ProfanityFilter
extends BasePageFilter {
    private static final Logger LOG = LogManager.getLogger(ProfanityFilter.class);
    private static final String PROPERTYFILE = "org/apache/wiki/filters/profanity.properties";
    private static String[] c_profanities = new String[0];

    public String preTranslate(Context context, String content) {
        for (String word : c_profanities) {
            String replacement = word.charAt(0) + "*" + word.charAt(word.length() - 1);
            content = TextUtil.replaceStringCaseUnsensitive((String)content, (String)word, (String)replacement);
        }
        return content;
    }

    static {
        ClassLoader loader = ProfanityFilter.class.getClassLoader();
        try (InputStream in = loader.getResourceAsStream(PROPERTYFILE);){
            if (in == null) {
                throw new IOException("No property file found! (Check the installation, it should be there.)");
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(in));){
                String str;
                ArrayList<String> profs = new ArrayList<String>();
                while ((str = br.readLine()) != null) {
                    if (str.isEmpty() || str.startsWith("#")) continue;
                    profs.add(str);
                }
                c_profanities = profs.toArray(new String[0]);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load profanities from org/apache/wiki/filters/profanity.properties", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Unable to initialize Profanity Filter", (Throwable)e);
        }
    }
}

