/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.user;

import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.user.AbstractUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.util.Serializer;

public class JDBCUserDatabase
extends AbstractUserDatabase {
    private static final String NOTHING = "";
    public static final String DEFAULT_DB_ATTRIBUTES = "attributes";
    public static final String DEFAULT_DB_CREATED = "created";
    public static final String DEFAULT_DB_EMAIL = "email";
    public static final String DEFAULT_DB_FULL_NAME = "full_name";
    public static final String DEFAULT_DB_JNDI_NAME = "jdbc/UserDatabase";
    public static final String DEFAULT_DB_LOCK_EXPIRY = "lock_expiry";
    public static final String DEFAULT_DB_MODIFIED = "modified";
    public static final String DEFAULT_DB_ROLE = "role";
    public static final String DEFAULT_DB_ROLE_TABLE = "roles";
    public static final String DEFAULT_DB_TABLE = "users";
    public static final String DEFAULT_DB_LOGIN_NAME = "login_name";
    public static final String DEFAULT_DB_PASSWORD = "password";
    public static final String DEFAULT_DB_UID = "uid";
    public static final String DEFAULT_DB_WIKI_NAME = "wiki_name";
    public static final String PROP_DB_ATTRIBUTES = "jspwiki.userdatabase.attributes";
    public static final String PROP_DB_CREATED = "jspwiki.userdatabase.created";
    public static final String PROP_DB_EMAIL = "jspwiki.userdatabase.email";
    public static final String PROP_DB_FULL_NAME = "jspwiki.userdatabase.fullName";
    public static final String PROP_DB_DATASOURCE = "jspwiki.userdatabase.datasource";
    public static final String PROP_DB_LOCK_EXPIRY = "jspwiki.userdatabase.lockExpiry";
    public static final String PROP_DB_LOGIN_NAME = "jspwiki.userdatabase.loginName";
    public static final String PROP_DB_MODIFIED = "jspwiki.userdatabase.modified";
    public static final String PROP_DB_PASSWORD = "jspwiki.userdatabase.password";
    public static final String PROP_DB_UID = "jspwiki.userdatabase.uid";
    public static final String PROP_DB_ROLE = "jspwiki.userdatabase.role";
    public static final String PROP_DB_ROLE_TABLE = "jspwiki.userdatabase.roleTable";
    public static final String PROP_DB_TABLE = "jspwiki.userdatabase.table";
    public static final String PROP_DB_WIKI_NAME = "jspwiki.userdatabase.wikiName";
    private DataSource m_ds;
    private String m_deleteUserByLoginName;
    private String m_deleteRoleByLoginName;
    private String m_findByEmail;
    private String m_findByFullName;
    private String m_findByLoginName;
    private String m_findByUid;
    private String m_findByWikiName;
    private String m_renameProfile;
    private String m_renameRoles;
    private String m_updateProfile;
    private String m_findAll;
    private String m_findRoles;
    private String m_insertProfile;
    private String m_insertRole;
    private String m_attributes;
    private String m_email;
    private String m_fullName;
    private String m_lockExpiry;
    private String m_loginName;
    private String m_password;
    private String m_uid;
    private String m_wikiName;
    private String m_created;
    private String m_modified;
    private boolean m_supportsCommits;

    @Override
    public void deleteByLoginName(String loginName) throws WikiSecurityException {
        this.findByLoginName(loginName);
        try (Connection conn = this.m_ds.getConnection();
             PreparedStatement ps1 = conn.prepareStatement(this.m_deleteUserByLoginName);
             PreparedStatement ps2 = conn.prepareStatement(this.m_deleteRoleByLoginName);){
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            ps1.setString(1, loginName);
            ps1.execute();
            ps2.setString(1, loginName);
            ps2.execute();
            if (this.m_supportsCommits) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public UserProfile findByEmail(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByEmail, index);
    }

    @Override
    public UserProfile findByFullName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByFullName, index);
    }

    @Override
    public UserProfile findByLoginName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByLoginName, index);
    }

    @Override
    public UserProfile findByUid(String uid) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByUid, uid);
    }

    @Override
    public UserProfile findByWikiName(String index) throws NoSuchPrincipalException {
        return this.findByPreparedStatement(this.m_findByWikiName, index);
    }

    @Override
    public Principal[] getWikiNames() throws WikiSecurityException {
        HashSet<WikiPrincipal> principals = new HashSet<WikiPrincipal>();
        try (Connection conn = this.m_ds.getConnection();
             PreparedStatement ps = conn.prepareStatement(this.m_findAll);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String wikiName = rs.getString(this.m_wikiName);
                if (StringUtils.isEmpty((CharSequence)wikiName)) {
                    LOG.warn("Detected null or empty wiki name for {} in JDBCUserDataBase. Check your user database.", (Object)rs.getString(this.m_loginName));
                    continue;
                }
                WikiPrincipal principal = new WikiPrincipal(wikiName, "wikiName");
                principals.add(principal);
            }
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        return principals.toArray(new Principal[0]);
    }

    @Override
    public void initialize(Engine engine, Properties props) throws NoRequiredPropertyException, WikiSecurityException {
        Throwable throwable;
        Connection conn;
        String jndiName = props.getProperty(PROP_DB_DATASOURCE, DEFAULT_DB_JNDI_NAME);
        try {
            InitialContext initCtx = new InitialContext();
            Context ctx = (Context)initCtx.lookup("java:comp/env");
            this.m_ds = (DataSource)ctx.lookup(jndiName);
            String userTable = props.getProperty(PROP_DB_TABLE, DEFAULT_DB_TABLE);
            this.m_email = props.getProperty(PROP_DB_EMAIL, DEFAULT_DB_EMAIL);
            this.m_fullName = props.getProperty(PROP_DB_FULL_NAME, DEFAULT_DB_FULL_NAME);
            this.m_lockExpiry = props.getProperty(PROP_DB_LOCK_EXPIRY, DEFAULT_DB_LOCK_EXPIRY);
            this.m_loginName = props.getProperty(PROP_DB_LOGIN_NAME, DEFAULT_DB_LOGIN_NAME);
            this.m_password = props.getProperty(PROP_DB_PASSWORD, DEFAULT_DB_PASSWORD);
            this.m_uid = props.getProperty(PROP_DB_UID, DEFAULT_DB_UID);
            this.m_wikiName = props.getProperty(PROP_DB_WIKI_NAME, DEFAULT_DB_WIKI_NAME);
            this.m_created = props.getProperty(PROP_DB_CREATED, DEFAULT_DB_CREATED);
            this.m_modified = props.getProperty(PROP_DB_MODIFIED, DEFAULT_DB_MODIFIED);
            this.m_attributes = props.getProperty(PROP_DB_ATTRIBUTES, DEFAULT_DB_ATTRIBUTES);
            this.m_findAll = "SELECT * FROM " + userTable;
            this.m_findByEmail = "SELECT * FROM " + userTable + " WHERE " + this.m_email + "=?";
            this.m_findByFullName = "SELECT * FROM " + userTable + " WHERE " + this.m_fullName + "=?";
            this.m_findByLoginName = "SELECT * FROM " + userTable + " WHERE " + this.m_loginName + "=?";
            this.m_findByUid = "SELECT * FROM " + userTable + " WHERE " + this.m_uid + "=?";
            this.m_findByWikiName = "SELECT * FROM " + userTable + " WHERE " + this.m_wikiName + "=?";
            this.m_insertProfile = "INSERT INTO " + userTable + " (" + this.m_uid + "," + this.m_email + "," + this.m_fullName + "," + this.m_password + "," + this.m_wikiName + "," + this.m_modified + "," + this.m_loginName + "," + this.m_attributes + "," + this.m_created + ") VALUES (?,?,?,?,?,?,?,?,?)";
            this.m_updateProfile = "UPDATE " + userTable + " SET " + this.m_uid + "=?," + this.m_email + "=?," + this.m_fullName + "=?," + this.m_password + "=?," + this.m_wikiName + "=?," + this.m_modified + "=?," + this.m_loginName + "=?," + this.m_attributes + "=?," + this.m_lockExpiry + "=? WHERE " + this.m_loginName + "=?";
            String roleTable = props.getProperty(PROP_DB_ROLE_TABLE, DEFAULT_DB_ROLE_TABLE);
            String role = props.getProperty(PROP_DB_ROLE, DEFAULT_DB_ROLE);
            this.m_insertRole = "INSERT INTO " + roleTable + " (" + this.m_loginName + "," + role + ") VALUES (?,?)";
            this.m_findRoles = "SELECT * FROM " + roleTable + " WHERE " + this.m_loginName + "=?";
            this.m_deleteUserByLoginName = "DELETE FROM " + userTable + " WHERE " + this.m_loginName + "=?";
            this.m_deleteRoleByLoginName = "DELETE FROM " + roleTable + " WHERE " + this.m_loginName + "=?";
            this.m_renameProfile = "UPDATE " + userTable + " SET " + this.m_loginName + "=?," + this.m_modified + "=? WHERE " + this.m_loginName + "=?";
            this.m_renameRoles = "UPDATE " + roleTable + " SET " + this.m_loginName + "=? WHERE " + this.m_loginName + "=?";
        }
        catch (NamingException e) {
            LOG.error("JDBCUserDatabase initialization error: " + e.getMessage());
            throw new NoRequiredPropertyException(PROP_DB_DATASOURCE, "JDBCUserDatabase initialization error: " + e.getMessage());
        }
        try {
            conn = this.m_ds.getConnection();
            throwable = null;
            try {
                PreparedStatement ps = conn.prepareStatement(this.m_findAll);
                Throwable throwable2 = null;
                if (ps != null) {
                    if (throwable2 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            catch (Throwable ps) {
                throwable = ps;
                throw ps;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable ps) {
                            throwable.addSuppressed(ps);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            LOG.error("DB connectivity error: " + e.getMessage());
            throw new WikiSecurityException("DB connectivity error: " + e.getMessage(), e);
        }
        LOG.info("JDBCUserDatabase initialized from JNDI DataSource: {}", (Object)jndiName);
        try {
            conn = this.m_ds.getConnection();
            throwable = null;
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                if (dmd.supportsTransactions()) {
                    this.m_supportsCommits = true;
                    conn.setAutoCommit(false);
                    LOG.info("JDBCUserDatabase supports transactions. Good; we will use them.");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            LOG.warn("JDBCUserDatabase warning: user database doesn't seem to support transactions. Reason: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void rename(String loginName, String newName) throws DuplicateUserException, WikiSecurityException {
        UserProfile profile = this.findByLoginName(loginName);
        try {
            UserProfile otherProfile = this.findByLoginName(newName);
            if (otherProfile != null) {
                throw new DuplicateUserException("security.error.cannot.rename", newName);
            }
        }
        catch (NoSuchPrincipalException otherProfile) {
            // empty catch block
        }
        try (Connection conn = this.m_ds.getConnection();
             PreparedStatement ps1 = conn.prepareStatement(this.m_renameProfile);
             PreparedStatement ps2 = conn.prepareStatement(this.m_renameRoles);){
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            java.util.Date modDate = new java.util.Date(ts.getTime());
            ps1.setString(1, newName);
            ps1.setTimestamp(2, ts);
            ps1.setString(3, loginName);
            ps1.execute();
            ps2.setString(1, newName);
            ps2.setString(2, loginName);
            ps2.execute();
            profile.setLoginName(newName);
            profile.setLastModified(modDate);
            if (this.m_supportsCommits) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
    }

    @Override
    public void save(UserProfile profile) throws WikiSecurityException {
        String existingPassword;
        String initialRole = "Authenticated";
        String loginName = profile.getLoginName();
        UserProfile existingProfile = null;
        try {
            existingProfile = this.findByLoginName(loginName);
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        String password = profile.getPassword();
        String string = existingPassword = existingProfile == null ? null : existingProfile.getPassword();
        if (NOTHING.equals(password)) {
            password = null;
        }
        if (password == null) {
            password = existingPassword;
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)existingPassword)) {
            password = this.getHash(password);
        }
        try (Connection conn = this.m_ds.getConnection();
             PreparedStatement ps1 = conn.prepareStatement(this.m_insertProfile);
             PreparedStatement ps2 = conn.prepareStatement(this.m_findRoles);
             PreparedStatement ps3 = conn.prepareStatement(this.m_insertRole);
             PreparedStatement ps4 = conn.prepareStatement(this.m_updateProfile);){
            Date lockExpiry;
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            java.util.Date modDate = new java.util.Date(ts.getTime());
            Date date = lockExpiry = profile.getLockExpiry() == null ? null : new Date(profile.getLockExpiry().getTime());
            if (existingProfile == null) {
                ps1.setString(1, profile.getUid());
                ps1.setString(2, profile.getEmail());
                ps1.setString(3, profile.getFullname());
                ps1.setString(4, password);
                ps1.setString(5, profile.getWikiName());
                ps1.setTimestamp(6, ts);
                ps1.setString(7, profile.getLoginName());
                try {
                    ps1.setString(8, Serializer.serializeToBase64(profile.getAttributes()));
                }
                catch (IOException e) {
                    throw new WikiSecurityException("Could not save user profile attribute. Reason: " + e.getMessage(), e);
                }
                ps1.setTimestamp(9, ts);
                ps1.execute();
                ps2.setString(1, profile.getLoginName());
                int roles = 0;
                try (ResultSet rs = ps2.executeQuery();){
                    while (rs.next()) {
                        ++roles;
                    }
                }
                if (roles == 0) {
                    ps3.setString(1, profile.getLoginName());
                    ps3.setString(2, "Authenticated");
                    ps3.execute();
                }
                profile.setCreated(modDate);
            } else {
                ps4.setString(1, profile.getUid());
                ps4.setString(2, profile.getEmail());
                ps4.setString(3, profile.getFullname());
                ps4.setString(4, password);
                ps4.setString(5, profile.getWikiName());
                ps4.setTimestamp(6, ts);
                ps4.setString(7, profile.getLoginName());
                try {
                    ps4.setString(8, Serializer.serializeToBase64(profile.getAttributes()));
                }
                catch (IOException e) {
                    throw new WikiSecurityException("Could not save user profile attribute. Reason: " + e.getMessage(), e);
                }
                ps4.setDate(9, lockExpiry);
                ps4.setString(10, profile.getLoginName());
                ps4.execute();
            }
            profile.setLastModified(modDate);
            if (this.m_supportsCommits) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
    }

    private UserProfile findByPreparedStatement(String sql, Object index) throws NoSuchPrincipalException {
        UserProfile profile = null;
        boolean found = false;
        boolean unique = true;
        try (Connection conn = this.m_ds.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            if (this.m_supportsCommits) {
                conn.setAutoCommit(false);
            }
            if (index instanceof String) {
                ps.setString(1, (String)index);
            } else if (index instanceof Long) {
                ps.setLong(1, (Long)index);
            } else {
                throw new IllegalArgumentException("Index type not recognized!");
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (profile != null) {
                        unique = false;
                        break;
                    }
                    profile = this.newProfile();
                    profile.setUid(rs.getString(this.m_uid));
                    if (profile.getUid() == null) {
                        profile.setUid(JDBCUserDatabase.generateUid(this));
                    }
                    profile.setCreated(rs.getTimestamp(this.m_created));
                    profile.setEmail(rs.getString(this.m_email));
                    profile.setFullname(rs.getString(this.m_fullName));
                    profile.setLastModified(rs.getTimestamp(this.m_modified));
                    Date lockExpiry = rs.getDate(this.m_lockExpiry);
                    profile.setLockExpiry(rs.wasNull() ? null : lockExpiry);
                    profile.setLoginName(rs.getString(this.m_loginName));
                    profile.setPassword(rs.getString(this.m_password));
                    String rawAttributes = rs.getString(this.m_attributes);
                    if (rawAttributes != null) {
                        try {
                            Map attributes = Serializer.deserializeFromBase64((String)rawAttributes);
                            profile.getAttributes().putAll(attributes);
                        }
                        catch (IOException e) {
                            LOG.error("Could not parse user profile attributes!", (Throwable)e);
                        }
                    }
                    found = true;
                }
            }
        }
        catch (SQLException e) {
            throw new NoSuchPrincipalException(e.getMessage());
        }
        if (!found) {
            throw new NoSuchPrincipalException("Could not find profile in database!");
        }
        if (!unique) {
            throw new NoSuchPrincipalException("More than one profile in database!");
        }
        return profile;
    }
}

