/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.authorize.GroupDatabase;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.authorize.XMLGroupDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.ui.InputValidator;
import org.apache.wiki.util.ClassUtil;

public class DefaultGroupManager
implements GroupManager,
Authorizer,
WikiEventListener {
    private static final Logger LOG = LogManager.getLogger(DefaultGroupManager.class);
    protected Engine m_engine;
    protected WikiEventListener m_groupListener;
    private GroupDatabase m_groupDatabase;
    private final Map<Principal, Group> m_groups = new HashMap<Principal, Group>();

    @Override
    public Principal findRole(String name) {
        try {
            Group group = this.getGroup(name);
            return group.getPrincipal();
        }
        catch (NoSuchPrincipalException e) {
            return null;
        }
    }

    @Override
    public Group getGroup(String name) throws NoSuchPrincipalException {
        Group group = this.m_groups.get(new GroupPrincipal(name));
        if (group != null) {
            return group;
        }
        throw new NoSuchPrincipalException("Group " + name + " not found.");
    }

    @Override
    public GroupDatabase getGroupDatabase() throws WikiSecurityException {
        if (this.m_groupDatabase != null) {
            return this.m_groupDatabase;
        }
        String dbClassName = "<unknown>";
        String dbInstantiationError = null;
        Throwable cause = null;
        try {
            Properties props = this.m_engine.getWikiProperties();
            dbClassName = props.getProperty("jspwiki.groupdatabase");
            if (dbClassName == null) {
                dbClassName = XMLGroupDatabase.class.getName();
            }
            LOG.info("Attempting to load group database class {}" + dbClassName);
            this.m_groupDatabase = (GroupDatabase)ClassUtil.buildInstance((String)"org.apache.wiki.auth.authorize", (String)dbClassName);
            this.m_groupDatabase.initialize(this.m_engine, this.m_engine.getWikiProperties());
            LOG.info("Group database initialized.");
        }
        catch (ReflectiveOperationException e) {
            LOG.error("UserDatabase {} cannot be instantiated", (Object)dbClassName, (Object)e);
            dbInstantiationError = "Access GroupDatabase class " + dbClassName + " denied";
            cause = e;
        }
        catch (NoRequiredPropertyException e) {
            LOG.error("Missing property: " + e.getMessage() + ".");
            dbInstantiationError = "Missing property: " + e.getMessage();
            cause = e;
        }
        if (dbInstantiationError != null) {
            throw new WikiSecurityException(dbInstantiationError + " Cause: " + cause.getMessage(), cause);
        }
        return this.m_groupDatabase;
    }

    @Override
    public Principal[] getRoles() {
        return this.m_groups.keySet().toArray(new Principal[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Engine engine, Properties props) throws WikiSecurityException {
        this.m_engine = engine;
        try {
            this.m_groupDatabase = this.getGroupDatabase();
        }
        catch (WikiException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        Group[] groups = this.m_groupDatabase.groups();
        Map<Principal, Group> map = this.m_groups;
        synchronized (map) {
            for (Group group : groups) {
                this.m_groups.put(group.getPrincipal(), group);
                this.fireEvent(46, group);
            }
        }
        ((UserManager)engine.getManager(UserManager.class)).addWikiEventListener(this);
        LOG.info("Authorizer GroupManager initialized successfully; loaded " + groups.length + " group(s).");
    }

    @Override
    public boolean isUserInRole(Session session, Principal role) {
        if (session == null || !(role instanceof GroupPrincipal) || !session.isAuthenticated()) {
            return false;
        }
        Group group = this.m_groups.get(role);
        if (group == null) {
            return false;
        }
        for (Principal principal : session.getPrincipals()) {
            if (!AuthenticationManager.isUserPrincipal(principal) || !group.isMember(principal)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Group parseGroup(String name, String memberLine, boolean create) throws WikiSecurityException {
        String[] members;
        Group group;
        block8: {
            if (name == null) {
                if (!create) throw new WikiSecurityException("Group name cannot be blank.");
                name = "MyGroup";
            } else if (ArrayUtils.contains((Object[])Group.RESTRICTED_GROUPNAMES, (Object)name)) {
                throw new WikiSecurityException("Illegal group name: " + name);
            }
            name = name.trim();
            if (InputValidator.isBlank(memberLine)) {
                memberLine = "";
            }
            memberLine = memberLine.trim();
            group = new Group(name, this.m_engine.getApplicationName());
            try {
                Group existingGroup = this.getGroup(name);
                group.setCreator(existingGroup.getCreator());
                group.setCreated(existingGroup.getCreated());
                group.setModifier(existingGroup.getModifier());
                group.setLastModified(existingGroup.getLastModified());
                for (Principal existingMember : existingGroup.members()) {
                    group.add(existingMember);
                }
            }
            catch (NoSuchPrincipalException e) {
                if (create) break block8;
                throw new NoSuchPrincipalException("Group '" + name + "' does not exist.");
            }
        }
        if ((members = this.extractMembers(memberLine)).length <= 0) return group;
        group.clear();
        for (String member : members) {
            group.add(new WikiPrincipal(member));
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(String index) throws WikiSecurityException {
        if (index == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        Group group = this.m_groups.get(new GroupPrincipal(index));
        if (group == null) {
            throw new NoSuchPrincipalException("Group " + index + " not found");
        }
        Map<Principal, Group> map = this.m_groups;
        synchronized (map) {
            this.m_groups.remove(group.getPrincipal());
        }
        this.m_groupDatabase.delete(group);
        this.fireEvent(47, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroup(Session session, Group group) throws WikiSecurityException {
        Map<Principal, Group> map;
        Group oldGroup = this.m_groups.get(group.getPrincipal());
        if (oldGroup != null) {
            this.fireEvent(47, oldGroup);
            map = this.m_groups;
            synchronized (map) {
                this.m_groups.remove(oldGroup.getPrincipal());
            }
        }
        if (oldGroup != null) {
            group.setCreator(oldGroup.getCreator());
            group.setCreated(oldGroup.getCreated());
            group.setModifier(oldGroup.getModifier());
            group.setLastModified(oldGroup.getLastModified());
        }
        map = this.m_groups;
        synchronized (map) {
            this.m_groups.put(group.getPrincipal(), group);
        }
        this.fireEvent(46, group);
        try {
            this.m_groupDatabase.save(group, session.getUserPrincipal());
        }
        catch (WikiSecurityException e) {
            if (oldGroup != null) {
                this.fireEvent(47, group);
                this.fireEvent(46, oldGroup);
                Map<Principal, Group> map2 = this.m_groups;
                synchronized (map2) {
                    this.m_groups.put(oldGroup.getPrincipal(), oldGroup);
                }
                throw new WikiSecurityException(e.getMessage() + " (rolled back to previous version).", (Throwable)((Object)e));
            }
            throw new WikiSecurityException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public void validateGroup(Context context, Group group) {
        Principal[] members;
        InputValidator validator = new InputValidator("group", context);
        try {
            this.checkGroupName(context, group.getName());
        }
        catch (WikiSecurityException wikiSecurityException) {
            // empty catch block
        }
        for (Principal member : members = group.members()) {
            validator.validateNotNull(member.getName(), "Full name", 2);
        }
    }

    @Override
    public void checkGroupName(Context context, String name) throws WikiSecurityException {
        InputValidator validator = new InputValidator("group", context);
        validator.validateNotNull(name, "Group name");
        if (ArrayUtils.contains((Object[])Group.RESTRICTED_GROUPNAMES, (Object)name)) {
            throw new WikiSecurityException("The group name '" + name + "' is illegal. Choose another.");
        }
    }

    protected String[] extractMembers(String memberLine) {
        HashSet<String> members = new HashSet<String>();
        if (memberLine != null) {
            StringTokenizer tok = new StringTokenizer(memberLine, "\n");
            while (tok.hasMoreTokens()) {
                String uid = tok.nextToken().trim();
                if (uid.isEmpty()) continue;
                members.add(uid);
            }
        }
        return members.toArray(new String[0]);
    }

    @Override
    public synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    @Override
    public synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            Session session = (Session)se.getSrc();
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            int groupsChanged = 0;
            try {
                for (Group group : this.m_groupDatabase.groups()) {
                    boolean groupChanged = false;
                    for (Principal oldPrincipal : oldPrincipals) {
                        if (!group.isMember(oldPrincipal)) continue;
                        group.remove(oldPrincipal);
                        group.add(newPrincipal);
                        groupChanged = true;
                    }
                    if (!groupChanged) continue;
                    this.setGroup(session, group);
                    ++groupsChanged;
                }
            }
            catch (WikiException e) {
                LOG.error("Could not change user name in Group lists because of GroupDatabase error:" + e.getMessage());
            }
            LOG.info("Profile name change for '" + newPrincipal + "' caused " + groupsChanged + " groups to change also.");
        }
    }
}

