/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.ajax.AjaxUtil;
import org.apache.wiki.ajax.WikiAjaxDispatcherServlet;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.filters.PageFilter;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.auth.user.DummyUserDatabase;
import org.apache.wiki.auth.user.DuplicateUserException;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.filters.SpamFilter;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.tasks.TasksManager;
import org.apache.wiki.ui.InputValidator;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionRequiredException;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Step;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowBuilder;

public class DefaultUserManager
implements UserManager {
    private static final String USERDATABASE_PACKAGE = "org.apache.wiki.auth.user";
    private static final String SESSION_MESSAGES = "profile";
    private static final String PARAM_EMAIL = "email";
    private static final String PARAM_FULLNAME = "fullname";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_LOGINNAME = "loginname";
    private static final String UNKNOWN_CLASS = "<unknown>";
    private Engine m_engine;
    private static final Logger LOG = LogManager.getLogger(DefaultUserManager.class);
    private final Map<Session, UserProfile> m_profiles = new WeakHashMap<Session, UserProfile>();
    private UserDatabase m_database;

    public void initialize(Engine engine, Properties props) {
        this.m_engine = engine;
        this.addWikiEventListener((WikiEventListener)engine.getManager(PageManager.class));
        WikiAjaxDispatcherServlet.registerServlet("users", new JSONUserModule(this), new AllPermission(null));
    }

    @Override
    public UserDatabase getUserDatabase() {
        if (this.m_database != null) {
            return this.m_database;
        }
        String dbClassName = UNKNOWN_CLASS;
        try {
            dbClassName = TextUtil.getRequiredProperty((Properties)this.m_engine.getWikiProperties(), (String)"jspwiki.userdatabase");
            LOG.info("Attempting to load user database class {}", (Object)dbClassName);
            this.m_database = (UserDatabase)ClassUtil.buildInstance((String)USERDATABASE_PACKAGE, (String)dbClassName);
            this.m_database.initialize(this.m_engine, this.m_engine.getWikiProperties());
            LOG.info("UserDatabase initialized.");
        }
        catch (NoSuchElementException | NoRequiredPropertyException e) {
            LOG.error("You have not set the '{}'. You need to do this if you want to enable user management by JSPWiki.", (Object)"jspwiki.userdatabase", (Object)e);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("UserDatabase {} cannot be instantiated", (Object)dbClassName, (Object)e);
        }
        catch (WikiSecurityException e) {
            LOG.error("Exception initializing user database: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (this.m_database == null) {
                LOG.info("I could not create a database object you specified (or didn't specify), so I am falling back to a default.");
                this.m_database = new DummyUserDatabase();
            }
        }
        return this.m_database;
    }

    @Override
    public UserProfile getUserProfile(Session session) {
        UserProfile profile = this.m_profiles.get(session);
        boolean newProfile = profile == null;
        Principal user = null;
        if (session.isAuthenticated()) {
            user = session.getUserPrincipal();
            try {
                profile = this.getUserDatabase().find(user.getName());
                newProfile = false;
            }
            catch (NoSuchPrincipalException noSuchPrincipalException) {
                // empty catch block
            }
        }
        if (newProfile) {
            profile = this.getUserDatabase().newProfile();
            if (user != null) {
                profile.setLoginName(user.getName());
            }
            if (!profile.isNew()) {
                throw new IllegalStateException("New profile should be marked 'new'. Check your UserProfile implementation.");
            }
        }
        this.m_profiles.put(session, profile);
        return profile;
    }

    @Override
    public void setUserProfile(Context context, UserProfile profile) throws DuplicateUserException, WikiException {
        UserProfile otherProfile;
        Session session = context.getWikiSession();
        WikiPermission p = new WikiPermission(this.m_engine.getApplicationName(), "editProfile");
        if (!((AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class)).checkPermission(session, p)) {
            throw new WikiSecurityException("You are not allowed to save wiki profiles.");
        }
        boolean newProfile = profile.isNew();
        UserProfile oldProfile = this.getUserProfile(session);
        boolean nameChanged = oldProfile != null && oldProfile.getFullname() != null && (!oldProfile.getFullname().equals(profile.getFullname()) || !oldProfile.getLoginName().equals(profile.getLoginName()));
        try {
            otherProfile = this.getUserDatabase().findByLoginName(profile.getLoginName());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("security.error.login.taken", profile.getLoginName());
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().findByFullName(profile.getFullname());
            if (otherProfile != null && !otherProfile.equals(oldProfile)) {
                throw new DuplicateUserException("security.error.fullname.taken", profile.getFullname());
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        if (newProfile && oldProfile != null && oldProfile.isNew()) {
            this.startUserProfileCreationWorkflow(context, profile);
            try {
                AuthenticationManager mgr = (AuthenticationManager)this.m_engine.getManager(AuthenticationManager.class);
                if (!mgr.isContainerAuthenticated()) {
                    mgr.login(session, null, profile.getLoginName(), profile.getPassword());
                }
            }
            catch (WikiException e) {
                throw new WikiSecurityException(e.getMessage(), e);
            }
            this.fireEvent(53, session, profile);
        } else {
            if (nameChanged && !oldProfile.getLoginName().equals(profile.getLoginName())) {
                this.getUserDatabase().rename(oldProfile.getLoginName(), profile.getLoginName());
            }
            this.getUserDatabase().save(profile);
            if (nameChanged) {
                UserProfile[] profiles = new UserProfile[]{oldProfile, profile};
                this.fireEvent(54, session, profiles);
            } else {
                this.fireEvent(53, session, profile);
            }
        }
    }

    @Override
    public void startUserProfileCreationWorkflow(Context context, UserProfile profile) throws WikiException {
        WorkflowBuilder builder = WorkflowBuilder.getBuilder(this.m_engine);
        Principal submitter = context.getWikiSession().getUserPrincipal();
        Step completionTask = ((TasksManager)this.m_engine.getManager(TasksManager.class)).buildSaveUserProfileTask(context.getWikiSession().getLocale());
        boolean hasEmail = profile.getEmail() != null;
        Fact[] facts = new Fact[hasEmail ? 4 : 3];
        facts[0] = new Fact("prefs.fullname", (Serializable)((Object)profile.getFullname()));
        facts[1] = new Fact("prefs.loginname", (Serializable)((Object)profile.getLoginName()));
        facts[2] = new Fact("fact.submitter", (Serializable)((Object)submitter.getName()));
        if (hasEmail) {
            facts[3] = new Fact("prefs.email", (Serializable)((Object)profile.getEmail()));
        }
        Workflow workflow = builder.buildApprovalWorkflow(submitter, "workflow.createUserProfile", null, "decision.createUserProfile", facts, completionTask, null);
        workflow.setAttribute("userProfile", profile);
        workflow.start(context);
        boolean approvalRequired = workflow.getCurrentStep() instanceof Decision;
        if (approvalRequired) {
            throw new DecisionRequiredException("This profile must be approved before it becomes active");
        }
    }

    @Override
    public UserProfile parseProfile(Context context) {
        UserProfile profile = this.getUserProfile(context.getWikiSession());
        HttpServletRequest request = context.getHttpRequest();
        String loginName = request.getParameter(PARAM_LOGINNAME);
        String password = request.getParameter(PARAM_PASSWORD);
        String fullname = request.getParameter(PARAM_FULLNAME);
        String email = request.getParameter(PARAM_EMAIL);
        loginName = InputValidator.isBlank(loginName) ? null : loginName;
        password = InputValidator.isBlank(password) ? null : password;
        fullname = InputValidator.isBlank(fullname) ? null : fullname;
        String string = email = InputValidator.isBlank(email) ? null : email;
        if (((AuthenticationManager)this.m_engine.getManager(AuthenticationManager.class)).isContainerAuthenticated() && context.getWikiSession().isAuthenticated()) {
            loginName = context.getWikiSession().getLoginPrincipal().getName();
        }
        profile.setLoginName(loginName);
        profile.setEmail(email);
        profile.setFullname(fullname);
        profile.setPassword(password);
        return profile;
    }

    @Override
    public void validateProfile(Context context, UserProfile profile) {
        Object[] args2;
        UserProfile otherProfile;
        Session session = context.getWikiSession();
        InputValidator validator = new InputValidator(SESSION_MESSAGES, context);
        ResourceBundle rb = Preferences.getBundle(context, "CoreResources");
        FilterManager fm = (FilterManager)this.m_engine.getManager(FilterManager.class);
        List<PageFilter> ls = fm.getFilterList();
        for (PageFilter pf : ls) {
            if (!(pf instanceof SpamFilter)) continue;
            if (((SpamFilter)pf).isValidUserProfile(context, profile)) break;
            session.addMessage(SESSION_MESSAGES, "Invalid userprofile");
            return;
        }
        if (((AuthenticationManager)this.m_engine.getManager(AuthenticationManager.class)).isContainerAuthenticated() && !context.getWikiSession().isAuthenticated()) {
            session.addMessage(SESSION_MESSAGES, rb.getString("security.error.createprofilebeforelogin"));
        }
        validator.validateNotNull(profile.getLoginName(), rb.getString("security.user.loginname"));
        validator.validateNotNull(profile.getFullname(), rb.getString("security.user.fullname"));
        validator.validate(profile.getEmail(), rb.getString("security.user.email"), 1);
        if (!((AuthenticationManager)this.m_engine.getManager(AuthenticationManager.class)).isContainerAuthenticated()) {
            String password = profile.getPassword();
            if (password == null) {
                session.addMessage(SESSION_MESSAGES, rb.getString("security.error.blankpassword"));
            } else {
                String password2;
                HttpServletRequest request = context.getHttpRequest();
                String password0 = request == null ? null : request.getParameter("password0");
                String string = password2 = request == null ? null : request.getParameter("password2");
                if (!password.equals(password2)) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.passwordnomatch"));
                }
                if (!profile.isNew() && !this.getUserDatabase().validatePassword(profile.getLoginName(), password0)) {
                    session.addMessage(SESSION_MESSAGES, rb.getString("security.error.passwordnomatch"));
                }
            }
        }
        String fullName = profile.getFullname();
        String loginName = profile.getLoginName();
        String email = profile.getEmail();
        try {
            otherProfile = this.getUserDatabase().find(fullName);
            if (otherProfile != null && !profile.equals(otherProfile) && !fullName.equals(otherProfile.getFullname())) {
                args2 = new Object[]{fullName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalfullname"), args2));
            }
        }
        catch (NoSuchPrincipalException args2) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().find(loginName);
            if (otherProfile != null && !profile.equals(otherProfile) && !loginName.equals(otherProfile.getLoginName())) {
                args2 = new Object[]{loginName};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.illegalloginname"), args2));
            }
        }
        catch (NoSuchPrincipalException args3) {
            // empty catch block
        }
        try {
            otherProfile = this.getUserDatabase().findByEmail(email);
            if (otherProfile != null && !profile.getUid().equals(otherProfile.getUid()) && !profile.equals(otherProfile) && StringUtils.lowerCase((String)email).equals(StringUtils.lowerCase((String)otherProfile.getEmail()))) {
                args2 = new Object[]{email};
                session.addMessage(SESSION_MESSAGES, MessageFormat.format(rb.getString("security.error.email.taken"), args2));
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
    }

    @Override
    public Principal[] listWikiNames() throws WikiSecurityException {
        return this.getUserDatabase().getWikiNames();
    }

    @Override
    public synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    @Override
    public synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    public static final class JSONUserModule
    implements WikiAjaxServlet {
        private final DefaultUserManager m_manager;

        public JSONUserModule(DefaultUserManager mgr) {
            this.m_manager = mgr;
        }

        @Override
        public String getServletMapping() {
            return "users";
        }

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp, String actionName, List<String> params) throws ServletException, IOException {
            try {
                if (params.size() < 1) {
                    return;
                }
                String uid = params.get(0);
                LOG.debug("uid=" + uid);
                if (StringUtils.isNotBlank((CharSequence)uid)) {
                    UserProfile prof = this.getUserInfo(uid);
                    resp.getWriter().write(AjaxUtil.toJson(prof));
                }
            }
            catch (NoSuchPrincipalException e) {
                throw new ServletException((Throwable)((Object)e));
            }
        }

        public UserProfile getUserInfo(String uid) throws NoSuchPrincipalException {
            if (this.m_manager != null) {
                return this.m_manager.getUserDatabase().find(uid);
            }
            throw new IllegalStateException("The manager is offline.");
        }
    }
}

