/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.WebAuthorizer;
import org.apache.wiki.auth.authorize.WebContainerAuthorizer;
import org.apache.wiki.auth.login.AnonymousLoginModule;
import org.apache.wiki.auth.login.CookieAssertionLoginModule;
import org.apache.wiki.auth.login.CookieAuthenticationLoginModule;
import org.apache.wiki.auth.login.UserDatabaseLoginModule;
import org.apache.wiki.auth.login.WebContainerCallbackHandler;
import org.apache.wiki.auth.login.WebContainerLoginModule;
import org.apache.wiki.auth.login.WikiCallbackHandler;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.TimedCounterList;

public class DefaultAuthenticationManager
implements AuthenticationManager {
    private static final long LASTLOGINS_CLEANUP_TIME = 600000L;
    private static final long MAX_LOGIN_DELAY = 20000L;
    private static final Logger LOG = LogManager.getLogger(DefaultAuthenticationManager.class);
    protected static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    protected Class<? extends LoginModule> m_loginModuleClass = UserDatabaseLoginModule.class;
    protected final Map<String, String> m_loginModuleOptions = new HashMap<String, String>();
    private static final String DEFAULT_LOGIN_MODULE = "org.apache.wiki.auth.login.UserDatabaseLoginModule";
    private static final Set<Principal> NO_PRINCIPALS = new HashSet<Principal>();
    private boolean m_allowsCookieAssertions = true;
    private boolean m_throttleLogins = true;
    private boolean m_allowsCookieAuthentication;
    private Engine m_engine;
    private boolean m_storeIPAddress = true;
    private final TimedCounterList<String> m_lastLoginAttempts = new TimedCounterList();

    public void initialize(Engine engine, Properties props) throws WikiException {
        this.m_engine = engine;
        this.m_storeIPAddress = TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.storeIPAddress", (boolean)this.m_storeIPAddress);
        this.m_allowsCookieAssertions = TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.cookieAssertions", (boolean)true);
        this.m_allowsCookieAuthentication = TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.cookieAuthentication", (boolean)false);
        this.m_throttleLogins = TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.login.throttling", (boolean)true);
        String loginModuleClassName = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.loginModule.class", (String)DEFAULT_LOGIN_MODULE);
        try {
            this.m_loginModuleClass = ClassUtil.findClass((String)"", (String)loginModuleClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new WikiException("Could not instantiate LoginModule class.", (Throwable)e);
        }
        this.initLoginModuleOptions(props);
    }

    @Override
    public boolean isContainerAuthenticated() {
        try {
            Authorizer authorizer = ((AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class)).getAuthorizer();
            if (authorizer instanceof WebContainerAuthorizer) {
                return ((WebContainerAuthorizer)authorizer).isContainerAuthorized();
            }
        }
        catch (WikiException wikiException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean login(HttpServletRequest request) throws WikiSecurityException {
        Set<Principal> principals;
        HttpSession httpSession = request.getSession();
        Session session = SessionMonitor.getInstance(this.m_engine).find(httpSession);
        AuthenticationManager authenticationMgr = (AuthenticationManager)this.m_engine.getManager(AuthenticationManager.class);
        AuthorizationManager authorizationMgr = (AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class);
        WebContainerCallbackHandler handler = null;
        Map<String, String> options = EMPTY_MAP;
        if (!session.isAuthenticated()) {
            handler = new WebContainerCallbackHandler(this.m_engine, request);
            principals = authenticationMgr.doJAASLogin(WebContainerLoginModule.class, handler, options);
            if (principals.size() == 0 && authenticationMgr.allowsCookieAuthentication()) {
                principals = authenticationMgr.doJAASLogin(CookieAuthenticationLoginModule.class, handler, options);
            }
            if (principals.size() > 0) {
                this.fireEvent(40, this.getLoginPrincipal(principals), session);
                for (Principal principal : principals) {
                    this.fireEvent(35, principal, session);
                }
                this.injectAuthorizerRoles(session, authorizationMgr.getAuthorizer(), request);
            }
        }
        if (!session.isAuthenticated() && authenticationMgr.allowsCookieAssertions() && (principals = authenticationMgr.doJAASLogin(CookieAssertionLoginModule.class, handler, options)).size() > 0) {
            this.fireEvent(32, this.getLoginPrincipal(principals), session);
        }
        if (session.isAnonymous() && (principals = authenticationMgr.doJAASLogin(AnonymousLoginModule.class, handler, options)).size() > 0) {
            this.fireEvent(31, this.getLoginPrincipal(principals), session);
            return true;
        }
        return false;
    }

    @Override
    public boolean login(Session session, HttpServletRequest request, String username, String password) throws WikiSecurityException {
        WikiCallbackHandler handler;
        Set<Principal> principals;
        if (session == null) {
            LOG.error("No wiki session provided, cannot log in.");
            return false;
        }
        if (this.m_throttleLogins) {
            this.delayLogin(username);
        }
        if ((principals = this.doJAASLogin(this.m_loginModuleClass, handler = new WikiCallbackHandler(this.m_engine, null, username, password), this.m_loginModuleOptions)).size() > 0) {
            this.fireEvent(40, this.getLoginPrincipal(principals), session);
            for (Principal principal : principals) {
                this.fireEvent(35, principal, session);
            }
            this.injectAuthorizerRoles(session, ((AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class)).getAuthorizer(), null);
            return true;
        }
        return false;
    }

    private void delayLogin(String username) {
        try {
            this.m_lastLoginAttempts.cleanup(600000L);
            int count = this.m_lastLoginAttempts.count((Object)username);
            long delay = Math.min(1L << count, 20000L);
            LOG.debug("Sleeping for " + delay + " ms to allow login.");
            Thread.sleep(delay);
            this.m_lastLoginAttempts.add((Object)username);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void logout(HttpServletRequest request) {
        if (request == null) {
            LOG.error("No HTTP reqest provided; cannot log out.");
            return;
        }
        HttpSession session = request.getSession();
        String sid = session == null ? "(null)" : session.getId();
        LOG.debug("Invalidating Session for session ID= {}", (Object)sid);
        Session wikiSession = Wiki.session().find(this.m_engine, request);
        Principal originalPrincipal = wikiSession.getLoginPrincipal();
        wikiSession.invalidate();
        Wiki.session().remove(this.m_engine, request);
        if (session != null) {
            session.invalidate();
        }
        this.fireEvent(44, originalPrincipal, null);
    }

    @Override
    public boolean allowsCookieAssertions() {
        return this.m_allowsCookieAssertions;
    }

    @Override
    public boolean allowsCookieAuthentication() {
        return this.m_allowsCookieAuthentication;
    }

    @Override
    public Set<Principal> doJAASLogin(Class<? extends LoginModule> clazz, CallbackHandler handler, Map<String, String> options) throws WikiSecurityException {
        LoginModule loginModule;
        try {
            loginModule = (LoginModule)ClassUtil.buildInstance(clazz);
        }
        catch (ReflectiveOperationException e) {
            throw new WikiSecurityException(e.getMessage(), e);
        }
        Subject subject = new Subject();
        loginModule.initialize(subject, handler, EMPTY_MAP, options);
        boolean loginSucceeded = false;
        boolean commitSucceeded = false;
        try {
            loginSucceeded = loginModule.login();
            if (loginSucceeded) {
                commitSucceeded = loginModule.commit();
            }
        }
        catch (LoginException loginException) {
            // empty catch block
        }
        if (loginSucceeded && commitSucceeded) {
            return subject.getPrincipals();
        }
        return NO_PRINCIPALS;
    }

    @Override
    public synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    @Override
    public synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    private void initLoginModuleOptions(Properties props) {
        for (Object key : props.keySet()) {
            String optionKey;
            String propName = key.toString();
            if (!propName.startsWith("jspwiki.loginModule.options.") || (optionKey = propName.substring("jspwiki.loginModule.options.".length()).trim()).isEmpty()) continue;
            String optionValue = props.getProperty(propName);
            if (this.m_loginModuleOptions.containsKey(optionKey)) {
                throw new IllegalArgumentException("JAAS LoginModule key " + propName + " cannot be specified twice!");
            }
            this.m_loginModuleOptions.put(optionKey, optionValue);
        }
    }

    private void injectAuthorizerRoles(Session session, Authorizer authorizer, HttpServletRequest request) {
        for (Principal role : authorizer.getRoles()) {
            WebAuthorizer wa;
            if (authorizer.isUserInRole(session, role)) {
                this.fireEvent(35, role, session);
                LOG.debug("Added authorizer role {}.", (Object)role.getName());
                continue;
            }
            if (request == null || !(authorizer instanceof WebAuthorizer) || !(wa = (WebAuthorizer)authorizer).isUserInRole(request, role)) continue;
            this.fireEvent(35, role, session);
            LOG.debug("Added container role {}.", (Object)role.getName());
        }
    }
}

