/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.engine.Initializable;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiSecurityEvent;

public interface AuthenticationManager
extends Initializable {
    public static final String PROP_STOREIPADDRESS = "jspwiki.storeIPAddress";
    public static final String PROP_ALLOW_COOKIE_AUTH = "jspwiki.cookieAuthentication";
    public static final String PROP_LOGIN_THROTTLING = "jspwiki.login.throttling";
    public static final String PREFIX_LOGIN_MODULE_OPTIONS = "jspwiki.loginModule.options.";
    public static final String PROP_ALLOW_COOKIE_ASSERTIONS = "jspwiki.cookieAssertions";
    public static final String PROP_LOGIN_MODULE = "jspwiki.loginModule.class";

    public boolean isContainerAuthenticated();

    public boolean login(HttpServletRequest var1) throws WikiSecurityException;

    public boolean login(Session var1, HttpServletRequest var2, String var3, String var4) throws WikiSecurityException;

    public void logout(HttpServletRequest var1);

    public boolean allowsCookieAssertions();

    public boolean allowsCookieAuthentication();

    public Set<Principal> doJAASLogin(Class<? extends LoginModule> var1, CallbackHandler var2, Map<String, String> var3) throws WikiSecurityException;

    public static boolean isRolePrincipal(Principal principal) {
        return principal instanceof Role || principal instanceof GroupPrincipal;
    }

    public static boolean isUserPrincipal(Principal principal) {
        return !AuthenticationManager.isRolePrincipal(principal);
    }

    default public Principal getLoginPrincipal(Set<Principal> principals) {
        for (Principal principal : principals) {
            if (!AuthenticationManager.isUserPrincipal(principal)) continue;
            return principal;
        }
        return null;
    }

    public void addWikiEventListener(WikiEventListener var1);

    public void removeWikiEventListener(WikiEventListener var1);

    default public void fireEvent(int type, Principal principal, Object target) {
        if (WikiEventManager.isListening((Object)this)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiSecurityEvent((Object)this, type, principal, target));
        }
    }
}

