/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.cache;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.engine.Initializable;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.cache.CacheInfo;
import org.apache.wiki.cache.CachingManager;
import org.apache.wiki.util.CheckedSupplier;
import org.apache.wiki.util.TextUtil;

public class EhcacheCachingManager
implements CachingManager,
Initializable {
    private static final Logger LOG = LogManager.getLogger(EhcacheCachingManager.class);
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private static final int DEFAULT_CACHE_EXPIRY_PERIOD = 86400;
    final Map<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    final Map<String, CacheInfo> cacheStats = new ConcurrentHashMap<String, CacheInfo>();
    CacheManager cacheManager;

    @Override
    public void shutdown() {
        if (this.cacheMap.size() > 0) {
            CacheManager.getInstance().shutdown();
            this.cacheMap.clear();
            this.cacheStats.clear();
        }
    }

    public void initialize(Engine engine, Properties props) throws WikiException {
        String cacheEnabled = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.cache.enable", (String)"jspwiki.usePageCache", (String)"true");
        boolean useCache = "true".equalsIgnoreCase(cacheEnabled);
        String confLocation = "/" + TextUtil.getStringProperty((Properties)props, (String)"jspwiki.cache.config-file", (String)"ehcache-jspwiki.xml");
        if (useCache) {
            URL location = this.getClass().getResource(confLocation);
            LOG.info("Reading ehcache configuration file from classpath on /{}", (Object)location);
            this.cacheManager = CacheManager.create((URL)location);
            this.registerCache("jspwiki.attachmentsCache");
            this.registerCache("jspwiki.attachmentCollectionsCache");
            this.registerCache("jspwiki.dynamicAttachmentCache");
            this.registerCache("jspwiki.renderingCache");
            this.registerCache("jspwiki.pageCache");
            this.registerCache("jspwiki.pageHistoryCache");
            this.registerCache("jspwiki.pageTextCache");
        }
    }

    void registerCache(String cacheName) {
        Cache cache;
        if (this.cacheManager.cacheExists(cacheName)) {
            cache = this.cacheManager.getCache(cacheName);
        } else {
            LOG.info("cache with name {} not found in ehcache configuration file, creating it with defaults.", (Object)cacheName);
            cache = new Cache(cacheName, 1000, false, false, 86400L, 86400L);
            this.cacheManager.addCache(cache);
        }
        this.cacheMap.put(cacheName, cache);
        this.cacheStats.put(cacheName, new CacheInfo(cacheName, cache.getCacheConfiguration().getMaxEntriesLocalHeap()));
    }

    @Override
    public boolean enabled(String cacheName) {
        return this.cacheMap.get(cacheName) != null;
    }

    @Override
    public CacheInfo info(String cacheName) {
        if (this.enabled(cacheName)) {
            return this.cacheStats.get(cacheName);
        }
        return null;
    }

    public List<String> keys(String cacheName) {
        if (this.enabled(cacheName)) {
            return this.cacheMap.get(cacheName).getKeysWithExpiryCheck();
        }
        return Collections.emptyList();
    }

    @Override
    public <T, E extends Exception> T get(String cacheName, Serializable key, CheckedSupplier<T, E> supplier) throws E {
        if (this.keyAndCacheAreNotNull(cacheName, key)) {
            Element element = this.cacheMap.get(cacheName).get(key);
            if (element != null) {
                this.cacheStats.get(cacheName).hit();
                return (T)element.getObjectValue();
            }
            Object value = supplier.get();
            if (value != null) {
                this.cacheStats.get(cacheName).miss();
                this.cacheMap.get(cacheName).put(new Element((Object)key, value));
            }
            return (T)value;
        }
        return null;
    }

    @Override
    public void put(String cacheName, Serializable key, Object val) {
        if (this.keyAndCacheAreNotNull(cacheName, key)) {
            this.cacheMap.get(cacheName).put(new Element((Object)key, val));
        }
    }

    @Override
    public void remove(String cacheName, Serializable key) {
        if (this.keyAndCacheAreNotNull(cacheName, key)) {
            this.cacheMap.get(cacheName).remove(key);
        }
    }

    boolean keyAndCacheAreNotNull(String cacheName, Serializable key) {
        return this.enabled(cacheName) && key != null;
    }
}

