/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.api.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.wiki.api.engine.EngineLifecycleExtension;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.util.TextUtil;

public interface Engine {
    public static final String DEFAULT_INLINEPATTERN = "*.png";
    public static final String DEFAULT_TEMPLATE_NAME = "default";
    public static final String PROP_APPNAME = "jspwiki.applicationName";
    public static final String PROP_INLINEIMAGEPTRN = "jspwiki.translatorReader.inlinePattern";
    public static final String PROP_INTERWIKIREF = "jspwiki.interWikiRef.";
    public static final String PROP_SEARCHPATH = "jspwiki.plugin.searchPath";
    public static final String PROP_STOREUSERNAME = "jspwiki.storeUserName";
    public static final String PROP_ENCODING = "jspwiki.encoding";
    public static final String PROP_NO_FILTER_ENCODING = "jspwiki.nofilterencoding";
    public static final String PROP_WORKDIR = "jspwiki.workDir";
    public static final String PREFS_COOKIE_NAME = "JSPWikiUserProfile";
    public static final String PROP_MATCHPLURALS = "jspwiki.translatorReader.matchEnglishPlurals";
    public static final String PROP_TEMPLATEDIR = "jspwiki.templateDir";
    public static final String PROP_FRONTPAGE = "jspwiki.frontPage";
    public static final String PROP_URLCONSTRUCTOR = "jspwiki.urlConstructor";
    public static final String PROP_ACL_MANAGER_IMPL = "jspwiki.aclManager";
    public static final String PROP_ALLOW_CREATION_OF_EMPTY_PAGES = "jspwiki.allowCreationOfEmptyPages";

    default public <E extends Engine> E adapt(Class<E> cls) {
        return (E)this;
    }

    public <T> T getManager(Class<T> var1);

    public <T> List<T> getManagers(Class<T> var1);

    public boolean isConfigured();

    public Properties getWikiProperties();

    public String getWorkDir();

    public String getTemplateDir();

    default public String getPluginSearchPath() {
        return TextUtil.getStringProperty((Properties)this.getWikiProperties(), (String)PROP_SEARCHPATH, null);
    }

    public Date getStartTime();

    public String getBaseURL();

    public String getGlobalRSSURL();

    public String getInterWikiURL(String var1);

    public String getURL(String var1, String var2, String var3);

    public String getFrontPage();

    public ServletContext getServletContext();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public URL findConfigFile(String name) {
        File tmpFile;
        LogManager.getLogger(Engine.class).info("looking for " + name + " inside WEB-INF ");
        File defaultFile = null;
        if (this.getRootPath() != null) {
            defaultFile = new File(this.getRootPath() + "/WEB-INF/" + name);
        }
        if (defaultFile != null && defaultFile.exists()) {
            try {
                return defaultFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LogManager.getLogger(Engine.class).warn("Malformed URL: " + e.getMessage());
            }
        }
        URL path = null;
        if (this.getServletContext() == null) return path;
        try {
            tmpFile = File.createTempFile("temp." + name, "");
        }
        catch (IOException e) {
            LogManager.getLogger(Engine.class).error("unable to create a temp file to load onto the policy", (Throwable)e);
            return null;
        }
        tmpFile.deleteOnExit();
        LogManager.getLogger(Engine.class).info("looking for /" + name + " on classpath");
        try (InputStream is = Engine.class.getResourceAsStream("/" + name);
             OutputStream os = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);){
            int bytes;
            if (is == null) {
                throw new FileNotFoundException(name + " not found");
            }
            URL url = this.getServletContext().getResource("/WEB-INF/" + name);
            if (url != null) {
                URL uRL = url;
                return uRL;
            }
            byte[] buff = new byte[1024];
            while ((bytes = is.read(buff)) != -1) {
                os.write(buff, 0, bytes);
            }
            path = tmpFile.toURI().toURL();
            return path;
        }
        catch (MalformedURLException e) {
            LogManager.getLogger(Engine.class).fatal("Your code is b0rked.  You are a bad person.", (Throwable)e);
            return path;
        }
        catch (IOException e) {
            LogManager.getLogger(Engine.class).error("failed to load security policy from file " + name + ",stacktrace follows", (Throwable)e);
        }
        return path;
    }

    public Collection<String> getAllInterWikiLinks();

    public Collection<String> getAllInlinedImagePatterns();

    public String getSpecialPageReference(String var1);

    public String getApplicationName();

    public String getRootPath();

    public String getFinalPageName(String var1) throws ProviderException;

    public String encodeName(String var1);

    public String decodeName(String var1);

    public Charset getContentEncoding();

    public void addWikiEventListener(WikiEventListener var1);

    public void removeWikiEventListener(WikiEventListener var1);

    public void setAttribute(String var1, Object var2);

    public <T> T getAttribute(String var1);

    public <T> T removeAttribute(String var1);

    default public void start(Properties properties) throws WikiException {
        ServiceLoader<EngineLifecycleExtension> loader = ServiceLoader.load(EngineLifecycleExtension.class);
        for (EngineLifecycleExtension extension : loader) {
            extension.onInit(properties);
        }
        this.initialize(properties);
        for (EngineLifecycleExtension extension : loader) {
            extension.onStart(this, properties);
        }
    }

    default public void stop() {
        ServiceLoader<EngineLifecycleExtension> loader = ServiceLoader.load(EngineLifecycleExtension.class);
        for (EngineLifecycleExtension extension : loader) {
            extension.onShutdown(this, this.getWikiProperties());
        }
        this.shutdown();
    }

    public void initialize(Properties var1) throws WikiException;

    public void shutdown();
}

