/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.url.URLConstructor;

public class WikiServlet
extends HttpServlet {
    private static final long serialVersionUID = 3258410651167633973L;
    private Engine m_engine;
    private static final Logger log = LogManager.getLogger((String)WikiServlet.class.getName());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_engine = Wiki.engine().find(config);
        log.info("WikiServlet initialized.");
    }

    public void destroy() {
        log.info("WikiServlet shutdown.");
        this.m_engine.shutdown();
        super.destroy();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String pageName = URLConstructor.parsePageFromURL(req, this.m_engine.getContentEncoding());
        log.info("Request for page: {}", (Object)pageName);
        if (pageName == null) {
            pageName = this.m_engine.getFrontPage();
        }
        String jspPage = ((URLConstructor)this.m_engine.getManager(URLConstructor.class)).getForwardPage(req);
        RequestDispatcher dispatcher = req.getRequestDispatcher("/" + jspPage + "?page=" + this.m_engine.encodeName(pageName) + "&" + req.getQueryString());
        dispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }
}

