/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.stress;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.apache.wiki.TestEngine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.stress.Benchmark;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;

public class StressTestVersioningProvider {
    public static final String NAME1 = "Test1";
    Properties props = TestEngine.getTestProperties("/jspwiki-vers-custom.properties");
    TestEngine engine = TestEngine.build(this.props);

    @AfterEach
    public void tearDown() {
        String files = this.props.getProperty("jspwiki.fileSystemProvider.pageDir");
        File f = new File(files, "Test1.txt");
        f.delete();
        f = new File(files, "OLD");
        TestEngine.deleteAll(f);
    }

    public void testMillionChanges() throws Exception {
        String text = "";
        String name = NAME1;
        int maxver = 2000;
        Benchmark mark = new Benchmark();
        mark.start();
        for (int i = 0; i < 2000; ++i) {
            text = text + ".";
            this.engine.saveText(NAME1, text);
        }
        mark.stop();
        System.out.println("Benchmark: " + mark.toString(2000) + " pages/second");
        Page pageinfo = ((PageManager)this.engine.getManager(PageManager.class)).getPage(NAME1);
        Assertions.assertEquals((int)2000, (int)pageinfo.getVersion(), (String)"wrong version");
        Assertions.assertEquals((int)2002, (int)((PageManager)this.engine.getManager(PageManager.class)).getText(NAME1).length(), (String)"wrong text");
    }

    private void runMassiveFileTest(int maxpages) throws Exception {
        String text = "Testing, 1, 2, 3: ";
        String name = NAME1;
        Benchmark mark = new Benchmark();
        System.out.println("Building a massive repository of " + maxpages + " pages...");
        mark.start();
        for (int i = 0; i < maxpages; ++i) {
            this.engine.saveText(NAME1 + i, "Testing, 1, 2, 3: " + i);
        }
        mark.stop();
        System.out.println("Total time to save " + maxpages + " pages was " + mark.toString());
        System.out.println("Saved " + mark.toString(maxpages) + " pages/second");
        mark.reset();
        mark.start();
        Collection pages = ((PageManager)this.engine.getManager(PageManager.class)).getAllPages();
        mark.stop();
        System.out.println("Got a list of all pages in " + (Object)((Object)mark));
        mark.reset();
        mark.start();
        for (Page page : pages) {
            String foo = ((PageManager)this.engine.getManager(PageManager.class)).getPureText(page);
            Assertions.assertNotNull((Object)foo);
        }
        mark.stop();
        System.out.println("Read through all of the pages in " + (Object)((Object)mark));
        System.out.println("which is " + mark.toString(maxpages) + " pages/second");
    }

    public void testMillionFiles1() throws Exception {
        this.runMassiveFileTest(100);
    }

    public void testMillionFiles2() throws Exception {
        this.runMassiveFileTest(1000);
    }

    public void testMillionFiles3() throws Exception {
        this.runMassiveFileTest(10000);
    }
}

