/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.mock.MockHttpServletRequest;
import net.sourceforge.stripes.mock.MockHttpSession;
import net.sourceforge.stripes.mock.MockServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.SessionMonitor;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.providers.AbstractFileProvider;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.PropertyReader;
import org.apache.wiki.util.TextUtil;

public class TestEngine
extends WikiEngine {
    private static final Logger log = LogManager.getLogger(TestEngine.class);
    private Session m_adminWikiSession = null;
    private Session m_janneWikiSession = null;
    private Session m_guestWikiSession = null;
    private static Properties combinedProperties = null;

    public Session adminSession() throws WikiSecurityException {
        if (this.m_adminWikiSession == null) {
            MockHttpServletRequest request = this.newHttpRequest();
            this.m_adminWikiSession = WikiSession.getWikiSession((Engine)this, (HttpServletRequest)request);
            ((AuthenticationManager)this.getManager(AuthenticationManager.class)).login(this.m_adminWikiSession, (HttpServletRequest)request, "admin", "myP@5sw0rd");
        }
        return this.m_adminWikiSession;
    }

    public Session guestSession() {
        if (this.m_guestWikiSession == null) {
            MockHttpServletRequest request = this.newHttpRequest();
            this.m_guestWikiSession = WikiSession.getWikiSession((Engine)this, (HttpServletRequest)request);
        }
        return this.m_guestWikiSession;
    }

    public Session janneSession() throws WikiSecurityException {
        if (this.m_janneWikiSession == null) {
            MockHttpServletRequest request = this.newHttpRequest();
            this.m_janneWikiSession = WikiSession.getWikiSession((Engine)this, (HttpServletRequest)request);
            ((AuthenticationManager)this.getManager(AuthenticationManager.class)).login(this.m_janneWikiSession, (HttpServletRequest)request, "janne", "myP@5sw0rd");
        }
        return this.m_janneWikiSession;
    }

    public static TestEngine build() {
        return TestEngine.build(TestEngine.getTestProperties());
    }

    @SafeVarargs
    public static TestEngine build(Map.Entry<String, String> ... entries) {
        Properties properties = TestEngine.getTestProperties();
        for (Map.Entry<String, String> entry : entries) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        return TestEngine.build(properties);
    }

    public static Map.Entry<String, String> with(String prop, String value) {
        return new AbstractMap.SimpleEntry<String, String>(prop, value);
    }

    public static TestEngine build(Properties props) {
        try {
            return new TestEngine(props);
        }
        catch (WikiException we) {
            throw new UnsupportedOperationException("Unable to build TestEngine: " + we.getMessage(), we);
        }
    }

    public TestEngine() throws WikiException {
        this(TestEngine.getTestProperties());
    }

    public TestEngine(Properties props) throws WikiException {
        super((ServletContext)TestEngine.createServletContext("test"), "test", TestEngine.cleanTestProps(props));
        ServletContext servletContext = this.getServletContext();
        servletContext.setAttribute("org.apache.wiki.WikiEngine", (Object)this);
    }

    public static MockServletContext createServletContext(String contextName) {
        return new MockServletContext(contextName){

            public int getMajorVersion() {
                return 3;
            }

            public int getMinorVersion() {
                return 1;
            }
        };
    }

    public MockHttpServletRequest newHttpRequest() {
        return this.newHttpRequest("/Wiki.jsp");
    }

    public MockHttpServletRequest newHttpRequest(String path) {
        MockHttpServletRequest request = new MockHttpServletRequest("/JSPWiki", path){

            public ServletContext getServletContext() {
                return TestEngine.createServletContext("/JSPWiki");
            }
        };
        request.setSession((HttpSession)new MockHttpSession(this.getServletContext()));
        request.addLocale(new Locale(""));
        return request;
    }

    public static void emptyWorkDir() {
        TestEngine.emptyWorkDir(null);
    }

    public static void emptyWorkDir(Properties properties) {
        File f;
        String workdir;
        if (properties == null) {
            properties = TestEngine.getTestProperties();
        }
        if ((workdir = properties.getProperty("jspwiki.workDir")) != null && (f = new File(workdir)).exists() && f.isDirectory() && new File(f, "refmgr.ser").exists()) {
            TestEngine.deleteAll(f);
        }
    }

    public static void emptyWikiDir() {
        TestEngine.emptyWikiDir(null);
    }

    public static void emptyWikiDir(Properties properties) {
        File f;
        String wikidir;
        if (properties == null) {
            properties = TestEngine.getTestProperties();
        }
        if ((wikidir = properties.getProperty("jspwiki.fileSystemProvider.pageDir")) != null && (f = new File(wikidir)).exists() && f.isDirectory()) {
            TestEngine.deleteAll(f);
        }
    }

    public static Properties getTestProperties() {
        if (combinedProperties == null) {
            combinedProperties = PropertyReader.getCombinedProperties((String)"/jspwiki-custom.properties");
        }
        Properties propCopy = new Properties();
        propCopy.putAll((Map<?, ?>)combinedProperties);
        return propCopy;
    }

    public static Properties getTestProperties(String customPropFile) {
        return PropertyReader.getCombinedProperties((String)customPropFile);
    }

    public static void deleteAll(File file) {
        if (file != null) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File file2 : files) {
                    if (file2.isDirectory()) {
                        TestEngine.deleteAll(file2);
                    }
                    file2.delete();
                }
            }
            file.delete();
        }
    }

    protected static String mangleName(String pagename) {
        Properties properties = new Properties();
        String m_encoding = properties.getProperty("jspwiki.encoding", AbstractFileProvider.DEFAULT_ENCODING);
        pagename = TextUtil.urlEncode((String)pagename, (String)m_encoding);
        pagename = TextUtil.replaceString((String)pagename, (String)"/", (String)"%2F");
        return pagename;
    }

    public void deleteTestPage(String name) {
        Properties properties = TestEngine.getTestProperties();
        try {
            String files = properties.getProperty("jspwiki.fileSystemProvider.pageDir");
            File f = new File(files, TestEngine.mangleName(name) + ".txt");
            f.delete();
            f = new File(files, TestEngine.mangleName(name) + ".properties");
            if (f.exists()) {
                f.delete();
            }
            TestEngine.deleteAttachments(name);
            this.firePageEvent(27, name);
        }
        catch (Exception e) {
            log.error("Couldn't delete " + name, (Throwable)e);
        }
    }

    public static void deleteAttachments(String page) {
        Properties properties = TestEngine.getTestProperties();
        try {
            String files = properties.getProperty("jspwiki.basicAttachmentProvider.storageDir");
            File f = new File(files, TextUtil.urlEncodeUTF8((String)page) + "-att");
            TestEngine.deleteAll(f);
        }
        catch (Exception e) {
            log.error("Could not remove attachments.", (Throwable)e);
        }
    }

    public File makeAttachmentFile() throws Exception {
        File tmpFile = File.createTempFile("test", "txt");
        tmpFile.deleteOnExit();
        try (FileWriter out = new FileWriter(tmpFile);){
            FileUtil.copyContents((Reader)new StringReader("asdfa???dfzbvasdjkfbwfkUg783gqdwog"), (Writer)out);
        }
        return tmpFile;
    }

    public void addAttachment(String pageName, String attachmentName, byte[] data) throws ProviderException, IOException {
        Attachment att = Wiki.contents().attachment((Engine)this, pageName, attachmentName);
        ((AttachmentManager)this.getManager(AttachmentManager.class)).storeAttachment(att, (InputStream)new ByteArrayInputStream(data));
    }

    public void saveText(String pageName, String content) throws WikiException {
        MockHttpServletRequest request = this.newHttpRequest();
        Session wikiSession = SessionMonitor.getInstance((Engine)this).find(request.getSession());
        ((AuthenticationManager)this.getManager(AuthenticationManager.class)).login(wikiSession, (HttpServletRequest)request, "admin", "myP@5sw0rd");
        Page page = Wiki.contents().page((Engine)this, pageName);
        Context context = Wiki.context().create((Engine)this, (HttpServletRequest)request, page);
        ((PageManager)this.getManager(PageManager.class)).saveText(context, content);
    }

    public void saveTextAsJanne(String pageName, String content) throws WikiException {
        MockHttpServletRequest request = this.newHttpRequest();
        Session wikiSession = SessionMonitor.getInstance((Engine)this).find(request.getSession());
        ((AuthenticationManager)this.getManager(AuthenticationManager.class)).login(wikiSession, (HttpServletRequest)request, "janne", "myP@5sw0rd");
        Page page = Wiki.contents().page((Engine)this, pageName);
        page.setAuthor("janne");
        Context context = Wiki.context().create((Engine)this, (HttpServletRequest)request, page);
        ((PageManager)this.getManager(PageManager.class)).saveText(context, content);
    }

    public String getI18nHTML(String pagename) {
        Page page = ((PageManager)this.getManager(PageManager.class)).getPage(pagename, -1);
        Context context = Wiki.context().create((Engine)this, (HttpServletRequest)this.newHttpRequest(), page);
        context.setRequestContext(ContextEnum.PAGE_NONE.getRequestContext());
        return ((RenderingManager)this.getManager(RenderingManager.class)).getHTML(context, page);
    }

    private static Properties cleanTestProps(Properties props) {
        long millis = System.currentTimeMillis();
        props.put("jspwiki.login.throttling", "false");
        props.setProperty("jspwiki.fileSystemProvider.pageDir", TestEngine.cleanNewDirFrom(props.getProperty("jspwiki.fileSystemProvider.pageDir"), millis));
        props.setProperty("jspwiki.basicAttachmentProvider.storageDir", TestEngine.cleanNewDirFrom(props.getProperty("jspwiki.basicAttachmentProvider.storageDir"), millis));
        props.setProperty("jspwiki.workDir", TestEngine.cleanNewDirFrom(props.getProperty("jspwiki.workDir"), millis));
        return props;
    }

    private static String cleanNewDirFrom(String pageDir, long millis) {
        String testEngineCreationOrigin = TestEngine.getTestEngineCreationOrigin();
        if (StringUtils.isBlank((CharSequence)pageDir)) {
            return "target" + File.separator + millis + "-" + testEngineCreationOrigin;
        }
        int lastDirPosition = Math.max(pageDir.lastIndexOf(47), pageDir.lastIndexOf(File.separator));
        if (lastDirPosition == -1) {
            return "target" + File.separator + millis + "-" + testEngineCreationOrigin + "-" + pageDir;
        }
        String stripNumbers = pageDir.substring(lastDirPosition);
        return pageDir.substring(0, lastDirPosition + 1) + millis + "-" + testEngineCreationOrigin + stripNumbers.replaceAll("\\d", "");
    }

    private static String getTestEngineCreationOrigin() {
        for (StackTraceElement trace : Thread.currentThread().getStackTrace()) {
            if (trace.getClassName().contains(TestEngine.class.getSimpleName()) || trace.getClassName().contains(Thread.class.getSimpleName())) continue;
            return trace.getClassName() + "-" + trace.getMethodName().replace("<", "").replace(">", "");
        }
        return "Unable to locate TestEngine creation";
    }
}

