/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.htmltowiki.SyntaxDecorator;
import org.apache.wiki.htmltowiki.WhitespaceTrimWriter;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.htmltowiki.syntax.MarkupHelper;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.xpath.XPathFactory;

public class XHtmlElementToWikiTranslator {
    private static final Logger LOG = LogManager.getLogger(XHtmlElementToWikiTranslator.class);
    private static final String DEFAULT_SYNTAX_DECORATOR = "org.apache.wiki.htmltowiki.syntax.jspwiki.JSPWikiSyntaxDecorator";
    private final Engine e;
    private final XHtmlToWikiConfig config;
    private final WhitespaceTrimWriter outTrimmer = new WhitespaceTrimWriter();
    private final SyntaxDecorator syntax;

    public XHtmlElementToWikiTranslator(Engine e, Element base) throws JDOMException, ReflectiveOperationException {
        this(e, base, new XHtmlToWikiConfig());
    }

    public XHtmlElementToWikiTranslator(Engine e, Element base, XHtmlToWikiConfig config) throws JDOMException, ReflectiveOperationException {
        this.e = e;
        this.config = config;
        this.syntax = this.getSyntaxDecorator();
        PrintWriter out = new PrintWriter(this.outTrimmer);
        ArrayDeque<String> liStack = new ArrayDeque<String>();
        PreDeque preStack = new PreDeque();
        this.syntax.init(out, liStack, preStack, this.outTrimmer, config, this);
        this.translate((Content)base);
    }

    SyntaxDecorator getSyntaxDecorator() throws ReflectiveOperationException {
        String sdClass = this.e.getWikiProperties().getProperty("jspwiki.syntax.decorator", DEFAULT_SYNTAX_DECORATOR);
        if (!ClassUtil.assignable((String)sdClass, (String)SyntaxDecorator.class.getName())) {
            LOG.warn("{} does not subclass {} reverting to default syntax decorator.", (Object)sdClass, (Object)SyntaxDecorator.class.getName());
            sdClass = DEFAULT_SYNTAX_DECORATOR;
        }
        LOG.info("Using {} as markup parser.", (Object)sdClass);
        return (SyntaxDecorator)ClassUtil.buildInstance((String)sdClass);
    }

    public String getWikiString() {
        return this.outTrimmer.toString();
    }

    public void translate(Content element) throws JDOMException {
        if (element instanceof Text) {
            this.translateText((Text)element);
        } else if (element instanceof Element) {
            Element base = (Element)element;
            if ("imageplugin".equals(base.getAttributeValue("class"))) {
                this.translateImage(base);
            } else if ("wikiform".equals(base.getAttributeValue("class"))) {
                this.translateChildren(base);
            } else {
                this.translateParagraph(base);
            }
        }
    }

    public void translateText(Text element) {
        this.syntax.text(element);
    }

    public void translateImage(Element base) {
        String href;
        Element img;
        Element child = XmlUtil.getXPathElement((Element)base, (String)"TBODY/TR/TD/*");
        if (child == null) {
            child = base;
        }
        if (child.getName().equals("A")) {
            img = child.getChild("IMG");
            href = child.getAttributeValue("href");
        } else {
            img = child;
            href = null;
        }
        if (img == null) {
            return;
        }
        String src = this.config.trimLink(img.getAttributeValue("src"));
        if (src == null) {
            return;
        }
        LinkedHashMap<String, Object> imageAttrs = new LinkedHashMap<String, Object>();
        this.putIfNotEmpty(imageAttrs, "align", base.getAttributeValue("align"));
        this.putIfNotEmpty(imageAttrs, "height", img.getAttributeValue("height"));
        this.putIfNotEmpty(imageAttrs, "width", img.getAttributeValue("width"));
        this.putIfNotEmpty(imageAttrs, "alt", img.getAttributeValue("alt"));
        this.putIfNotEmpty(imageAttrs, "caption", this.emptyToNull((Element)XPathFactory.instance().compile("CAPTION").evaluateFirst((Object)base)));
        this.putIfNotEmpty(imageAttrs, "link", href);
        this.putIfNotEmpty(imageAttrs, "border", img.getAttributeValue("border"));
        this.putIfNotEmpty(imageAttrs, "style", base.getAttributeValue("style"));
        this.syntax.image(src, imageAttrs);
    }

    private void putIfNotEmpty(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private String emptyToNull(Element e) {
        if (e == null) {
            return null;
        }
        String s = e.getText();
        return s == null ? null : (s.replaceAll("\\s", "").isEmpty() ? null : s);
    }

    private Map<Object, Object> getStylePropertiesLowerCase(Element base) {
        String align;
        String n = base.getName().toLowerCase();
        String style = base.getAttributeValue("style");
        if (style == null) {
            style = "";
        }
        if ((n.equals("p") || n.equals("div")) && (align = base.getAttributeValue("align")) != null && !style.contains("text-align")) {
            style = style + ";text-align:" + align + ";";
        }
        if (n.equals("font")) {
            String color = base.getAttributeValue("color");
            String face = base.getAttributeValue("face");
            String size = base.getAttributeValue("size");
            if (color != null) {
                style = style + "color:" + color + ";";
            }
            if (face != null) {
                style = style + "font-family:" + face + ";";
            }
            if (size != null) {
                switch (size) {
                    case "1": {
                        style = style + "font-size:xx-small;";
                        break;
                    }
                    case "2": {
                        style = style + "font-size:x-small;";
                        break;
                    }
                    case "3": {
                        style = style + "font-size:small;";
                        break;
                    }
                    case "4": {
                        style = style + "font-size:medium;";
                        break;
                    }
                    case "5": {
                        style = style + "font-size:large;";
                        break;
                    }
                    case "6": {
                        style = style + "font-size:x-large;";
                        break;
                    }
                    case "7": {
                        style = style + "font-size:xx-large;";
                    }
                }
            }
        }
        if (style.equals("")) {
            return null;
        }
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        Arrays.stream(style.toLowerCase().split(";")).filter(StringUtils::isNotEmpty).forEach(prop -> m.put(prop.split(":")[0].trim(), prop.split(":")[1].trim()));
        return m;
    }

    private String propsToStyleString(Map<Object, Object> styleProps) {
        StringBuilder style = new StringBuilder();
        for (Map.Entry<Object, Object> entry : styleProps.entrySet()) {
            style.append(" ").append(entry.getKey()).append(": ").append(entry.getValue()).append(";");
        }
        return style.toString();
    }

    public void translateChildren(Element base) throws JDOMException {
        for (Content c : base.getContent()) {
            if (c instanceof Element) {
                String n;
                Element e = (Element)c;
                switch (n = e.getName().toLowerCase()) {
                    case "h1": {
                        this.syntax.h1(e);
                        break;
                    }
                    case "h2": {
                        this.syntax.h2(e);
                        break;
                    }
                    case "h3": {
                        this.syntax.h3(e);
                        break;
                    }
                    case "h4": {
                        this.syntax.h4(e);
                        break;
                    }
                    case "p": {
                        this.syntax.p(e);
                        break;
                    }
                    case "br": {
                        this.syntax.br(base, e);
                        break;
                    }
                    case "hr": {
                        this.syntax.hr(e);
                        break;
                    }
                    case "table": {
                        this.syntax.table(e);
                        break;
                    }
                    case "tbody": {
                        this.syntax.tbody(e);
                        break;
                    }
                    case "tr": {
                        this.syntax.tr(e);
                        break;
                    }
                    case "td": {
                        this.syntax.td(e);
                        break;
                    }
                    case "thead": {
                        this.syntax.thead(e);
                        break;
                    }
                    case "th": {
                        this.syntax.th(e);
                        break;
                    }
                    case "a": {
                        this.translateA(e);
                        break;
                    }
                    case "b": 
                    case "strong": {
                        this.syntax.strong(e);
                        break;
                    }
                    case "i": 
                    case "em": 
                    case "address": {
                        this.syntax.em(e);
                        break;
                    }
                    case "u": {
                        this.syntax.underline(e);
                        break;
                    }
                    case "strike": {
                        this.syntax.strike(e);
                        break;
                    }
                    case "sub": {
                        this.syntax.sub(e);
                        break;
                    }
                    case "sup": {
                        this.syntax.sup(e);
                        break;
                    }
                    case "dl": {
                        this.syntax.dl(e);
                        break;
                    }
                    case "dt": {
                        this.syntax.dt(e);
                        break;
                    }
                    case "dd": {
                        this.syntax.dd(e);
                        break;
                    }
                    case "ul": {
                        this.syntax.ul(e);
                        break;
                    }
                    case "ol": {
                        this.syntax.ol(e);
                        break;
                    }
                    case "li": {
                        this.syntax.li(base, e);
                        break;
                    }
                    case "pre": {
                        this.syntax.pre(e);
                        break;
                    }
                    case "code": 
                    case "tt": {
                        this.syntax.code(e);
                        break;
                    }
                    case "img": {
                        this.syntax.img(e);
                        break;
                    }
                    case "form": {
                        this.syntax.form(e);
                        break;
                    }
                    case "input": {
                        this.syntax.input(e);
                        break;
                    }
                    case "textarea": {
                        this.syntax.textarea(e);
                        break;
                    }
                    case "select": {
                        this.syntax.select(e);
                        break;
                    }
                    case "option": {
                        this.syntax.option(base, e);
                        break;
                    }
                    default: {
                        this.translate((Content)e);
                        break;
                    }
                }
                continue;
            }
            this.translate(c);
        }
    }

    void translateA(Element e) throws JDOMException {
        if (this.config.isNotIgnorableWikiMarkupLink(e)) {
            if (e.getChild("IMG") != null) {
                this.translateImage(e);
            } else {
                String ref = this.config.trimLink(e.getAttributeValue("href"));
                if (ref == null) {
                    if (MarkupHelper.isUndefinedPageLink(e)) {
                        this.syntax.aUndefined(e);
                    } else {
                        this.translate((Content)e);
                    }
                } else if (MarkupHelper.isFootnoteLink(ref)) {
                    String href = ref.replaceFirst("#ref-.+-(\\d+)", "$1");
                    String textValue = e.getValue().substring(1, e.getValue().length() - 1);
                    this.syntax.aFootnote(textValue, href);
                } else {
                    this.syntax.a(e, ref);
                }
            }
        }
    }

    public void translateParagraph(Element base) throws JDOMException {
        ElementDecoratorData dto = this.buildElementDecoratorDataFrom(base);
        this.syntax.paragraph(dto);
    }

    ElementDecoratorData buildElementDecoratorDataFrom(Element base) {
        String n = base.getName().toLowerCase();
        boolean bold = false;
        boolean italic = false;
        boolean monospace = false;
        String cssSpecial = null;
        String cssClass = base.getAttributeValue("class");
        boolean ignoredCssClass = cssClass != null && cssClass.matches("wikipage|createpage|external|interwiki|attachment|inline-code");
        Map<Object, Object> styleProps = null;
        if (!n.equals("a")) {
            styleProps = this.getStylePropertiesLowerCase(base);
        }
        if ("inline-code".equals(cssClass)) {
            monospace = true;
        }
        if (styleProps != null) {
            String weight = (String)styleProps.remove("font-weight");
            String style = (String)styleProps.remove("font-style");
            if (n.equals("p")) {
                n = "div";
            }
            italic = "oblique".equals(style) || "italic".equals(style);
            boolean bl = bold = "bold".equals(weight) || "bolder".equals(weight);
            if (!styleProps.isEmpty()) {
                cssSpecial = this.propsToStyleString(styleProps);
            }
        }
        ElementDecoratorData dto = new ElementDecoratorData();
        dto.base = base;
        dto.bold = bold;
        dto.cssClass = cssClass;
        dto.cssSpecial = cssSpecial;
        dto.htmlBase = n;
        dto.ignoredCssClass = ignoredCssClass;
        dto.italic = italic;
        dto.monospace = monospace;
        return dto;
    }

    public static class ElementDecoratorData {
        public Element base;
        public String htmlBase;
        public String cssClass;
        public String cssSpecial;
        public boolean monospace;
        public boolean bold;
        public boolean italic;
        public boolean ignoredCssClass;

        private ElementDecoratorData() {
        }
    }

    private class PreDeque
    extends ArrayDeque<String> {
        private PreDeque() {
        }

        @Override
        public void addFirst(String item) {
            super.addFirst(item);
            XHtmlElementToWikiTranslator.this.outTrimmer.setWhitespaceTrimMode(this.isEmpty());
        }

        @Override
        public String removeFirst() {
            String pop = (String)super.removeFirst();
            XHtmlElementToWikiTranslator.this.outTrimmer.setWhitespaceTrimMode(this.isEmpty());
            return pop;
        }
    }
}

