/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.UserDatabaseCallback;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;

public class UserDatabaseLoginModule
extends AbstractLoginModule {
    private static final Logger log = LogManager.getLogger(UserDatabaseLoginModule.class);

    @Override
    public boolean login() throws LoginException {
        UserDatabaseCallback ucb = new UserDatabaseCallback();
        NameCallback ncb = new NameCallback("User name");
        PasswordCallback pcb = new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{ucb, ncb, pcb};
        try {
            this.m_handler.handle(callbacks);
            UserDatabase db = ucb.getUserDatabase();
            String username = ncb.getName();
            String password = new String(pcb.getPassword());
            if (db == null) {
                throw new FailedLoginException("No user database: check the callback handler code!");
            }
            UserProfile profile = db.findByLoginName(username);
            String storedPassword = profile.getPassword();
            if (storedPassword != null && db.validatePassword(username, password)) {
                log.debug("Logged in user database user {}", (Object)username);
                this.m_principals.add(new WikiPrincipal(username, "loginName"));
                return true;
            }
            throw new FailedLoginException("The username or password is incorrect.");
        }
        catch (IOException e) {
            String message = "IO exception; disallowing login.";
            log.error("IO exception; disallowing login.", (Throwable)e);
            throw new LoginException("IO exception; disallowing login.");
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback; disallowing login.";
            log.error("Unable to handle callback; disallowing login.", (Throwable)e);
            throw new LoginException("Unable to handle callback; disallowing login.");
        }
        catch (NoSuchPrincipalException e) {
            throw new FailedLoginException("The username or password is incorrect.");
        }
    }
}

